/*
 *  TYPE.C - type internal command
 *
 *  Comments:
 *
 *  07/08/1998 (John P. Price)
 *    started.
 *
 * 07/12/98 (Rob Lake)
 *    - Changed error messages
 *
 * 27-Jul-1998 (John P Price <linux-guru@gcfl.net>)
 * - added config.h include
 *
 */

#include "config.h"

#ifdef INCLUDE_CMD_TYPE

#include <stdio.h>
#include <string.h>

#include "command.h"

#pragma argsused
int cmd_type(char *first, char *rest)
{
  char buf[128];
  FILE *f;

  if (strcmp(rest, "/?") == 0)
  {
    puts(
          "Displays the contents of text files.\n\n"
          "TYPE [drive:][path]filename"
        );
    return 0;
  }

  if (!*rest)
  {
    error_req_param_missing();
    return 1;
  }

  if (strchr(rest, ' '))
  {
    error_too_many_parameters("\b \b");
    return 1;
  }

  if ((f = fopen(rest, "r")) == NULL)
  {
    error_sfile_not_found(rest);
    return 1;
  }

  while (fgets(buf, sizeof(buf), f))
  {
    fputs(buf, stdout);
  }
  fclose(f);

  return 0;
}

#endif
