/*
   DtDtPnt.c - '..' checking.
   Copyright (C) 2002 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/

#include <stdio.h>
#include <string.h>

#include "fte.h"
#include "..\chkdrvr.h"
#include "..\struct\FstTrMap.h"

static BOOL RootDirChecker(RDWRHandle handle,
                           struct DirectoryPosition* pos,
                           void** structure);

static BOOL FirstClusterFinder(RDWRHandle handle,
                               struct DirectoryPosition* pos,
                               struct DirectoryEntry* entry,
                               void** structure);

static BOOL SubDirChecker(RDWRHandle handle, struct DirectoryPosition* pos,
                          void** structure);
                          
static BOOL RootDirFixer(RDWRHandle handle,
                         struct DirectoryPosition* pos,
                         void** structure);
                               
static BOOL FirstClusterFixer(RDWRHandle handle,
                              struct DirectoryPosition* pos,
                              struct DirectoryEntry* entry,
                              void** structure);
                           
static BOOL SubDirChecker(RDWRHandle handle, struct DirectoryPosition* pos,
                          void** structure);

static BOOL RootDirFixer(RDWRHandle handle,
                           struct DirectoryPosition* pos,
                           void** structure);

static BOOL SubDirFixer(RDWRHandle handle, struct DirectoryPosition* pos,
                        void** structure);

static BOOL CheckDots(RDWRHandle handle, CLUSTER firstcluster,
                      CLUSTER topointto, BOOL* invalid, BOOL fixit);
                      
static BOOL DOTsChecker(RDWRHandle handle,
                        struct DirectoryPosition* pos,
                        void** structure);


struct Pipe
{
   CLUSTER topointto;
   BOOL*   invalid;
   BOOL    fixit;
};

/* Checking */

RETVAL CheckDotDotPointer(RDWRHandle handle)
{
     BOOL invalid, *pinvalid = &invalid;

     if (!TraverseRootDir(handle, RootDirChecker, (void**) &pinvalid, TRUE))
        return ERROR;

     if (!FastWalkDirectoryTree(handle, FirstClusterFinder,
                                (void**) &pinvalid))
        return ERROR;

     return (invalid) ? FAILED : SUCCESS;
}

static BOOL RootDirChecker(RDWRHandle handle,
                           struct DirectoryPosition* pos,
                           void** structure)
{
     BOOL *invalid = *((BOOL**) structure);
     struct DirectoryEntry entry;

     if (!GetDirectory(handle, pos, &entry))
        return FAIL;

     if (IsLFNEntry(&entry))
        return TRUE;

     if (entry.attribute & FA_DIREC)
     {
        if (!CheckDots(handle, GetFirstCluster(&entry), 0, invalid, FALSE))
           return FAIL;
     }

     return TRUE;
}

static BOOL FirstClusterFinder(RDWRHandle handle,
                               struct DirectoryPosition* pos,
			       struct DirectoryEntry* entry,
                               void** structure)
{
     BOOL* invalid = *((BOOL**) structure);
     struct Pipe pipe, *ppipe = &pipe;
     
     pos = pos;

     if (entry->attribute & FA_DIREC)
     {
        pipe.topointto = GetFirstCluster(entry);
        pipe.invalid = invalid;

        if (!TraverseSubdir(handle, GetFirstCluster(entry),
                            SubDirChecker, (void**) &ppipe, TRUE))
        {
           return FAIL;
        }
     }

     return TRUE;
}

static BOOL SubDirChecker(RDWRHandle handle, struct DirectoryPosition* pos,
                          void** structure)
{
     struct Pipe *pipe = *((struct Pipe**) structure);
     struct DirectoryEntry entry;

     if (!GetDirectory(handle, pos, &entry))
        return FAIL;

     if (IsLFNEntry(&entry))
        return TRUE;

     if (entry.attribute & FA_DIREC)
     {
        if (!CheckDots(handle, GetFirstCluster(&entry),
                       pipe->topointto, pipe->invalid,
                       FALSE))
           return FAIL;
     }

     return TRUE;
}

/* Fixing */

RETVAL AdjustDotDotPointer(RDWRHandle handle)
{
     if (!TraverseRootDir(handle, RootDirFixer, NULL, TRUE))
        return ERROR;

     if (!FastWalkDirectoryTree(handle, FirstClusterFixer, NULL))
        return ERROR;

     return SUCCESS;
}

static BOOL RootDirFixer(RDWRHandle handle,
                         struct DirectoryPosition* pos,
                         void** structure)
{
     struct DirectoryEntry entry;

     structure = structure;

     if (!GetDirectory(handle, pos, &entry))
        return FAIL;

     if (IsLFNEntry(&entry))
        return TRUE;

     if (entry.attribute & FA_DIREC)
     {
        if (!CheckDots(handle, GetFirstCluster(&entry), 0, NULL, TRUE))
           return FAIL;
     }

     return TRUE;
}

static BOOL FirstClusterFixer(RDWRHandle handle,
                               struct DirectoryPosition* pos,
                               struct DirectoryEntry* entry,
                               void** structure)
{
     struct Pipe pipe, *ppipe = &pipe;

     structure = structure, pos = pos;
     
     if (IsLFNEntry(entry))
        return TRUE;

     if (entry->attribute & FA_DIREC)
     {
        pipe.topointto = GetFirstCluster(entry);

        if (!TraverseSubdir(handle, GetFirstCluster(entry),
                            SubDirFixer, (void**) &ppipe, TRUE))
        {
           return FAIL;
        }
     }

     return TRUE;
}

static BOOL SubDirFixer(RDWRHandle handle, struct DirectoryPosition* pos,
			void** structure)
{
     struct Pipe *pipe = *((struct Pipe**) structure);
     struct DirectoryEntry entry;

     if (!GetDirectory(handle, pos, &entry))
        return FAIL;

     if (IsLFNEntry(&entry))
        return TRUE;

     if (entry.attribute & FA_DIREC)
     {
        if (!CheckDots(handle, GetFirstCluster(&entry),
                       pipe->topointto, pipe->invalid,
                       TRUE))
           return FAIL;
     }

     return TRUE;
}

/* Common */

static BOOL CheckDots(RDWRHandle handle, CLUSTER firstcluster,
                      CLUSTER topointto, BOOL* invalid, BOOL fixit)
{
   struct Pipe pipe, *ppipe = &pipe;

   pipe.topointto = topointto;
   pipe.invalid   = invalid;
   pipe.fixit     = fixit;

   return TraverseSubdir(handle, firstcluster, DOTsChecker,
                         (void**) &ppipe, TRUE);
}

static BOOL DOTsChecker(RDWRHandle handle,
                        struct DirectoryPosition* pos,
                        void** structure)
{
   struct Pipe *pipe = *((struct Pipe**) structure);
   struct DirectoryEntry entry;
   struct DirectoryPosition pos1 = {0,0};

   if (!GetDirectory(handle, pos, &entry))
      return FAIL;

   if (IsLFNEntry(&entry))
      return TRUE;

   if (entry.attribute & FA_DIREC)
   {
      if (!GetNthSubDirectoryPosition(handle, GetFirstCluster(&entry),
                                      1, &pos1))
         return FAIL;

      if ((pos1.sector == 0) && (pos1.offset == 0))
      {
         if (!pipe->fixit)
            printf("Found a directory without '..'\n");
         return TRUE;
      }

      if (!GetDirectory(handle, pos, &entry))
         return FAIL;

      if (!IsPreviousDir(entry))
      {
         if (!pipe->fixit)
            printf("Found a directory without '..'\n");
         return TRUE;
      }

      if (GetFirstCluster(&entry) != pipe->topointto)
      {
         printf("Found a .. entry that is not pointing to the parent directory\n");
         if (pipe->fixit)
         {
            SetFirstCluster(pipe->topointto, &entry);
            if (!WriteDirectory(handle, &pos1, &entry))
               return FAIL;
         }
         else
         {
            *(pipe->invalid) = TRUE;
         }
      }
   }

   return TRUE;
}
