/***
*alloc.h - definitions/declarations for malloc shell.
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   See ALLOC.C
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Version

   2.4 08-Jun-1995   added free macro to fix ptr=NULL problem
   2.3 24-Jul-1994   added memavailable stuff
   2.1 25-Jul-1994   added gloabl for mem testing
   2.0 28-Nov-1993

   Usage:

   see ALLOC.C

*/

#ifdef __GNUC__

#define alloc calloc
#define newalloc realloc
#define hugealloc calloc
#define hugefreep free
#define freep free

#else

#ifdef _MSC_VER

 #if (_MSC_VER <= 600)
  #define _halloc    halloc
  #define _hfree     hfree
 #endif

 #define huge_alloc(n,s)   _halloc(n,(size_t)s)
 #define huge_free         _hfree
 #define memavail()        ((unsigned long)_memavl())

#endif

#if defined(__BORLANDC__) || defined(__TURBOC__)   

 #define _memmax     coreleft
 #define _fheapset   _heapset
 #define _heapset    heapfillfree
 #define _heapinfo   heapinfo
 #define _heapwalk   farheapwalk
 #define _nheapwalk  heapwalk
 #define _fheapchk   farheapcheck
 #define _heapchk    farheapcheck
 #define _nheapchk   heapcheck
 #define _pentry     ptr
 #define _size       size
 #define _useflag    in_use

 #define huge_alloc  farcalloc
 #define huge_free   farfree
 #define memavail    coreleft

#endif

#ifdef __WATCOMC__

 #define huge_alloc(n,s)   halloc(n,(size_t)s)
 #define huge_free         hfree 
 #define memavail()        ((unsigned long)_memavl())

#endif

extern void heapcheck(int mode);
extern void (*alloc_handler)(void);
extern void set_alloc_handler(void (*func)(void));
extern void *alloc(size_t num, size_t size);
extern void __near *nalloc(size_t num, size_t size);
extern void *newalloc(void *p, size_t size);
extern void __huge *hugealloc(long num, long size);
extern void  freep(void *addr);
extern void  nfreep(void __near *addr);
extern void  hugefreep(void __huge *addr);
extern char *heapstat(int status);
extern int   heaptest(void);

#if 1
#define freep(p)  freep(p),p=NULL
#endif

/*
   Constants for _heapchk/_heapset/_heapwalk routines
   as defined in compiler's MALLOC.H: (for reference
   only)

Borland:

#define _HEAPEMPTY      1     // 0
#define _HEAPOK         2     // 1
#define _HEAPEND        5     // 4
#define _HEAPCORRUPT   -1     // 5
#define _BADNODE       -2     // 2
#define _BADVALUE      -3     // 3

#define _FREEENTRY      3
#define _USEDENTRY      4

Microsoft:

#define _HEAPEMPTY      (-1)
#define _HEAPOK         (-2)           // _heapchk/_heapset only
#define _HEAPBADBEGIN   (-3)
#define _HEAPBADNODE    (-4)
#define _HEAPEND        (-5)           // _heapwalk only
#define _HEAPBADPTR     (-6)

#define _FREEENTRY      0
#define _USEDENTRY      1

Watcom:

#define _HEAPOK         0
#define _HEAPEMPTY      1  // heap isn't initialized
#define _HEAPBADBEGIN   2  // heap header is corrupted
#define _HEAPBADNODE    3  // heap entry is corrupted
#define _HEAPEND        4  // end of heap entries (_heapwalk)
#define _HEAPBADPTR     5  // invalid heap entry pointer (_heapwalk)

#define _FREEENTRY      1
#define _USEDENTRY      0


You can see the dificulty with these compiler library functions!
*/

#endif
