#ifndef __GPM_H
#define __GPM_H

/* Internal Use Only */
#define _GPM_DOWN_STATUS 0x0005
#define _GPM_UP_STATUS   0x0006

#define _GPM_LEFT_BUTTON   0
#define _GPM_RIGHT_BUTTON  1
#define _GPM_MIDDLE_BUTTON 2

struct _gpm_handler_info {
    unsigned short vmcount, hi1;
    unsigned short hmcount, hi2;
    char           filler[ 8 ];
    unsigned short bstate, hi3;
    unsigned short row, hi4;
    unsigned short col;
};

struct _gpm_button_data {
    short times;
    short col;
    short row;
    short read;
};
/* End of Internal Use Only */

/* Values for event.buttons */
#define GPM_B_NONE      0x0000
#define GPM_B_LEFT      0x0001
#define GPM_B_RIGHT     0x0002
#define GPM_B_MIDDLE    0x0004
#define GPM_B_FOURTH    0x0008
#define GPM_B_UP        0x0010
#define GPM_B_DOWN      0x0020

/* Simple event.type mask */
#define GPM_BARE_EVENTS( e )    ( ( e ) & ( GPM_MOVE | GPM_DRAG | GPM_DOWN | GPM_UP | GPM_ENTER | GPM_LEAVE ) )

/* Values for event.type */
enum Gpm_Etype {
    GPM_MOVE    = 0x0001,
    GPM_DRAG    = 0x0002,
    GPM_DOWN    = 0x0004,
    GPM_UP      = 0x0008,
    GPM_SINGLE  = 0x0010,
    GPM_DOUBLE  = 0x0020,
    GPM_TRIPLE  = 0x0040,
    GPM_MFLAG   = 0x0080,
    GPM_HARD    = 0x0100,
    GPM_ENTER   = 0x0200,
    GPM_LEAVE   = 0x0400
};

enum Gpm_Margin {
    GPM_TOP = 0x0001,
    GPM_BOT = 0x0002,
    GPM_LFT = 0x0004,
    GPM_RGT = 0x0008
};

typedef struct _Gpm_Connect {
    unsigned short eventMask;
    unsigned short defaultMask;
    unsigned short minMod;
    unsigned short maxMod;
    int            pid;
    int            vc;
} Gpm_Connect;

typedef struct _Gpm_Event {
    unsigned char   buttons;
    unsigned char   modifiers;
    unsigned short  vc;
    short           dx;
    short           dy;
    short           x;
    short           y;
    enum Gpm_Etype  type;
    int             clicks;
    enum Gpm_Margin margin;
    short           wdx;
    short           wdy;
} Gpm_Event;

typedef int Gpm_Handler( Gpm_Event *evt, void *cd );

extern int gpm_flag;
extern int gpm_tried;
extern int gpm_fd;
extern int gpm_zerobased;
extern int gpm_visiblepointer;
extern int gpm_hflag;
extern int gpm_morekeys;

extern Gpm_Handler *gpm_handler;
extern void        *gpm_data;

extern int Gpm_Open( Gpm_Connect *c, int con );
extern int Gpm_Close( void );
extern int Gpm_GetEvent( Gpm_Event *event );

#endif
