#include "dapi.h"
#include "draw.h"
#include <graphics.h>
#include "mouse.h"

HBUTTON ButtonInvert(HBUTTON button)
{
 if(!button.i)
 {
  HideMouse();
  setcolor(0);
  rectangle(button.x,button.y,button.x1,button.y1);
  rectangle(button.x+1,button.y+1,button.x1-1,button.y1-1);
  setfillstyle(1,7);
  bar(button.x+2,button.y+2,button.x1-2,button.y1-2);
  setcolor(0);
  line(button.x+2,button.y+2,button.x1-2,button.y+2);
  line(button.x+2,button.y+2,button.x+2,button.y1-2);
  setcolor(15);
  line(button.x1-2,button.y+2,button.x1-2,button.y1-2);
  line(button.x+2,button.y1-2,button.x1-2,button.y1-2);
  setcolor(0);
  outtextxy(button.x+4,button.y+4,button.txt);
  button.i=1;
  ShowMouse();
 }
 return button;
}

void Show(HWND win)
{
 int i;
 setcolor(1);
 DrawWindow(win.x,win.y,win.x1,win.y1,win.title);
 if(win.st)
  for(i=0;i<win.t;i++)
  {
   setcolor(0);
   outtextxy(win.Text[i].x,win.Text[i].y,win.Text[i].txt);
  }
 if(win.sb)
  for(i=0;i<win.b;i++)
   DrawButton(win.Button[i].x,win.Button[i].y,win.Button[i].x1,win.Button[i].y1,win.Button[i].txt);
 if(win.sc)
  for(i=0;i<win.c;i++)
   DrawCheck(win.Check[i]);
}

int ButtonClicked(HWND win, int but)
{
 if(MouseIn(win.Button[but].x,win.Button[but].y,win.Button[but].x1,win.Button[but].y1))
 {
  while(Mouse.leftdn)
  {
   ReadMouseDown();
   win.Button[but]=ButtonInvert(win.Button[but]);
  }
  HideMouse();
  DrawButton(win.Button[but].x,win.Button[but].y,win.Button[but].x1,win.Button[but].y1,win.Button[but].txt);
  win.Button[but].i=0;
  ShowMouse();
  return 1;
 }
 return 0;
}

void CheckEvents(HWND win)
{
 int i;
 if(win.sb)
  for(i=0;i<win.b;i++)
   ButtonClicked(win,i);
}

