/*
 * $Id: msgplwin.c,v 1.6 2005/06/10 22:51:37 ronpinkas Exp $
 */

/*
 * Harbour Project source code:
 * Language Support Module (PL Windows CP1250)
 *
 * Copyright 1999 {list of individual authors and e-mail addresses}
 * www - http://www.harbour-project.org
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this software; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307 USA (or visit the web site http://www.gnu.org/).
 *
 * As a special exception, the Harbour Project gives permission for
 * additional uses of the text contained in its release of Harbour.
 *
 * The exception is that, if you link the Harbour libraries with other
 * files to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the Harbour library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the Harbour
 * Project under the name Harbour.  If you copy code from other
 * Harbour Project or Free Software Foundation releases into a copy of
 * Harbour, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for Harbour, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.
 *
 */

/* Language name: Polish */
/* ISO language code (2 chars): PL */
/* Codepage: 1250 */

#include "hbapilng.h"

static HB_LANG s_lang =
{
   {
      /* Identification */

      "PLWIN",                     /* ID */
      "Polish",                    /* Name (in English) */
      "Polski",                    /* Name (in native language) */
      "PL",                        /* RFC ID */
      "1250",                      /* Codepage */
      "$Revision: 1.6 $ $Date: 2005/06/10 22:51:37 $",         /* Version */

      /* Month names */

       "Stycze",
       "Luty",
       "Marzec",
       "Kwiecie",
       "Maj",
       "Czerwiec",
       "Lipiec",
       "Sierpie",
       "Wrzesie",
       "Padziernik",
       "Listopad",
       "Grudzie",

      /* Day names */

       "Niedziela",
       "Poniedziaek",
       "Wtorek",
       "roda",
       "Czwartek",
       "Pitek",
       "Sobota",

      /* CA-Cl*pper compatible natmsg items */

      "Baza danych       #Rekordw    Uaktualniona Rozmiar",
      "Wicej przykadw?",
      "Strona",
      "** Subtotal **",
      "* Subsubtotal *",
      "*** Total ***",
      "Wst",    /* wstaw */
      "Zas",    /* zastap */
      "Nieprawidowa data",
      "Zakres:",
      " - ",
      "T/N",
      "Bdne wyraenie",

      /* Error description names */

       "Bd bez opisu",
       "Nieprawidowy argument",
       "Bd zakresu tablicy",
       "Za duy string",
       "Przepenienie numeryczne",
       "Dzielenie przez zero",
       "Bd numeryczny",
       "Nieprawidowa skadnia",
       "Operacja zbyt zoona",
      "",
      "",
       "Za mao pamici",
       "Niezdefiniowana funkcja",
       "Metoda jest niedostpna",
       "Zmienna nie istnieje",
       "Alias bazy nie istnieje",
       "Zmienna jest niedostpna",
       "Nieprawidowy alias bazy",
       "Podany alias ju istnieje",
      "",
       "Bd podczas tworzenia zbioru",
       "Bd podczas otwarcia zbioru",
       "Bd podczas zamknicia zbioru",
       "Bd podczas odczytu ze zbioru",
       "Bd podczas zapisu do zbioru",
       "Bd wydruku",
      "",
      "",
      "",
      "",
       "Nieprawidowa operacja",
       "Przekroczony limit",
       "Uszkodzony indeks bazy",
       "Niezgodny typ danych",
       "Warto poza zakresem",
       "Baza jest nie otwarta",
       "Baza nie ma indeksu",
       "Wymagany jest wyczny dostp do bazy",
       "Wymagana blokada dostpu",
       "Zapis niedozwolony",
       "Brak blokady dostpu podczas dodawania rekordu",
       "Nie udao si zablokowa dostpu",
      "",
      "",
      "",
      "",
       "Nieprawidowa liczba argumentw",
       "pobranie elementu tablicy",
       "zmiana wartoci elementu tablicy",
       "wymagana jest tablica",
       "wymagany typ: logiczny",
       "Invalid self",

      /* Internal error names */

      "Nienaprawialny bd nr %lu: ",
      "Nieudana prba naprawy bdu",
      "Brak kodu obsugi ERRORBLOCK()",
      "Zbyt wiele zagniedonych bdw",
      "Niezaadowany lub zy RDD",
      "Zy typ metody woanej z %s",
      "hb_xgrab nie moe zarezerwowa pamici",
      "hb_xrealloc wywoany ze wskanikiem NULL",
      "hb_xrealloc wywoany ze zym wskanikiem",
      "hb_xrealloc nie moe powikszy bloku pamici",
      "hb_xfree wywoany ze zym wskanikiem",
      "hb_xfree wywoany ze wskanikiem NULL",
      "Brak definicji procedury startowej: \'%s\'",
      "Brak procedury startowej",
      "Nieprawidowa warto VM opcode",
      "W %s wymagany jest item typu \'Symbol\'",
      "W %s podano zy item dla SELF",
      "W %s oczekiwany jest item typu \'Codeblock\'",
      "Funkcja %s wymaga innego typu na stosie",
      "Stos poniej dna",
      "Item nie moe by skopiowany w %s",
      "W %s podano zy item jako memvar",
      "Zapis poza przydzielonym obszarem",
      "hb_xgrab requested to allocate zero bytes",
      "hb_xrealloc requested to resize to zero bytes",
      "hb_xalloc requested to allocate zero bytes",

      /* Texts */

      "YYYY.MM.DD",
      "T",
      "N"
   }
};

HB_LANG_ANNOUNCE( PLWIN );

HB_CALL_ON_STARTUP_BEGIN( hb_lang_Init_PLWIN )
   hb_langRegister( &s_lang );
HB_CALL_ON_STARTUP_END( hb_lang_Init_PLWIN )

#if defined(HB_PRAGMA_STARTUP)
   #pragma startup hb_lang_Init_PLWIN
#elif defined(HB_MSC_STARTUP)
   #if _MSC_VER >= 1010
      #pragma data_seg( ".CRT$XIY" )
      #pragma comment( linker, "/Merge:.CRT=.data" )
   #else
      #pragma data_seg( "XIY" )
   #endif
   static HB_$INITSYM hb_vm_auto_hb_lang_Init_PLWIN = hb_lang_Init_PLWIN;
   #pragma data_seg()
#endif

