\ 4tH library - STRING STACK - Copyright 2004 J.L. Bezemer
\ You can redistribute this file and/or modify it under
\ the terms of the GNU General Public License

\ N.B. Items taken from a stack by s> will remain
\ unclobbered UNTIL the next >s to that stack is performed.

[UNDEFINED] N! [IF]
INCLUDE lib/ncoding.4th
[THEN]

[UNDEFINED] STRING-STACK [IF]
nell 1 [+] constant tail
                                       ( stack --)
: string-stack dup nell+ tuck tail erase n! ;
: s@ n@ count ;                        ( stack -- a n)
: s> dup s@ rot dup n@ dup nell- n@ tail + chars - swap n! ;
                                       ( stack -- a n)
: >s                                   ( a n stack --)
  >r tuck r@ s@ tail + chars + >r r@   \ calculate new string address
  place r@ over 1+ chars + n! r> r> n! \ save count and stack pointer
;

[DEFINED] 4TH# [IF]
hide tail
[THEN]
[THEN]

