/*
	Software License Agreement (BSD License)
	
	Copyright (c) 1997-2008, David Lindauer, (LADSoft).
	All rights reserved.
	
	Redistribution and use of this software in source and binary forms, with or without modification, are
	permitted provided that the following conditions are met:
	
	* Redistributions of source code must retain the above
	  copyright notice, this list of conditions and the
	  following disclaimer.
	
	* Redistributions in binary form must reproduce the above
	  copyright notice, this list of conditions and the
	  following disclaimer in the documentation and/or other
	  materials provided with the distribution.
	
	* Neither the name of LADSoft nor the names of its
	  contributors may be used to endorse or promote products
	  derived from this software without specific prior
	  written permission of LADSoft.
	
	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED
	WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
	PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
	ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
	LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
	TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
	ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include <typeinfo>
#include <string.h>
#include <stdio.h>
#include "_rtti.h"

extern void _RTL_FUNC __undecorate(char *buf, char *name) ;
namespace std {

static void _internal_name(void *tpp, char *buf)
{
             char extend[64] ;
             CLASSXCEPT *s = (CLASSXCEPT *)tpp ;
             if (s->flags & XD_POINTER) {
               _internal_name(s->destructor,buf) ;
               strcat(buf," *") ;
             } else if (s->flags & XD_REF) {
               _internal_name(s->destructor,buf) ;
               strcat(buf," &") ;
             } else if (s->flags & XD_ARRAY) {
               _internal_name(s->destructor,buf) ;
               sprintf(extend," [%d]", *(int *)(s+1)) ;
               strcat(buf,extend) ;
             } else {
               __undecorate(buf,s->name) ;
             }

}
             _RTL_FUNC type_info::type_info(const type_info &in)
{
}
type_info &  _RTL_FUNC type_info::operator=(const type_info &in)
{
               return *this ;
}

             type_info::~type_info()
{
}

bool         _RTL_FUNC type_info::operator==(const type_info  &in) const
{
             if (this->tpp == in.tpp )
               return true ;
             CLASSXCEPT *s1 = (CLASSXCEPT *)this->tpp ;
             CLASSXCEPT *s2 = (CLASSXCEPT *)in.tpp ;
             if (s1->flags & s2->flags & XD_POINTER)
               if (s1->destructor == s2->destructor)
                  return true ;
             return false ;
}
bool         _RTL_FUNC type_info::operator!=(const type_info  &in) const
{
             return !(*this == in) ;
}

bool         _RTL_FUNC type_info::before(const type_info  &in) const
{
              char nbuf[256],nbuf2[256] ;
              _internal_name(this->tpp,nbuf) ;
              _internal_name(in.tpp,nbuf2) ;
              return( strcmp(nbuf,nbuf2) > 0) ;
}

const char * _RTL_FUNC type_info::name() const
{
			// using a rolling buffer so multiple name() references within
			// the same sequence point will result in valid operation
             static char nbuf[2048] ;
			 static int ofs = 0;
			 int oldoffs = ofs;
			 
             _internal_name(this->tpp,nbuf + ofs) ;
			 ofs += strlen(nbuf + ofs) + 1;
			 if (ofs >= sizeof(nbuf) - 200)
				 ofs = 0;
             return nbuf + oldoffs;
}

} ;
