/* operand classes. Introduced with v2.06, when the operand types were removed
 * from the instruction table and replaced by a class index.
 * As a result, it's easier and won't bloat the instruction table if the
 * third operand is extended or a 4th operand ( for AVX ) is added.
 */
OpCls( NONE,     NONE,       NONE  )
OpCls( AX,       NONE,       NONE  )
OpCls( I,        NONE,       NONE  )
OpCls( I16,      NONE,       NONE  )
OpCls( I32,      NONE,       NONE  )
OpCls( I48,      NONE,       NONE  )
OpCls( I8,       NONE,       NONE  )
OpCls( I8_U,     NONE,       NONE  )
OpCls( I_3,      NONE,       NONE  )
OpCls( M08,      NONE,       NONE  )
OpCls( M16,      NONE,       NONE  )
OpCls( M16_M32,  NONE,       NONE  )
#if AMD64_SUPPORT
OpCls( M16_M64,  NONE,       NONE  )
#endif
OpCls( M32,      NONE,       NONE  )
OpCls( M48,      NONE,       NONE  )
OpCls( M64,      NONE,       NONE  )
OpCls( M80,      NONE,       NONE  )
#if AMD64_SUPPORT
OpCls( M128,     NONE,       NONE  )
#endif
OpCls( MGT8,     NONE,       NONE  )
OpCls( MS,       NONE,       NONE  )
OpCls( M_ANY,    NONE,       NONE  )
OpCls( R,        NONE,       NONE  )
OpCls( R16_M16,  NONE,       NONE  )
OpCls( R16_R32,  NONE,       NONE  )
OpCls( R32,      NONE,       NONE  )
#if AMD64_SUPPORT
OpCls( R64,      NONE,       NONE  )
OpCls( R64_M64,  NONE,       NONE  )
OpCls( R16_R64,  NONE,       NONE  )
#endif
OpCls( R8_M08,   NONE,       NONE  )
OpCls( RGT16,    NONE,       NONE  )
OpCls( RGT8,     NONE,       NONE  )
OpCls( SR,       NONE,       NONE  )
OpCls( SR86,     NONE,       NONE  )
#if AMD64_SUPPORT
OpCls( SR386,    NONE,       NONE  )
#endif
OpCls( STI,      NONE,       NONE  )
OpCls( A,        DX_ONLY,    NONE  )
OpCls( A,        I,          NONE  )
OpCls( A,        I8_U,       NONE  )
OpCls( A,        MS,         NONE  )
OpCls( A,        RGT8,       NONE  )
OpCls( DX_ONLY,  A,          NONE  )
OpCls( DX_ONLY,  M08,        NONE  )
OpCls( DX_ONLY,  M16,        NONE  )
OpCls( DX_ONLY,  M32,        NONE  )
OpCls( DX_ONLY,  MS,         NONE  )
OpCls( I16,      I8_U,       NONE  )
OpCls( I8_U,     A,          NONE  )
OpCls( M08,      DX_ONLY,    NONE  )
OpCls( M08,      M08,        NONE  )
OpCls( M16,      DX_ONLY,    NONE  )
OpCls( M16,      M16,        NONE  )
OpCls( M32,      DX_ONLY,    NONE  )
OpCls( M32,      M32,        NONE  )
OpCls( M32,      XMM,        NONE  )
#if AMD64_SUPPORT
OpCls( M64,      M64,        NONE  )
#endif
OpCls( M64,      MMX,        NONE  )
OpCls( M64,      XMM,        NONE  )
OpCls( M128,     XMM,        NONE  )
#if AVXSUPP
OpCls( M256,     YMM,        NONE  )
#endif
OpCls( MGT16,    RGT16,      NONE  )
OpCls( MGT8,     I8,         NONE  )
OpCls( MGT8,     I8_U,       NONE  )
OpCls( MGT8,     RGT8,       NONE  )
OpCls( MMX,      I8_U,       NONE  )
OpCls( MMX,      MMX,        NONE  )
OpCls( MMX,      MMX_M64,    NONE  )
OpCls( MMX,      RMGT16,     NONE  )  /* MOVD, CVTSI2SD, CVTSI2SS */
OpCls( MMX,      XMM,        NONE  )
OpCls( MMX,      XMM_M64,    NONE  )
OpCls( MMX,      XMM_M128,   NONE  )
OpCls( MS,       A,          NONE  )
OpCls( MS,       DX_ONLY,    NONE  )
OpCls( MS,       I,          NONE  )
OpCls( MS,       MS,         NONE  )
OpCls( MS,       R,          NONE  )
OpCls( MS,       SR,         NONE  )
OpCls( R,        I,          NONE  )
OpCls( R,        MS,         NONE  )
OpCls( R,        R,          NONE  )
OpCls( R,        R_MS,       NONE  )
OpCls( R16_M16,  R16,        NONE  )
OpCls( R16_R32,  I,          NONE  )
#if AMD64_SUPPORT
OpCls( R64,      I,          NONE  )
OpCls( R64,      I64,        NONE  )
OpCls( R64,      R32_M32,    NONE  )
#endif
OpCls( R8,       I,          NONE  )
OpCls( RGT16,    MMX,        NONE  )
OpCls( RGT16,    R8_M08,     NONE  )
OpCls( RGT16,    RGT8_MS,    NONE  )
OpCls( RGT16,    RSPEC,      NONE  )
OpCls( RGT16,    XMM,        NONE  )
OpCls( RGT16,    XMM_M32,    NONE  )
OpCls( RGT16,    XMM_M64,    NONE  )
OpCls( RGT8,     A,          NONE  )
OpCls( RGT8,     I,          NONE  )
OpCls( RGT8,     I8,         NONE  )
OpCls( RGT8,     I8_U,       NONE  )
OpCls( RGT8,     MFPTR,      NONE  )
OpCls( RGT8,     MS,         NONE  )
OpCls( RGT8,     RGT8,       NONE  )
OpCls( RGT8,     RGT8_MS,    NONE  )
OpCls( RGT8,     R_MS,       NONE  )
OpCls( RGT8,     SR,         NONE  )
#if INTELMOVQ
OpCls( R32_M32,  MMX,        NONE  )
OpCls( R32_M32,  XMM,        NONE  )
OpCls( R64_M64,  MMX,        NONE  )
OpCls( R64_M64,  XMM,        NONE  )
#else
OpCls( RMGT16,   MMX,        NONE  )
OpCls( RMGT16,   XMM,        NONE  )
#endif
OpCls( RSPEC,    RGT16,      NONE  )
OpCls( R_MS,     CL_ONLY,    NONE  )
OpCls( R_MS,     I,          NONE  )
OpCls( R_MS,     I8_U,       NONE  )
OpCls( R_MS,     I_1,        NONE  )
OpCls( SR,       MS,         NONE  )
OpCls( SR,       RGT8,       NONE  )
OpCls( ST,       STI,        NONE  )
OpCls( STI,      ST,         NONE  )
OpCls( XMM,      I8_U,       NONE  )
#if AVXSUPP
OpCls( XMM,      M32,        NONE  )
#endif
OpCls( XMM,      M64,        NONE  )
OpCls( XMM,      M128,       NONE  )
OpCls( XMM,      MMX,        NONE  )
OpCls( XMM,      MMX_M64,    NONE  )
OpCls( XMM,      RMGT16,     NONE  )
OpCls( XMM,      XMM,        NONE  )
OpCls( XMM,      XMM_M16,    NONE  )
OpCls( XMM,      XMM_M32,    NONE  )
OpCls( XMM,      XMM_M64,    NONE  )
OpCls( XMM,      XMM_M128,   NONE  )
#if AVXSUPP
OpCls( XMM,      YMM_M256,   NONE  )
OpCls( YMM,      M32,        NONE  )
OpCls( YMM,      M64,        NONE  )
OpCls( YMM,      M128,       NONE  )
OpCls( YMM,      M256,       NONE  )
OpCls( YMM,      YMM_M256,   NONE  )
#endif
OpCls( M16,      XMM,        I8_U  )
OpCls( M32,      XMM,        I8_U  )
OpCls( MMX,      MMX_M64,    I8_U  )
//OpCls( MMX,      M16,        I8_U  ) /* PINSRW */
//OpCls( MMX,      R32,        I8_U  ) /* PINSRW */
OpCls( MMX,      R32_M16,    I8_U  ) /* PINSRW */
OpCls( R32_M32,  XMM,        I8_U  )
#if AMD64_SUPPORT
OpCls( R64_M64,  XMM,        I8_U  )
#endif
OpCls( RGT16,    MMX,        I8_U  )
OpCls( RGT16,    XMM,        I8_U  )
OpCls( RGT16_M08,XMM,        I8_U  )
OpCls( RGT8,     R_MS,       I     )
OpCls( RGT8,     R_MS,       I8_U  )
OpCls( RGT8_MGT8,RGT8,       CL    )
OpCls( RGT8_MGT8,RGT8,       I8_U  )
OpCls( XMM,      I8_U,       I8_U  )
//OpCls( XMM,      M16,        I8_U  ) /* PINSRW */
//OpCls( XMM,      R32,        I8_U  ) /* PINSRW */
OpCls( XMM,      R32_M16,    I8_U  ) /* PINSRW */
OpCls( XMM,      R32_M08,    I8_U  ) /* PINSRB */
OpCls( XMM,      R32_M32,    I8_U  ) /* PINSRD */
#if AMD64_SUPPORT
OpCls( XMM,      R64_M64,    I8_U  )
#endif
OpCls( XMM,      XMM,        I8_U  )
OpCls( XMM,      XMM_M32 ,   HID   )
OpCls( XMM,      XMM_M64 ,   HID   )
OpCls( XMM,      XMM_M128,   HID   )
OpCls( XMM,      XMM_M32 ,   I8_U  )
OpCls( XMM,      XMM_M64 ,   I8_U  )
OpCls( XMM,      XMM_M128,   I8_U  )
OpCls( XMM,      XMM_M128,   XMM0  )
#if AVXSUPP
OpCls( M128,     YMM,        I8_U  )
OpCls( XMM,      XMM_M128,   XMM   )
OpCls( XMM,      YMM,        I8_U  )
OpCls( YMM,      XMM_M128,   I8_U  )
OpCls( YMM,      YMM_M256,   I8_U  )
OpCls( YMM,      YMM_M256,   YMM   )
#endif
