% Generated by roxygen2: do not edit by hand
\name{det}
\alias{det}
\title{Compute the Determinant of a Matrix}
\arguments{
  \item{x}{a numeric or complex matrix}
  \item{logarithm}{logical. If TRUE, the logarithm of the absolute value of the determinant is returned.
}
}

\details{
Basic usage of \{.help [\{.fun det\}](base::det)\}
\code{
A <- matrix(c(4, 3, 2, 1), ncol = 2)
det(A)  # determinant of the matrix
}

Using logarithm for large values
\code{
B <- matrix(rnorm(10000), ncol = 100)
det(B, logarithm = TRUE)  # log-determinant of the matrix
}}

