/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph.invariant;

import java.util.List;
import org.openscience.cdk.exception.NoSuchAtomException;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.ConnectionMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class EquivalentClassPartitioner {
    private double[][] nodeMatrix;
    private double[][] bondMatrix;
    private double[] weight;
    private double[][] adjaMatrix;
    private int[][] apspMatrix;
    private int layerNumber;
    private int nodeNumber;
    private static final double LOST = 1.0E-12;
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(EquivalentClassPartitioner.class);

    public EquivalentClassPartitioner() {
    }

    public EquivalentClassPartitioner(IAtomContainer atomContainer) {
        this.adjaMatrix = ConnectionMatrix.getMatrix((IAtomContainer)atomContainer);
        this.apspMatrix = PathTools.computeFloydAPSP((double[][])this.adjaMatrix);
        this.layerNumber = 1;
        this.nodeNumber = atomContainer.getAtomCount();
        for (int i = 1; i < atomContainer.getAtomCount(); ++i) {
            for (int j = 0; j < i; ++j) {
                if (this.apspMatrix[i][j] > this.layerNumber) {
                    this.layerNumber = this.apspMatrix[i][j];
                }
                if (!(this.adjaMatrix[i][j] > 0.0)) continue;
                IBond bond = atomContainer.getBond(atomContainer.getAtom(i), atomContainer.getAtom(j));
                boolean isArom = bond.getFlag(32);
                this.adjaMatrix[i][j] = isArom ? 1.5 : this.adjaMatrix[i][j];
                this.adjaMatrix[j][i] = this.adjaMatrix[i][j];
            }
        }
        this.nodeMatrix = new double[this.nodeNumber][this.layerNumber + 1];
        this.bondMatrix = new double[this.nodeNumber][this.layerNumber];
        this.weight = new double[this.nodeNumber + 1];
    }

    public int[] getTopoEquivClassbyHuXu(IAtomContainer atomContainer) throws NoSuchAtomException {
        double[] nodeSequence = this.prepareNode(atomContainer);
        this.nodeMatrix = this.buildNodeMatrix(nodeSequence);
        this.bondMatrix = this.buildBondMatrix();
        this.weight = this.buildWeightMatrix(this.nodeMatrix, this.bondMatrix);
        return this.findTopoEquivClass(this.weight);
    }

    public double[] prepareNode(IAtomContainer atomContainer) {
        double[] nodeSequence = new double[atomContainer.getAtomCount()];
        int i = 0;
        for (IAtom atom : atomContainer.atoms()) {
            IBond bond1;
            IBond bond0;
            String symbol = atom.getSymbol();
            List bonds = atomContainer.getConnectedBondsList(atom);
            if (bonds.size() == 1) {
                bond0 = (IBond)bonds.get(0);
                IBond.Order order = bond0.getOrder();
                if (symbol.equals("C")) {
                    if (order == IBond.Order.SINGLE) {
                        nodeSequence[i] = 1.0;
                    } else if (order == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 3.0;
                    } else if (order == IBond.Order.TRIPLE) {
                        nodeSequence[i] = 6.0;
                    }
                } else if (symbol.equals("O")) {
                    if (order == IBond.Order.SINGLE) {
                        nodeSequence[i] = 14.0;
                    } else if (order == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 16.0;
                    }
                } else if (symbol.equals("N")) {
                    if (order == IBond.Order.SINGLE) {
                        nodeSequence[i] = 18.0;
                    } else if (order == IBond.Order.DOUBLE) {
                        nodeSequence[i] = atom.getCharge() == -1.0 ? 27.0 : 20.0;
                    } else if (order == IBond.Order.TRIPLE) {
                        nodeSequence[i] = 23.0;
                    }
                } else if (symbol.equals("S")) {
                    if (order == IBond.Order.SINGLE) {
                        nodeSequence[i] = 31.0;
                    } else if (order == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 33.0;
                    }
                } else if (symbol.equals("P")) {
                    nodeSequence[i] = 38.0;
                } else if (symbol.equals("F")) {
                    nodeSequence[i] = 42.0;
                } else if (symbol.equals("Cl")) {
                    nodeSequence[i] = 43.0;
                } else if (symbol.equals("Br")) {
                    nodeSequence[i] = 44.0;
                } else if (symbol.equals("I")) {
                    nodeSequence[i] = 45.0;
                } else {
                    logger.debug((Object)"in case of a new node, please report this bug to cdk-devel@lists.sf.net.");
                }
            } else if (bonds.size() == 2) {
                bond0 = (IBond)bonds.get(0);
                bond1 = (IBond)bonds.get(1);
                IBond.Order order0 = bond0.getOrder();
                IBond.Order order1 = bond1.getOrder();
                if (symbol.equals("C")) {
                    if (order0 == IBond.Order.SINGLE && order1 == IBond.Order.SINGLE) {
                        nodeSequence[i] = 2.0;
                    } else if (order0 == IBond.Order.DOUBLE && order1 == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 10.0;
                    } else if (!(order0 != IBond.Order.SINGLE && bond1.getOrder() != IBond.Order.SINGLE || order0 != IBond.Order.DOUBLE && bond1.getOrder() != IBond.Order.DOUBLE)) {
                        nodeSequence[i] = 5.0;
                    } else if (!(order0 != IBond.Order.SINGLE && bond1.getOrder() != IBond.Order.TRIPLE || order0 != IBond.Order.TRIPLE && bond1.getOrder() != IBond.Order.TRIPLE)) {
                        nodeSequence[i] = 9.0;
                    }
                    if (bond0.getFlag(32) && bond1.getFlag(32)) {
                        nodeSequence[i] = 11.0;
                    }
                } else if (symbol.equals("N")) {
                    if (order0 == IBond.Order.SINGLE && order1 == IBond.Order.SINGLE) {
                        nodeSequence[i] = 19.0;
                    } else if (order0 == IBond.Order.DOUBLE && order1 == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 28.0;
                    } else if (!(order0 != IBond.Order.SINGLE && bond1.getOrder() != IBond.Order.SINGLE || order0 != IBond.Order.DOUBLE && bond1.getOrder() != IBond.Order.DOUBLE)) {
                        nodeSequence[i] = 22.0;
                    } else if (!(order0 != IBond.Order.DOUBLE && bond1.getOrder() != IBond.Order.DOUBLE || order0 != IBond.Order.TRIPLE && bond1.getOrder() != IBond.Order.TRIPLE)) {
                        nodeSequence[i] = 26.0;
                    } else if (!(order0 != IBond.Order.SINGLE && bond1.getOrder() != IBond.Order.SINGLE || order0 != IBond.Order.TRIPLE && bond1.getOrder() != IBond.Order.TRIPLE)) {
                        nodeSequence[i] = 29.0;
                    }
                    if (bond0.getFlag(32) && bond1.getFlag(32)) {
                        nodeSequence[i] = 30.0;
                    }
                } else if (symbol.equals("O")) {
                    if (order0 == IBond.Order.SINGLE && order1 == IBond.Order.SINGLE) {
                        nodeSequence[i] = 15.0;
                    } else if (bond0.getFlag(32) && bond1.getFlag(32)) {
                        nodeSequence[i] = 17.0;
                    }
                } else if (symbol.equals("S")) {
                    if (order0 == IBond.Order.SINGLE && order1 == IBond.Order.SINGLE) {
                        nodeSequence[i] = 32.0;
                    } else if (order0 == IBond.Order.DOUBLE && order1 == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 35.0;
                    } else if (bond0.getFlag(32) && bond1.getFlag(32)) {
                        nodeSequence[i] = 37.0;
                    }
                } else if (symbol.equals("P")) {
                    if (order0 == IBond.Order.SINGLE && order1 == IBond.Order.SINGLE) {
                        nodeSequence[i] = 39.0;
                    }
                } else {
                    logger.debug((Object)"in case of a new node, please report this bug to cdk-devel@lists.sf.net.");
                }
            } else if (bonds.size() == 3) {
                bond0 = (IBond)bonds.get(0);
                bond1 = (IBond)bonds.get(1);
                IBond bond2 = (IBond)bonds.get(2);
                IBond.Order order0 = bond0.getOrder();
                IBond.Order order1 = bond1.getOrder();
                IBond.Order order2 = bond2.getOrder();
                if (symbol.equals("C")) {
                    if (order0 == IBond.Order.SINGLE && order1 == IBond.Order.SINGLE && order2 == IBond.Order.SINGLE) {
                        nodeSequence[i] = 4.0;
                    } else if (order0 == IBond.Order.DOUBLE || order1 == IBond.Order.DOUBLE || order2 == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 8.0;
                    }
                    if ((bond0.getFlag(32) || bond1.getFlag(32) || bond2.getFlag(32)) && (order0 == IBond.Order.SINGLE || order1 == IBond.Order.SINGLE || bond2.getOrder() == IBond.Order.SINGLE)) {
                        nodeSequence[i] = 12.0;
                    }
                    if (bond0.getFlag(32) && bond1.getFlag(32) && bond2.getFlag(32)) {
                        nodeSequence[i] = 13.0;
                    }
                } else if (symbol.equals("N")) {
                    if (order0 == IBond.Order.SINGLE && order1 == IBond.Order.SINGLE && order2 == IBond.Order.SINGLE) {
                        nodeSequence[i] = 21.0;
                    } else if (order0 == IBond.Order.SINGLE || order1 == IBond.Order.SINGLE || order2 == IBond.Order.SINGLE) {
                        nodeSequence[i] = 25.0;
                    }
                } else if (symbol.equals("S")) {
                    if (order0 == IBond.Order.DOUBLE || order1 == IBond.Order.DOUBLE || order2 == IBond.Order.DOUBLE) {
                        nodeSequence[i] = 34.0;
                    }
                } else if (symbol.equals("P")) {
                    if (order0 == IBond.Order.SINGLE && order1 == IBond.Order.SINGLE && order2 == IBond.Order.SINGLE) {
                        nodeSequence[i] = 40.0;
                    }
                } else {
                    logger.debug((Object)"in case of a new node, please report this bug to cdk-devel@lists.sf.net.");
                }
            } else if (bonds.size() == 4) {
                if (atom.getAtomicNumber() == 6) {
                    nodeSequence[i] = 7.0;
                } else if (atom.getAtomicNumber() == 7) {
                    nodeSequence[i] = 24.0;
                } else if (atom.getAtomicNumber() == 16) {
                    nodeSequence[i] = 36.0;
                } else if (atom.getAtomicNumber() == 15) {
                    nodeSequence[i] = 41.0;
                } else {
                    logger.debug((Object)"in case of a new node, please report this bug to cdk-devel@lists.sf.net.");
                }
            }
            ++i;
        }
        return nodeSequence;
    }

    public double[][] buildNodeMatrix(double[] nodeSequence) {
        for (int i = 0; i < this.nodeNumber; ++i) {
            this.nodeMatrix[i][0] = nodeSequence[i];
            for (int j = 1; j <= this.layerNumber; ++j) {
                this.nodeMatrix[i][j] = 0.0;
                for (int k = 0; k < this.nodeNumber; ++k) {
                    if (this.apspMatrix[i][k] != j) continue;
                    double[] dArray = this.nodeMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + nodeSequence[k];
                }
            }
        }
        return this.nodeMatrix;
    }

    public double[][] buildTrialNodeMatrix(double[] weight) {
        for (int i = 0; i < this.nodeNumber; ++i) {
            this.nodeMatrix[i][0] = weight[i + 1];
            for (int j = 1; j <= this.layerNumber; ++j) {
                this.nodeMatrix[i][j] = 0.0;
                for (int k = 0; k < this.nodeNumber; ++k) {
                    if (this.apspMatrix[i][k] != j) continue;
                    double[] dArray = this.nodeMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + weight[k + 1];
                }
            }
        }
        return this.nodeMatrix;
    }

    public double[][] buildBondMatrix() {
        for (int i = 0; i < this.nodeNumber; ++i) {
            for (int j = 1; j <= this.layerNumber; ++j) {
                this.bondMatrix[i][j - 1] = 0.0;
                for (int k = 0; k < this.nodeNumber; ++k) {
                    if (j == 1) {
                        if (this.apspMatrix[i][k] != j) continue;
                        double[] dArray = this.bondMatrix[i];
                        int n = j - 1;
                        dArray[n] = dArray[n] + this.adjaMatrix[i][k];
                        continue;
                    }
                    if (this.apspMatrix[i][k] != j) continue;
                    for (int m = 0; m < this.nodeNumber; ++m) {
                        if (this.apspMatrix[i][m] != j - 1) continue;
                        double[] dArray = this.bondMatrix[i];
                        int n = j - 1;
                        dArray[n] = dArray[n] + this.adjaMatrix[k][m];
                    }
                }
            }
        }
        return this.bondMatrix;
    }

    public double[] buildWeightMatrix(double[][] nodeMatrix, double[][] bondMatrix) {
        for (int i = 0; i < this.nodeNumber; ++i) {
            this.weight[i + 1] = nodeMatrix[i][0];
            for (int j = 0; j < this.layerNumber; ++j) {
                int n = i + 1;
                this.weight[n] = this.weight[n] + nodeMatrix[i][j + 1] * bondMatrix[i][j] * Math.pow(10.0, -(j + 1));
            }
        }
        this.weight[0] = 0.0;
        return this.weight;
    }

    public int checkDiffNumber(double[] weight) {
        double[] category = new double[weight.length];
        int count = 1;
        category[1] = weight[1];
        for (int i = 2; i < weight.length; ++i) {
            int j;
            for (j = 1; j <= count; ++j) {
                double t = weight[i] - category[j];
                if (t < 0.0) {
                    t = -t;
                }
                if (t < 1.0E-12) break;
            }
            if (j <= count) continue;
            category[++count] = weight[i];
        }
        return count;
    }

    public int[] getEquivalentClass(double[] weight) {
        double t;
        int j;
        int i;
        double[] category = new double[weight.length];
        int[] equivalentClass = new int[weight.length];
        int count = 1;
        category[1] = weight[1];
        for (i = 2; i < weight.length; ++i) {
            for (j = 1; j <= count; ++j) {
                t = weight[i] - category[j];
                if (t < 0.0) {
                    t = -t;
                }
                if (t < 1.0E-12) break;
            }
            if (j <= count) continue;
            category[++count] = weight[i];
        }
        for (i = 1; i < weight.length; ++i) {
            for (j = 1; j <= count; ++j) {
                t = weight[i] - category[j];
                if (t < 0.0) {
                    t = -t;
                }
                if (!(t < 1.0E-12)) continue;
                equivalentClass[i] = j;
            }
        }
        equivalentClass[0] = count;
        return equivalentClass;
    }

    public int[] findTopoEquivClass(double[] weight) {
        int count;
        int[] equivalentClass = new int[weight.length];
        int trialCount = count = this.checkDiffNumber(weight);
        if (count == this.nodeNumber) {
            for (int i = 1; i <= this.nodeNumber; ++i) {
                equivalentClass[i] = i;
            }
            equivalentClass[0] = count;
            return equivalentClass;
        }
        do {
            count = trialCount;
            double[][] trialNodeMatrix = this.buildTrialNodeMatrix(weight);
            double[] trialWeight = this.buildWeightMatrix(trialNodeMatrix, this.bondMatrix);
            trialCount = this.checkDiffNumber(trialWeight);
            if (trialCount == this.nodeNumber) {
                for (int i = 1; i <= this.nodeNumber; ++i) {
                    equivalentClass[i] = i;
                }
                equivalentClass[0] = count;
                return equivalentClass;
            }
            if (trialCount > count) continue;
            equivalentClass = this.getEquivalentClass(weight);
            return equivalentClass;
        } while (trialCount > count);
        return equivalentClass;
    }
}

