/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.matchers;

import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.smsd.algorithm.matchers.BondMatcher;

@Deprecated
public class DefaultBondMatcher
implements BondMatcher {
    static final long serialVersionUID = -7861469841127328812L;
    private IBond queryBond = null;
    private IQueryBond smartQueryBond = null;
    private int unsaturation = 0;
    private boolean shouldMatchBonds = false;

    public DefaultBondMatcher() {
        this.queryBond = null;
        this.smartQueryBond = null;
        this.unsaturation = -1;
        this.shouldMatchBonds = false;
    }

    public DefaultBondMatcher(IAtomContainer queryMol, IBond queryBond, boolean shouldMatchBonds) {
        this.queryBond = queryBond;
        this.unsaturation = this.getUnsaturation(queryMol, this.queryBond);
        this.setBondMatchFlag(shouldMatchBonds);
    }

    public DefaultBondMatcher(IQueryBond queryBond) {
        this.smartQueryBond = queryBond;
    }

    @Override
    public boolean matches(IAtomContainer targetContainer, IBond targetBond) {
        if (this.smartQueryBond != null && this.queryBond == null) {
            return this.smartQueryBond.matches(targetBond);
        }
        if (!this.isBondMatchFlag()) {
            return true;
        }
        if (this.isBondMatchFlag() && this.isBondTypeMatch(targetBond)) {
            return true;
        }
        return this.isBondMatchFlag() && this.unsaturation == this.getUnsaturation(targetContainer, targetBond);
    }

    private boolean isBondTypeMatch(IBond targetBond) {
        int reactantBondType = this.queryBond.getOrder().numeric();
        int productBondType = targetBond.getOrder().numeric();
        if (this.queryBond.getFlag(32) == targetBond.getFlag(32) && reactantBondType == productBondType) {
            return true;
        }
        return this.queryBond.getFlag(32) && targetBond.getFlag(32);
    }

    private int getValency(IAtom atom) {
        return atom.getValency() == null ? 0 : atom.getValency();
    }

    private int getUnsaturation(IAtomContainer container, IBond bond) {
        return this.getUnsaturation(container, bond.getBegin()) + this.getUnsaturation(container, bond.getEnd());
    }

    private int getUnsaturation(IAtomContainer container, IAtom atom) {
        return this.getValency(atom) - (this.countNeighbors(container, atom) + this.countImplicitHydrogens(atom));
    }

    private int countNeighbors(IAtomContainer container, IAtom atom) {
        return container.getConnectedBondsCount(atom);
    }

    private int countImplicitHydrogens(IAtom atom) {
        return atom.getImplicitHydrogenCount() == null ? 0 : atom.getImplicitHydrogenCount();
    }

    public boolean isBondMatchFlag() {
        return this.shouldMatchBonds;
    }

    public final void setBondMatchFlag(boolean shouldMatchBonds) {
        this.shouldMatchBonds = shouldMatchBonds;
    }
}

