/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.molutil;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.euclid.EuclidRuntimeException;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Vector3;
import org.xmlcml.molutil.ChemicalElement;

public abstract class Molutils
implements CMLConstants {
    static final Logger logger = Logger.getLogger((String)Molutils.class.getName());
    public static final double TRIGONAL_ANGLE = 2.0 * Math.acos(0.5);
    public static final double TETRAHEDRAL_ANGLE = 2.0 * Math.acos(1.0 / Math.sqrt(3.0));
    public static final int DEFAULT = 0;
    public static final int ANY = 1;
    public static final int LINEAR = 2;
    public static final int TRIGONAL = 3;
    public static final int TETRAHEDRAL = 4;

    public static double getBondLength(ChemicalElement el1, ChemicalElement el2) {
        double d1 = el1.getCovalentRadius();
        double d2 = el2.getCovalentRadius();
        return d1 < 0.1 || d2 < 0.1 ? 1.0 : d1 + d2;
    }

    public static List<Point3> calculate3DCoordinates0(Point3 aPoint, int geometry, double length) throws EuclidRuntimeException {
        if (geometry < 1 || geometry > 4) {
            throw new EuclidRuntimeException("Unknown value of geometry: " + geometry);
        }
        ArrayList<Point3> points = new ArrayList<Point3>(geometry);
        if (geometry == 1) {
            points.add(new Point3(aPoint).plus(new Vector3(length, 0.0, 0.0)));
        } else if (geometry == 2) {
            points.add(new Point3(aPoint).plus(new Vector3(length, 0.0, 0.0)));
            points.add(new Point3(aPoint).plus(new Vector3(-length, 0.0, 0.0)));
        } else if (geometry == 3) {
            points.add(new Point3(aPoint).plus(new Vector3(length, 0.0, 0.0)));
            points.add(new Point3(aPoint).plus(new Vector3(-length * 0.5, -length * 0.5 * Math.sqrt(3.0), 0.0)));
            points.add(new Point3(aPoint).plus(new Vector3(-length * 0.5, length * 0.5 * Math.sqrt(3.0), 0.0)));
        } else if (geometry == 4) {
            double dx = length / Math.sqrt(3.0);
            points.add(new Point3(aPoint).plus(new Vector3(dx, dx, dx)));
            points.add(new Point3(aPoint).plus(new Vector3(dx, -dx, -dx)));
            points.add(new Point3(aPoint).plus(new Vector3(-dx, -dx, dx)));
            points.add(new Point3(aPoint).plus(new Vector3(-dx, dx, -dx)));
        }
        return points;
    }

    public static List<Point3> calculate3DCoordinates1(Point3 aPoint, Point3 bPoint, Point3 cPoint, int geometry, double length, double angle) throws EuclidRuntimeException {
        if (geometry < 2 || geometry > 4) {
            throw new EuclidRuntimeException("Unknown value of geometry: " + geometry);
        }
        ArrayList<Point3> points = new ArrayList<Point3>(geometry - 1);
        Vector3 ba = new Vector3(aPoint).subtract(new Vector3(bPoint)).normalize();
        if (geometry == 2) {
            Vector3 ax = ba.multiplyBy(length);
            points.add(0, aPoint.plus(ax));
        } else {
            Vector3 cb;
            if (cPoint == null) {
                cPoint = new Point3(ba.getNonColinearVector());
            }
            if ((cb = new Vector3(bPoint).subtract(new Vector3(cPoint)).normalize()).isColinearVector(ba)) {
                Vector3 cVector = ba.getNonColinearVector();
                cPoint = new Point3(cVector);
                cb = new Vector3(bPoint).subtract(new Vector3(cPoint));
            }
            Vector3 cbxba = cb.cross(ba).normalize();
            Vector3 ax = ba.cross(cbxba).normalize();
            int nrot = geometry - 1;
            double drot = Math.PI * 2 / (double)nrot;
            Point3 temp = new Point3(aPoint);
            double length1 = length * Math.sin(angle);
            for (int i = 0; i < nrot; ++i) {
                double rot = (double)i * drot;
                Vector3 vx = new Vector3(ba);
                vx = vx.multiplyBy(-Math.cos(angle) * length);
                Vector3 vy = new Vector3(ax);
                vy = vy.multiplyBy(Math.cos(rot) * length1);
                Vector3 vz = new Vector3(cbxba);
                vz = vz.multiplyBy(Math.sin(rot) * length1);
                points.add(i, temp.subtract(vx).subtract(vy).subtract(vz));
            }
        }
        return points;
    }

    public static List<Point3> calculate3DCoordinates2(Point3 aPoint, Point3 bPoint, Point3 cPoint, int geometry, double length, double angle) throws EuclidRuntimeException {
        if (geometry < 3 || geometry > 4) {
            throw new EuclidRuntimeException("Unknown value of geometry: " + geometry);
        }
        ArrayList<Point3> points = new ArrayList<Point3>(geometry - 2);
        double ang2 = angle / 2.0;
        Vector3 ba = new Vector3(aPoint).subtract(new Vector3(bPoint));
        Vector3 ca = new Vector3(aPoint).subtract(new Vector3(cPoint));
        Vector3 baxca = ba.cross(ca);
        if (!ba.isColinearVector(ca)) {
            if (geometry == 3) {
                Vector3 ax = new Vector3(ba).plus(ca).normalize().multiplyBy(length);
                points.add(0, new Point3(aPoint).plus(ax));
            } else if (geometry == 4) {
                baxca = baxca.normalize().multiplyBy(Math.sin(ang2) * length);
                Vector3 ax = new Vector3(ba).plus(ca).normalize().multiplyBy(Math.cos(ang2) * length);
                Point3 temp = new Point3(aPoint).subtract(ax);
                points.add(0, temp.plus(baxca));
                points.add(1, temp.subtract(baxca));
            }
        }
        return points;
    }

    public static Point3 calculate3DCoordinates3(Point3 aPoint, Point3 bPoint, Point3 cPoint, Point3 dPoint, double length) {
        Vector3 v1 = new Vector3(aPoint).subtract(new Vector3(bPoint));
        Vector3 v2 = new Vector3(aPoint).subtract(new Vector3(cPoint));
        Vector3 v3 = new Vector3(aPoint).subtract(new Vector3(dPoint));
        Vector3 v = new Vector3(v1).plus(new Vector3(v2)).plus(new Vector3(v3));
        if (v.getLength() < 1.0E-5) {
            return null;
        }
        v = v.normalize().multiplyBy(length);
        Point3 point = new Point3(aPoint).plus(v);
        return point;
    }

    public static void testCalculate3DCoordinates() {
        int j;
        int i;
        List<Point3> ligands;
        int geometry;
        logger.info((Object)"\nadd ligand coordinates...\n");
        Point3 pZero = new Point3(10.0, 10.0, 10.0);
        Point3 pOne = new Point3(8.0, 10.0, 10.0);
        Point3 pStaggered = new Point3(8.0, 8.0, 10.0);
        Point3 pTwoa = new Point3(9.0, 9.0, 10.0);
        Point3 pTwob = new Point3(9.0, 11.0, 10.0);
        Point3 pThreea = new Point3(9.0, 9.0, 11.0);
        Point3 pThreeb = new Point3(9.0, 11.0, 9.0);
        Point3 pThreec = new Point3(11.0, 9.0, 9.0);
        double length = 1.5;
        double angle = TETRAHEDRAL_ANGLE;
        double[] angles = new double[]{TETRAHEDRAL_ANGLE, TRIGONAL_ANGLE, TETRAHEDRAL_ANGLE};
        logger.info((Object)"\n\nadd ligands to atom with no ligands");
        logger.info((Object)("add ligands to: " + pZero + "; length: " + length + "; angle: " + angle));
        for (geometry = 1; geometry <= 4; ++geometry) {
            logger.info((Object)("\nType of geometry: " + geometry + ":"));
            try {
                ligands = Molutils.calculate3DCoordinates0(pZero, geometry, length);
                for (i = 0; i < ligands.size(); ++i) {
                    logger.info((Object)("...ligand:" + ligands.get(i)));
                }
                continue;
            }
            catch (EuclidRuntimeException e) {
                logger.info((Object)("Exception: " + (Object)((Object)e)));
            }
        }
        logger.info((Object)"\n\nadd ligands to atom with one ligand");
        logger.info((Object)("add ligands to: " + pZero + "; length: " + length + "; angle: " + angle));
        logger.info((Object)("reference atom: " + pOne));
        for (geometry = 2; geometry <= 4; ++geometry) {
            logger.info((Object)("\nType of geometry: " + geometry + ":"));
            ligands = Molutils.calculate3DCoordinates1(pZero, pOne, pStaggered, geometry, length, angles[geometry - 2]);
            for (i = 0; i < ligands.size(); ++i) {
                logger.info((Object)("...ligand:" + ligands.get(i)));
            }
            for (i = 0; i < ligands.size(); ++i) {
                logger.info((Object)("distance: ref-" + i + " = " + ligands.get(i).getDistanceFromPoint(pZero)));
            }
            for (i = 0; i < ligands.size(); ++i) {
                for (j = i + 1; j < ligands.size(); ++j) {
                    logger.info((Object)("angle: " + i + "-ref-" + j + " = " + Point3.getAngle((Point3)ligands.get(i), (Point3)pZero, (Point3)ligands.get(j))));
                }
                logger.info((Object)("angle: lig-ref-refa = " + Point3.getAngle((Point3)ligands.get(i), (Point3)pZero, (Point3)pOne)));
            }
            for (i = 0; i < ligands.size(); ++i) {
                logger.info((Object)("torsion: " + i + "-ref-ref1-ref2 = " + Point3.getTorsion((Point3)ligands.get(i), (Point3)pZero, (Point3)pOne, (Point3)pStaggered)));
            }
        }
        logger.info((Object)"\n\nadd ligands to atom with two ligands");
        logger.info((Object)("add ligands to: " + pZero + "; length: " + length + "; angle: " + angle));
        logger.info((Object)("reference atoms: " + pTwoa + "/" + pTwob));
        for (geometry = 3; geometry <= 4; ++geometry) {
            logger.info((Object)("\nType of geometry: " + geometry + ":"));
            ligands = Molutils.calculate3DCoordinates2(pZero, pTwoa, pTwob, geometry, length, angles[geometry - 2]);
            for (i = 0; i < ligands.size(); ++i) {
                logger.info((Object)("...ligand:" + ligands.get(i)));
            }
            for (i = 0; i < ligands.size(); ++i) {
                logger.info((Object)("distance: ref-" + i + " = " + ligands.get(i).getDistanceFromPoint(pZero)));
            }
            for (i = 0; i < ligands.size(); ++i) {
                for (j = i + 1; j < ligands.size(); ++j) {
                    logger.info((Object)("angle: " + i + "-ref-" + j + " = " + Point3.getAngle((Point3)ligands.get(i), (Point3)pZero, (Point3)ligands.get(j))));
                }
                logger.info((Object)("angle: lig-ref-refa = " + Point3.getAngle((Point3)ligands.get(i), (Point3)pZero, (Point3)pTwoa)));
                logger.info((Object)("angle: lig-ref-refb = " + Point3.getAngle((Point3)ligands.get(i), (Point3)pZero, (Point3)pTwob)));
            }
        }
        logger.info((Object)"\n\nadd ligand to atom with three ligands");
        logger.info((Object)("reference atoms: " + pThreea + "/" + pThreeb + "/" + pThreec));
        Point3 ligand = Molutils.calculate3DCoordinates3(pZero, pThreea, pThreeb, pThreec, length);
        logger.info((Object)("Ligand: " + ligand));
        logger.info((Object)("distance: ref-lig = " + ligand.getDistanceFromPoint(pZero)));
        logger.info((Object)("angle: lig-ref-refa = " + Point3.getAngle((Point3)ligand, (Point3)pZero, (Point3)pThreea)));
        logger.info((Object)("angle: lig-ref-refb = " + Point3.getAngle((Point3)ligand, (Point3)pZero, (Point3)pThreeb)));
        logger.info((Object)("angle: lig-ref-refc = " + Point3.getAngle((Point3)ligand, (Point3)pZero, (Point3)pThreec)));
    }

    public static void main(String[] args) {
        logger.info((Object)"Runs tests...");
        Molutils.testCalculate3DCoordinates();
    }
}

