/*
 * Decompiled with CFR 0.152.
 */
package org.xmlcml.cml.element;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import nu.xom.Nodes;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.xmlcml.cml.base.CMLConstants;
import org.xmlcml.cml.base.CMLElement;
import org.xmlcml.cml.base.CMLElements;
import org.xmlcml.cml.element.AbstractAngle;
import org.xmlcml.cml.element.CMLAtom;
import org.xmlcml.cml.element.CMLMolecule;
import org.xmlcml.cml.element.CMLScalar;
import org.xmlcml.euclid.Angle;
import org.xmlcml.euclid.Point3;
import org.xmlcml.euclid.Util;

public class CMLAngle
extends AbstractAngle {
    private static Logger LOG = Logger.getLogger(CMLAngle.class);
    public static final String NS = "cml:angle";

    public CMLAngle() {
    }

    public CMLAngle(CMLAngle old) {
        super(old);
    }

    @Override
    public Element copy() {
        return new CMLAngle(this);
    }

    @Override
    public CMLElement makeElementInContext(Element parent) {
        return new CMLAngle();
    }

    public List<String> getAtomIds() {
        ArrayList<String> idList = null;
        String[] atomRefs3 = this.getAtomRefs3();
        if (atomRefs3 != null) {
            idList = new ArrayList<String>();
            for (String s : atomRefs3) {
                idList.add(s);
            }
        }
        return idList;
    }

    public List<CMLAtom> getAtoms(CMLMolecule molecule) {
        ArrayList<CMLAtom> atomList = new ArrayList<CMLAtom>();
        for (String atomRef : this.getAtomRefs3()) {
            CMLAtom atom = molecule.getAtomById(atomRef);
            if (atom == null) {
                throw new RuntimeException("cannot find atom: " + atomRef);
            }
            if (atomList.contains(atom)) {
                throw new RuntimeException("duplicate atom in angle: " + atomRef);
            }
            atomList.add(atom);
        }
        return atomList;
    }

    public double getCalculatedAngle(CMLMolecule molecule) {
        List<CMLAtom> atomList = this.getAtoms(molecule);
        return this.getCalculatedAngle(atomList);
    }

    public Double getCalculatedAngle() {
        CMLMolecule molecule = CMLMolecule.getAncestorMolecule(this);
        return molecule == null ? null : Double.valueOf(this.getCalculatedAngle(molecule));
    }

    public Double getCalculatedAngle(String units) {
        Double ang = this.getCalculatedAngle();
        if (Angle.Units.RADIANS.toString().equals(units)) {
            ang = ang / 57.29577951308232;
        }
        return ang;
    }

    public double getCalculatedAngle(List<CMLAtom> atomList) {
        double calculatedAngle = Double.NaN;
        if (atomList != null) {
            if (atomList.size() != 3) {
                throw new RuntimeException("angle requires 3 atoms");
            }
            Point3[] coord = new Point3[3];
            int i = 0;
            for (CMLAtom atom : atomList) {
                coord[i] = atom.getXYZ3();
                if (coord[i++] != null) continue;
                break;
            }
            try {
                Angle angle = Point3.getAngle((Point3)coord[0], (Point3)coord[1], (Point3)coord[2]);
                if (angle != null) {
                    calculatedAngle = angle.getDegrees();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Bug: " + e);
            }
        }
        return calculatedAngle;
    }

    public String atomHash() {
        String[] a = this.getAtomRefs3();
        return a == null ? null : CMLAngle.atomHash(a[0], a[1], a[2]);
    }

    public static String atomHash(String atomId1, String atomId2, String atomId3) {
        String result = null;
        if (atomId1 != null && atomId2 != null && atomId3 != null) {
            String a1 = atomId1;
            String a3 = atomId3;
            if (atomId1.compareTo(atomId3) > 0) {
                a3 = atomId1;
                a1 = atomId3;
            } else if (atomId1.compareTo(atomId3) < 0) {
                a1 = atomId1;
                a3 = atomId3;
            }
            result = a1 + "__" + atomId2 + "__" + a3;
        }
        return result;
    }

    public static List<CMLAngle> getList(CMLElements<CMLAngle> angleElements) {
        ArrayList<CMLAngle> angleList = new ArrayList<CMLAngle>();
        for (CMLAngle angle : angleElements) {
            angleList.add(angle);
        }
        return angleList;
    }

    public static Map<String, CMLAngle> getIndexedAngles(List<CMLAngle> angleList) {
        HashMap<String, CMLAngle> angleTable = new HashMap<String, CMLAngle>();
        for (CMLAngle angle : angleList) {
            String[] id = angle.getAtomRefs3();
            String key = CMLAngle.atomHash(id[0], id[1], id[2]);
            angleTable.put(key, angle);
        }
        return angleTable;
    }

    public void setAtomRefs3(CMLAtom atom0, CMLAtom atom1, CMLAtom atom2) {
        this.setAtomRefs3(new String[]{atom0.getId(), atom1.getId(), atom2.getId()});
    }

    public static void outputHTML(Writer w, List<CMLAngle> angleList, CMLMolecule molecule) throws IOException {
        if (angleList.size() > 0) {
            w.write("<table border='1'>\n");
            w.write("<tr>");
            w.write("<th>");
            w.write("atom1 (id)");
            w.write("</th>");
            w.write("<th>");
            w.write("atom2 (id)");
            w.write("</th>");
            w.write("<th>");
            w.write("atom3 (id)");
            w.write("</th>");
            w.write("<th>");
            w.write("angle");
            w.write("</th>");
            w.write("</tr>\n");
            for (CMLAngle angle : angleList) {
                List<CMLAtom> atoms = angle.getAtoms(molecule);
                w.write("<tr>");
                for (int i = 0; i < 3; ++i) {
                    w.write("<td>");
                    CMLAtom atom = atoms.get(i);
                    Nodes labelNodes = atom.query("cml:scalar[@dictRef='iucr:_atom_site_label']", CMLConstants.CML_XPATH);
                    String label = ((CMLScalar)labelNodes.get(0)).getXMLContent() + " (" + atom.getId() + ")";
                    w.write(label == null ? atom.getId() : label);
                    w.write("</td>");
                }
                String s = "" + angle.getXMLContent();
                w.write("<td>" + s.substring(0, Math.min(6, s.length())) + "</td>");
                w.write("</tr>\n");
            }
            w.write("</table>\n");
        }
    }

    public String getString() {
        String s = "";
        String[] a = this.getAtomRefs3();
        if (a != null) {
            s = s + Util.concatenate((String[])a, (String)"-");
        }
        s = s + " ";
        s = s + this.getXMLContent();
        return s;
    }

    static {
        LOG.setLevel(Level.DEBUG);
    }
}

