/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.formula.rules;

import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.formula.MolecularFormulaRange;
import org.openscience.cdk.formula.rules.IRule;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.MolecularFormulaManipulator;

public class ElementRule
implements IRule {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(ElementRule.class);
    private MolecularFormulaRange mfRange;

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params.length != 1) {
            throw new CDKException("ElementRule expects one parameters");
        }
        if (params[0] != null && !(params[0] instanceof MolecularFormulaRange)) {
            throw new CDKException("The parameter must be of type MolecularFormulaExpand");
        }
        this.mfRange = (MolecularFormulaRange)params[0];
    }

    @Override
    public Object[] getParameters() {
        Object[] params = new Object[]{this.mfRange};
        return params;
    }

    @Override
    public double validate(IMolecularFormula formula) throws CDKException {
        logger.info((Object)"Start validation of ", new Object[]{formula});
        this.ensureDefaultOccurElements(formula.getBuilder());
        double isValid = 1.0;
        for (IElement element : MolecularFormulaManipulator.elements(formula)) {
            IIsotope elemIsotope;
            int occur = MolecularFormulaManipulator.getElementCount(formula, element);
            if (occur >= this.mfRange.getIsotopeCountMin(elemIsotope = (IIsotope)formula.getBuilder().newInstance(IIsotope.class, new Object[]{element.getSymbol()})) && occur <= this.mfRange.getIsotopeCountMax(elemIsotope)) continue;
            isValid = 0.0;
            break;
        }
        return isValid;
    }

    private void ensureDefaultOccurElements(IChemObjectBuilder builder) {
        if (this.mfRange == null) {
            String[] elements = new String[]{"C", "H", "O", "N", "Si", "P", "S", "F", "Cl", "Br", "I", "Sn", "B", "Pb", "Tl", "Ba", "In", "Pd", "Pt", "Os", "Ag", "Zr", "Se", "Zn", "Cu", "Ni", "Co", "Fe", "Cr", "Ti", "Ca", "K", "Al", "Mg", "Na", "Ce", "Hg", "Au", "Ir", "Re", "W", "Ta", "Hf", "Lu", "Yb", "Tm", "Er", "Ho", "Dy", "Tb", "Gd", "Eu", "Sm", "Pm", "Nd", "Pr", "La", "Cs", "Xe", "Te", "Sb", "Cd", "Rh", "Ru", "Tc", "Mo", "Nb", "Y", "Sr", "Rb", "Kr", "As", "Ge", "Ga", "Mn", "V", "Sc", "Ar", "Ne", "Be", "Li", "Tl", "Pb", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu"};
            this.mfRange = new MolecularFormulaRange();
            for (String element : elements) {
                this.mfRange.addIsotope((IIsotope)builder.newInstance(IIsotope.class, new Object[]{element}), 0, 50);
            }
        }
    }
}

