/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.chunker;

import java.util.Iterator;
import opennlp.tools.chunker.ChunkerME;
import opennlp.tools.chunker.ChunkerModel;
import opennlp.uima.chunker.ChunkerModelResource;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public final class Chunker
extends CasAnnotator_ImplBase {
    public static final String CHUNK_TYPE_PARAMETER = "opennlp.uima.ChunkType";
    public static final String CHUNK_TAG_FEATURE_PARAMETER = "opennlp.uima.ChunkTagFeature";
    private Type mTokenType;
    private Type mChunkType;
    private Feature mPosFeature;
    private ChunkerME mChunker;
    private UimaContext context;
    private Logger mLogger;
    private Feature mChunkFeature;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        ChunkerModel model;
        super.initialize(context);
        this.context = context;
        this.mLogger = context.getLogger();
        if (this.mLogger.isLoggable(Level.INFO)) {
            this.mLogger.log(Level.INFO, "Initializing the OpenNLP Chunker annotator.");
        }
        try {
            ChunkerModelResource modelResource = (ChunkerModelResource)context.getResourceObject(UimaUtil.MODEL_PARAMETER);
            model = modelResource.getModel();
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.mChunker = new ChunkerME(model);
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        this.mChunkType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, CHUNK_TYPE_PARAMETER);
        this.mChunkFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mChunkType, CHUNK_TAG_FEATURE_PARAMETER, "uima.cas.String");
        this.mTokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
        this.mPosFeature = AnnotatorUtil.getRequiredFeatureParameter(this.context, this.mTokenType, "opennlp.uima.POSFeature", "uima.cas.String");
    }

    private void addChunkAnnotation(CAS tcas, AnnotationFS[] tokenAnnotations, String tag, int start, int end) {
        AnnotationFS chunk = tcas.createAnnotation(this.mChunkType, tokenAnnotations[start].getBegin(), tokenAnnotations[end - 1].getEnd());
        chunk.setStringValue(this.mChunkFeature, tag);
        tcas.getIndexRepository().addFS((FeatureStructure)chunk);
    }

    public void process(CAS tcas) {
        AnnotationIndex tokenAnnotationIndex = tcas.getAnnotationIndex(this.mTokenType);
        String[] tokens = new String[tokenAnnotationIndex.size()];
        String[] pos = new String[tokenAnnotationIndex.size()];
        AnnotationFS[] tokenAnnotations = new AnnotationFS[tokenAnnotationIndex.size()];
        int index = 0;
        Iterator i$ = tokenAnnotationIndex.iterator();
        while (i$.hasNext()) {
            AnnotationFS tokenAnnotation;
            tokenAnnotations[index] = tokenAnnotation = (AnnotationFS)i$.next();
            tokens[index] = tokenAnnotation.getCoveredText();
            pos[index++] = tokenAnnotation.getFeatureValueAsString(this.mPosFeature);
        }
        String[] result = this.mChunker.chunk(tokens, pos);
        int start = -1;
        int end = -1;
        for (int i = 0; i < result.length; ++i) {
            String chunkTag = result[i];
            if (chunkTag.startsWith("B")) {
                if (start != -1) {
                    this.addChunkAnnotation(tcas, tokenAnnotations, result[i - 1].substring(2), start, end);
                }
                start = i;
                end = i + 1;
                continue;
            }
            if (chunkTag.startsWith("I")) {
                end = i + 1;
                continue;
            }
            if (chunkTag.startsWith("O")) {
                if (start == -1) continue;
                this.addChunkAnnotation(tcas, tokenAnnotations, result[i - 1].substring(2), start, end);
                start = -1;
                end = -1;
                continue;
            }
            System.out.println("Unexpected tag: " + result[i]);
        }
        if (start != -1) {
            this.addChunkAnnotation(tcas, tokenAnnotations, result[result.length - 1].substring(2), start, end);
        }
    }

    public void destroy() {
        this.mChunker = null;
    }
}

