/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.af.commons.widgets.validate.RealTextField;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.power.NCPCalculatorDialog;
import org.af.gMCP.gui.power.NCPRequestor;
import org.af.gMCP.gui.power.PDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Scenario
implements NCPRequestor,
ActionListener {
    List<JTextField> ncp = new Vector<JTextField>();
    JTextField scname;
    JButton ncpc = new JButton("Calculate NCP");
    PDialog pd;
    NCPCalculatorDialog ncpCD = null;

    public Scenario(PDialog pd, String name) {
        this.pd = pd;
        this.scname = new JTextField(name);
        for (Node n : pd.getNodes()) {
            RealTextField rt = new RealTextField("0.0");
            rt.setText("1.0");
            rt.setMaximumSize(new Dimension(Integer.MAX_VALUE, rt.getPreferredSize().height));
            this.ncp.add((JTextField)rt);
        }
        this.ncpc.addActionListener(this);
    }

    public void addComponents(JPanel panel, CellConstraints cc, int row) {
        int col = 2;
        panel.add((Component)this.scname, cc.xy(col, row));
        for (JTextField jt : this.ncp) {
            panel.add((Component)jt, cc.xy(col += 2, row));
        }
        row += 2;
    }

    public String getNCPString() {
        String s = "'" + this.scname.getText() + "'=c(";
        for (JTextField jt : this.ncp) {
            s = s + jt.getText() + ", ";
        }
        return s.substring(0, s.length() - 2) + ")";
    }

    public void loadConfig(Element e) {
        this.scname.setText(e.getAttribute("name"));
        NodeList nlist = e.getChildNodes();
        for (int i = 0; i < Math.min(nlist.getLength(), this.ncp.size()); ++i) {
            this.ncp.get(i).setText(((Element)nlist.item(i)).getAttribute("ncp"));
        }
    }

    public Element getConfigNode(Document document) {
        Element e = document.createElement("scenario");
        e.setAttribute("name", this.scname.getText());
        for (JTextField jt : this.ncp) {
            Element eNCP = document.createElement("ncp");
            eNCP.setAttribute("ncp", jt.getText());
            e.appendChild(eNCP);
        }
        return e;
    }

    @Override
    public void setNCP(List<Double> ncps) {
        for (int i = 0; i < ncps.size(); ++i) {
            Double d = ncps.get(i);
            if (d == null) continue;
            this.ncp.get(i).setText(d.toString());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.ncpCD == null) {
            this.ncpCD = new NCPCalculatorDialog(this.pd, this);
        } else {
            this.ncpCD.setNCPS(this.getOldNCP());
            this.ncpCD.setVisible(true);
        }
    }

    @Override
    public List<Double> getOldNCP() {
        Vector<Double> ncps = new Vector<Double>();
        for (JTextField n : this.ncp) {
            Double d = null;
            try {
                d = Double.parseDouble(n.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ncps.add(d);
        }
        return ncps;
    }
}

