/**
 * Copyright (c) 2024 Visa, Inc.
 *
 * This source code is licensed under the MIT license
 * https://github.com/visa/visa-chart-components/blob/master/LICENSE
 *
 **/
import{r as t,c as s,h as i,g as e}from"./p-b0ab226b.js";import{b as h}from"./p-bb2c1516.js";import{n as a,l as r}from"./p-42dcf457.js";import{s as l}from"./p-e3c165be.js";import{v as o}from"./p-b5f7528a.js";import{U as c,s as n,e as u}from"./p-5fcd3c02.js";import{c as d}from"./p-3f5e41ff.js";import{m as f}from"./p-e1d72334.js";import{m as b}from"./p-f9c89fe4.js";import"./p-b6ae930f.js";import"./p-6e7316e2.js";import"./p-09f6650c.js";function p(t,s){let i=0;if(s===undefined){for(let s of t){if(s=+s){i+=s}}}else{let e=-1;for(let h of t){if(h=+s(h,++e,t)){i+=h}}}return i}const{propDefaultValues:g}=c;class v{}v.mainTitle="Stacked Bar Chart Title";v.subTitle=g.subTitle.text;v.height=280;v.width=700;v.margin={top:400*.01,bottom:400*.01,right:400*.01,left:400*.01};v.padding={top:20,bottom:50,right:50,left:50};v.localization=g.localization;v.normalized=false;v.showTotalValue=true;v.showZeroLabels=false;v.ordinalAccessor="label";v.valueAccessor="value";v.groupAccessor="item";v.layout=g.layout;v.accessibility=g.accessibility;v.animationConfig=g.animationConfig;v.highestHeadingLevel=g.highestHeadingLevel;v.sortOrder=g.sortOrder;v.xAxis=g.xAxis;v.yAxis=g.yAxis;v.wrapLabel=g.wrapLabel;v.colorPalette=g.colorPaletteCategorical;v.hoverStyle=g.hoverStyle;v.clickStyle=g.clickStyle;v.referenceStyle=g.referenceStyle;v.cursor=g.cursor;v.roundedCorner=g.roundedCorner;v.barIntervalRatio=g.barIntervalRatio;v.hoverOpacity=g.hoverOpacity;v.dataLabel=g.dataLabelMiddle;v.legend=g.categoryLegend;v.tooltipLabel=g.tooltipLabel;v.showTooltip=g.showTooltip;v.suppressEvents=g.suppressEvents;v.referenceLines=g.referenceLines;v.annotations=g.annotations;v.clickHighlight=g.clickHighlight;const m=".o-layout{width:100%;display:-ms-flexbox;display:flex;-ms-flex-wrap:wrap;flex-wrap:wrap}.o-layout--chart{width:100%}.is--vertical .o-layout--chart{width:90%}stacked-bar-chart{cursor:default}stacked-bar-chart .annotations{pointer-events:none}stacked-bar-chart .annotations .handle{pointer-events:all}stacked-bar-chart .screen-reader-info{position:absolute;left:-9999px;top:auto;width:1px;height:1px;overflow:hidden}stacked-bar-chart .data-table-link{color:#767676;text-decoration:none;font-size:12px;margin-left:5%}stacked-bar-chart .hidden{display:none}stacked-bar-chart #visa-viz-d3-stacked-bar-container{clear:both}stacked-bar-chart .stacked-bar-legend{font-size:1em;display:-ms-flexbox;display:flex;-ms-flex-direction:row;flex-direction:row;-ms-flex-pack:start;justify-content:flex-start;-ms-flex-wrap:wrap;flex-wrap:wrap}stacked-bar-chart .stacked-bar-legend .legend{display:-ms-flexbox;display:flex;-ms-flex-direction:row;flex-direction:row;-ms-flex-pack:start;justify-content:flex-start;margin-right:10px}stacked-bar-chart .stacked-bar-legend .key-dot{margin:3px 8px}stacked-bar-chart .light .grid line{stroke:#c9c9c9;stroke-opacity:1;stroke-width:0.8}stacked-bar-chart .light .grid path{stroke-width:0}stacked-bar-chart .light .axis{font-size:12px}stacked-bar-chart .light .axis .tick text{fill:#767676}stacked-bar-chart .light .axis .tick line{stroke:#767676}stacked-bar-chart .light .axis-label{text-anchor:middle;font:1rem sans-serif}stacked-bar-chart .light .axis-mark{color:#949494;stroke-width:2px}stacked-bar-chart .light .y.axis path{stroke:#767676;opacity:0}stacked-bar-chart .light .x.axis path{stroke:transparent}stacked-bar-chart .light .o-layout--chart .bar-dataLabel-vertical{font-size:1rem;fill:#767676;font-weight:550}stacked-bar-chart .light .o-layout--chart .bar-dataLabel-horizontal{font-size:1rem;fill:#767676;font-weight:550}stacked-bar-chart .dark .grid line{stroke:lightgrey;stroke-opacity:0.7;shape-rendering:crispEdges}stacked-bar-chart .dark .grid path{stroke-width:0}stacked-bar-chart .dark .axis{font-size:12px}stacked-bar-chart .dark .axis .tick line{stroke:lightgrey}stacked-bar-chart .dark .axis .tick text{fill:grey}stacked-bar-chart .dark .axis path{stroke:black}stacked-bar-chart .dark .axis-label{text-anchor:middle;font:1rem sans-serif}stacked-bar-chart .dark .o-layout--chart svg{background:black}stacked-bar-chart .dark .o-layout--chart svg .bar-dataLabel-vertical{fill:#767676;text-anchor:middle}stacked-bar-chart .dark .o-layout--chart svg .bar-dataLabel-horizontal{fill:#767676;text-anchor:start}";const y=m;const{getGlobalInstances:k,configLocalization:x,getActiveLanguageString:w,getBrowser:A,verifyTextHasSpace:W,checkAttributeTransitions:L,createTextStrokeFilter:S,drawHoverStrokes:T,removeHoverStrokes:z,buildStrokes:D,convertColorsToTextures:C,findTagLevel:I,prepareRenderChange:O,initializeDescriptionRoot:P,initializeElementAccess:E,setElementFocusHandler:N,setElementAccessID:j,setAccessibilityController:$,hideNonessentialGroups:H,setAccessTitle:K,setAccessSubtitle:G,setAccessLongDescription:V,setAccessExecutiveSummary:M,setAccessPurpose:q,setAccessContext:R,setAccessStatistics:B,setAccessChartCounts:F,setAccessXAxis:_,setAccessYAxis:X,setAccessStructure:Y,setAccessAnnotation:U,retainAccessFocus:Z,checkAccessFocus:J,setElementInteractionAccessState:Q,setAccessibilityDescriptionWidth:tt,autoTextColor:st,annotate:it,chartAccessors:et,checkInteraction:ht,checkClicked:at,checkHovered:rt,convertVisaColor:lt,drawAxis:ot,drawGrid:ct,drawLegend:nt,setLegendInteractionState:ut,drawTooltip:dt,formatStats:ft,formatDate:bt,formatDataLabel:pt,getPadding:gt,getColors:vt,getLicenses:mt,getScopedData:yt,initTooltipStyle:kt,overrideTitleTooltip:xt,placeDataLabels:wt,transitionEndAll:At,scopeDataKeys:Wt,visaColors:Lt,validateAccessibilityProps:St,validateLocalizationProps:Tt,roundTo:zt,resolveLabelCollision:Dt,setSubTitle:Ct,setReferenceLine:It}=c;const Ot=class{constructor(i){t(this,i);this.clickEvent=s(this,"clickEvent",7);this.hoverEvent=s(this,"hoverEvent",7);this.mouseOutEvent=s(this,"mouseOutEvent",7);this.initialLoadEvent=s(this,"initialLoadEvent",7);this.initialLoadEndEvent=s(this,"initialLoadEndEvent",7);this.drawStartEvent=s(this,"drawStartEvent",7);this.drawEndEvent=s(this,"drawEndEvent",7);this.transitionEndEvent=s(this,"transitionEndEvent",7);this.shouldValidateAccessibility=true;this.shouldValidateLocalization=true;this.series=[];this.extent=[];this.datakeys=[];this.updated=true;this.shouldValidateInteractionKeys=false;this.shouldValidate=false;this.shouldUpdateData=false;this.shouldSetDimensions=false;this.shouldUpdateTableData=false;this.shouldSetColors=false;this.shouldSetSubTitle=false;this.shouldValidateAxes=false;this.shouldValidateClickHighlight=false;this.shouldUpdateScales=false;this.shouldUpdateAnnotations=false;this.shouldResetRoot=false;this.shouldEnterUpdateExit=false;this.shouldSetGlobalSelections=false;this.shouldSetTestingAttributes=false;this.shouldUpdateGeometries=false;this.shouldCheckValueAxis=false;this.shouldCheckLabelAxis=false;this.shouldUpdateXAxis=false;this.shouldUpdateYAxis=false;this.shouldUpdateXGrid=false;this.shouldUpdateYGrid=false;this.shouldUpdateBaseline=false;this.shouldSetSelectionClass=false;this.shouldUpdateCursor=false;this.shouldUpdateCorners=false;this.shouldUpdateLegendData=false;this.shouldValidateLabelPlacement=false;this.shouldValidateDataLabelAccessor=false;this.shouldUpdateLegend=false;this.shouldUpdateLegendInteractivity=false;this.shouldUpdateReferenceLines=false;this.shouldDrawInteractionState=false;this.shouldBindInteractivity=false;this.shouldSetLabelOpacity=false;this.shouldUpdateLabels=false;this.shouldUpdateTotalLabels=false;this.shouldCheckLabelColor=false;this.shouldUpdateDescriptionWrapper=false;this.shouldSetChartAccessibilityTitle=false;this.shouldSetChartAccessibilitySubtitle=false;this.shouldSetChartAccessibilityLongDescription=false;this.shouldSetChartAccessibilityExecutiveSummary=false;this.shouldSetChartAccessibilityStatisticalNotes=false;this.shouldSetChartAccessibilityStructureNotes=false;this.shouldSetParentSVGAccessibility=false;this.shouldSetGeometryAccessibilityAttributes=false;this.shouldSetGeometryAriaLabels=false;this.shouldSetGroupAccessibilityLabel=false;this.shouldSetChartAccessibilityPurpose=false;this.shouldSetChartAccessibilityContext=false;this.shouldRedrawWrapper=false;this.shouldSetTagLevels=false;this.shouldSetChartAccessibilityCount=false;this.shouldSetYAxisAccessibility=false;this.shouldSetXAxisAccessibility=false;this.shouldSetAnnotationAccessibility=false;this.shouldSetTextures=false;this.shouldSetStrokes=false;this.shouldSetLocalizationConfig=false;this.isSafari=A()==="Safari";this.strokes={};this.textStrokes={};this.topLevel="h2";this.bottomLevel="p";this.textTreatmentHandler=(t,s,i)=>{const e=n(i[s]);const h=this.clickHighlight&&this.clickHighlight.length>0&&at(t,this.clickHighlight,this.innerInteractionKeys)&&this.clickStyle.color?Lt[this.clickStyle.color]||this.clickStyle.color:this.hoverHighlight&&rt(t,this.hoverHighlight,this.innerInteractionKeys)&&this.hoverStyle.color?Lt[this.hoverStyle.color]||this.hoverStyle.color:this.preparedColors[s];const a=st(h);if(!e.classed("textIsMoving")){const t=this.textStrokes[h];if(t!==e.attr("filter")){if(this.isSafari){e.attr("filter",null);setTimeout((()=>{e.attr("filter",t)}),0)}else{e.attr("filter",t)}}}else{e.attr("filter",null)}return a};this.mainTitle=v.mainTitle;this.subTitle=v.subTitle;this.height=v.height;this.width=v.width;this.layout=v.layout;this.highestHeadingLevel=v.highestHeadingLevel;this.margin=v.margin;this.padding=v.padding;this.data=undefined;this.uniqueID=undefined;this.localization=v.localization;this.ordinalAccessor=v.ordinalAccessor;this.valueAccessor=v.valueAccessor;this.groupAccessor=v.groupAccessor;this.sortOrder=v.sortOrder;this.xAxis=v.xAxis;this.yAxis=v.yAxis;this.wrapLabel=v.wrapLabel;this.normalized=v.normalized;this.colorPalette=v.colorPalette;this.colors=undefined;this.hoverStyle=v.hoverStyle;this.clickStyle=v.clickStyle;this.referenceStyle=v.referenceStyle;this.cursor=v.cursor;this.roundedCorner=v.roundedCorner;this.barIntervalRatio=v.barIntervalRatio;this.hoverOpacity=v.hoverOpacity;this.animationConfig=v.animationConfig;this.dataLabel=v.dataLabel;this.dataKeyNames=undefined;this.showTotalValue=v.showTotalValue;this.showTooltip=v.showTooltip;this.tooltipLabel=v.tooltipLabel;this.accessibility=v.accessibility;this.legend=v.legend;this.annotations=v.annotations;this.showZeroLabels=v.showZeroLabels;this.minValueOverride=undefined;this.maxValueOverride=undefined;this.referenceLines=v.referenceLines;this.suppressEvents=v.suppressEvents;this.hoverHighlight=undefined;this.clickHighlight=v.clickHighlight;this.interactionKeys=undefined;this.unitTest=false}dataWatcher(t,s){this.updated=true;this.shouldUpdateData=true;this.shouldValidateClickHighlight=true;this.shouldSetColors=true;this.shouldSetTextures=true;this.shouldDrawInteractionState=true;this.shouldUpdateScales=true;this.shouldUpdateTableData=true;this.shouldSetGlobalSelections=true;this.shouldSetTestingAttributes=true;this.shouldEnterUpdateExit=true;this.shouldSetGeometryAccessibilityAttributes=true;this.shouldSetGeometryAriaLabels=true;this.shouldUpdateXGrid=true;this.shouldUpdateYGrid=true;this.shouldUpdateLegendData=true;this.shouldValidate=true;this.shouldUpdateGeometries=true;this.shouldUpdateXAxis=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateYAxis=true;this.shouldSetYAxisAccessibility=true;this.shouldUpdateLabels=true;this.shouldCheckLabelColor=true;this.shouldSetLabelOpacity=true;this.shouldUpdateTotalLabels=true;this.shouldUpdateLegend=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateBaseline=true;this.shouldUpdateAnnotations=true;this.shouldSetStrokes=true}idWatcher(t,s){console.error("Change detected in prop uniqueID from value "+s+" to value "+t+". This prop cannot be changed after component has loaded.")}headingWatcher(t,s){this.shouldRedrawWrapper=true;this.shouldSetTagLevels=true;this.shouldSetChartAccessibilityCount=true;this.shouldSetYAxisAccessibility=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetAnnotationAccessibility=true;this.shouldSetSubTitle=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetChartAccessibilitySubtitle=true;this.shouldSetChartAccessibilityLongDescription=true;this.shouldSetChartAccessibilityContext=true;this.shouldSetChartAccessibilityExecutiveSummary=true;this.shouldSetChartAccessibilityPurpose=true;this.shouldSetChartAccessibilityStatisticalNotes=true;this.shouldSetChartAccessibilityStructureNotes=true}titleWatcher(t,s){this.shouldValidate=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetParentSVGAccessibility=true}subtitleWatcher(t,s){this.shouldSetSubTitle=true;this.shouldSetChartAccessibilitySubtitle=true;this.shouldSetParentSVGAccessibility=true}dimensionWatcher(t,s){this.shouldSetDimensions=true;this.shouldUpdateScales=true;this.shouldResetRoot=true;this.shouldUpdateGeometries=true;this.shouldUpdateXGrid=true;this.shouldUpdateYGrid=true;this.shouldUpdateXAxis=true;this.shouldUpdateYAxis=true;this.shouldUpdateLabels=true;this.shouldUpdateTotalLabels=true;this.shouldUpdateLegend=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateBaseline=true;this.shouldUpdateAnnotations=true;this.shouldSetLabelOpacity=true}layoutWatcher(t,s){this.interpolating=false;this.shouldValidateLabelPlacement=true;this.shouldUpdateScales=true;this.shouldValidateAxes=true;this.shouldResetRoot=true;this.shouldUpdateGeometries=true;this.shouldUpdateXGrid=true;this.shouldUpdateYGrid=true;this.shouldUpdateXAxis=true;this.shouldUpdateYAxis=true;this.shouldUpdateLabels=true;this.shouldUpdateTotalLabels=true;this.shouldUpdateLegend=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateBaseline=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAccessibilityAttributes=true;this.shouldSetLabelOpacity=true}ordinalAccessorWatcher(t,s){this.shouldSetGlobalSelections=true;this.shouldEnterUpdateExit=true;this.shouldUpdateScales=true;this.shouldUpdateData=true;this.shouldUpdateTableData=true;this.shouldUpdateLegendData=true;this.shouldSetColors=true;this.shouldUpdateGeometries=true;this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldUpdateLabels=true;this.shouldUpdateTotalLabels=true;this.shouldUpdateLegend=true;if(!(this.interactionKeys&&this.interactionKeys.length)){this.shouldValidateInteractionKeys=true;this.shouldSetSelectionClass=true}this.shouldUpdateReferenceLines=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetLabelOpacity=true;this.shouldSetStrokes=true;this.shouldSetTextures=true;this.shouldCheckValueAxis=true}valueAccessorWatcher(t,s){this.shouldUpdateData=true;this.shouldValidateClickHighlight=true;this.shouldUpdateScales=true;this.shouldSetColors=true;this.shouldUpdateGeometries=true;this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldSetLabelOpacity=true;this.shouldValidateDataLabelAccessor=true;this.shouldUpdateLabels=true;this.shouldUpdateTotalLabels=true;this.shouldUpdateTableData=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetStrokes=true;this.shouldSetTextures=true;this.shouldSetGlobalSelections=true;this.shouldCheckValueAxis=true}groupAccessorWatcher(t,s){this.shouldUpdateData=true;this.shouldValidateClickHighlight=true;this.shouldUpdateTableData=true;this.shouldUpdateScales=true;this.shouldSetGlobalSelections=true;this.shouldEnterUpdateExit=true;this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldSetLabelOpacity=true;this.shouldUpdateGeometries=true;this.shouldUpdateLabels=true;this.shouldUpdateTotalLabels=true;this.shouldCheckLabelAxis=true;this.shouldUpdateBaseline=true;this.shouldUpdateReferenceLines=true;if(!(this.interactionKeys&&this.interactionKeys.length)){this.shouldValidateInteractionKeys=true;this.shouldSetSelectionClass=true}this.shouldUpdateAnnotations=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetGroupAccessibilityLabel=true;this.shouldSetStrokes=true;this.shouldSetTextures=true}sortWatcher(t,s){this.updated=true;this.shouldUpdateData=true;this.shouldSetGlobalSelections=true;this.shouldSetTestingAttributes=true;this.shouldEnterUpdateExit=true;this.shouldUpdateTableData=true;this.shouldUpdateScales=true;this.shouldUpdateGeometries=true;this.shouldUpdateLabels=true;this.shouldUpdateTotalLabels=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAccessibilityAttributes=true;this.shouldSetGeometryAriaLabels=true;this.shouldCheckLabelAxis=true}xAxisWatcher(t,s){this.shouldValidateAxes=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateXAxis=true;const i=t&&t.gridVisible;const e=s&&s.gridVisible;const h=t&&t.tickInterval?t.tickInterval:0;const a=s&&s.tickInterval?s.tickInterval:0;if(i!==e||h!==a){this.shouldUpdateXGrid=true}}yAxisWatcher(t,s){this.shouldValidateAxes=true;this.shouldSetYAxisAccessibility=true;this.shouldUpdateYAxis=true;const i=t&&t.gridVisible;const e=s&&s.gridVisible;const h=t&&t.tickInterval?t.tickInterval:0;const a=s&&s.tickInterval?s.tickInterval:0;if(i!==e||h!==a){this.shouldUpdateYGrid=true}}wrapLabelWatcher(t,s){this.shouldCheckLabelAxis=true}normalizedWatcher(t,s){this.shouldUpdateData=true;this.shouldValidateClickHighlight=true;this.shouldUpdateScales=true;this.shouldSetColors=true;this.shouldUpdateGeometries=true;this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldSetLabelOpacity=true;this.shouldCheckValueAxis=true;this.shouldUpdateLabels=true;this.shouldUpdateTotalLabels=true;this.shouldUpdateTableData=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateAnnotations=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetGroupAccessibilityLabel=true}paletteWatcher(t,s){this.shouldSetColors=true;this.shouldDrawInteractionState=true;this.shouldUpdateLegend=true;this.shouldCheckLabelColor=true;this.shouldSetStrokes=true;this.shouldSetTextures=true}colorsWatcher(t,s){this.shouldSetColors=true;this.shouldDrawInteractionState=true;this.shouldUpdateLegend=true;this.shouldCheckLabelColor=true;this.shouldSetStrokes=true;this.shouldSetTextures=true}hoverStyleWatcher(t,s){this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldSetLabelOpacity=true;this.shouldSetStrokes=true}clickStyleWatcher(t,s){this.shouldDrawInteractionState=true;this.shouldSetSelectionClass=true;this.shouldCheckLabelColor=true;this.shouldSetLabelOpacity=true;this.shouldSetStrokes=true}referenceWatcher(t,s){this.shouldUpdateReferenceLines=true}cursorWatcher(t,s){this.shouldUpdateCursor=true}cornerWatcher(t,s){this.shouldUpdateCorners=true}intervalRatioWatcher(t,s){this.shouldUpdateScales=true;this.shouldUpdateGeometries=true;this.shouldSetLabelOpacity=true;this.shouldCheckLabelAxis=true;this.shouldUpdateLabels=true;this.shouldUpdateAnnotations=true}hoverOpacityWatcher(t,s){this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldSetLabelOpacity=true}labelWatcher(t,s){this.shouldUpdateLabels=true;this.shouldUpdateTotalLabels=true;this.shouldUpdateGeometries=true;this.shouldUpdateTableData=true;const i=t&&t.placement?t.placement:false;const e=s&&s.placement?s.placement:false;const h=t&&t.visible;const a=s&&s.visible;const r=t&&t.labelAccessor?t.labelAccessor:false;const l=s&&s.labelAccessor?s.labelAccessor:false;if(h!==a){this.shouldSetLabelOpacity=true}if(i!==e){this.shouldSetLabelOpacity=true;this.shouldValidateLabelPlacement=true;this.shouldCheckLabelColor=true}if(r!==l){this.shouldValidateDataLabelAccessor=true}}showTotalValueWatcher(t,s){this.shouldUpdateTotalLabels=true;this.shouldUpdateTableData=true;this.shouldSetGroupAccessibilityLabel=true;this.shouldSetParentSVGAccessibility=true;this.shouldSetGeometryAriaLabels=true}showTooltipWatcher(t,s){this.shouldDrawInteractionState=true}tooltipLabelWatcher(t,s){this.shouldUpdateTableData=true;this.shouldSetParentSVGAccessibility=true;this.shouldSetGeometryAriaLabels=true}localizationWatcher(t,s){const i=t&&t.language?t.language:false;const e=s&&s.language?s.language:false;if(i!==e){this.shouldSetLocalizationConfig=true;this.shouldUpdateTableData=true;this.shouldValidateDataLabelAccessor=true;this.shouldCheckLabelColor=true;this.shouldRedrawWrapper=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetChartAccessibilityCount=true;this.shouldSetYAxisAccessibility=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true}const h=t&&t.numeralLocale?t.numeralLocale:false;const a=s&&s.numeralLocale?s.numeralLocale:false;if(h!==a){this.shouldSetLocalizationConfig=true;this.shouldUpdateTableData=true;this.shouldValidateDataLabelAccessor=true;this.shouldCheckLabelColor=true;this.shouldRedrawWrapper=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetChartAccessibilityCount=true;this.shouldSetYAxisAccessibility=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true}}accessibilityWatcher(t,s){this.shouldValidate=true;const i=t&&t.title?t.title:false;const e=s&&s.title?s.title:false;if(i!==e){this.shouldUpdateDescriptionWrapper=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetParentSVGAccessibility=true}const h=t&&t.executiveSummary?t.executiveSummary:false;const a=s&&s.executiveSummary?s.executiveSummary:false;if(h!==a){this.shouldSetChartAccessibilityExecutiveSummary=true}const r=t&&t.purpose?t.purpose:false;const l=s&&s.purpose?s.purpose:false;if(r!==l){this.shouldSetChartAccessibilityPurpose=true}const o=t&&t.longDescription?t.longDescription:false;const c=s&&s.longDescription?s.longDescription:false;if(o!==c){this.shouldSetChartAccessibilityLongDescription=true}const n=t&&t.contextExplanation?t.contextExplanation:false;const u=s&&s.contextExplanation?s.contextExplanation:false;if(n!==u){this.shouldSetChartAccessibilityContext=true}const d=t&&t.statisticalNotes?t.statisticalNotes:false;const f=s&&s.statisticalNotes?s.statisticalNotes:false;if(d!==f){this.shouldSetChartAccessibilityStatisticalNotes=true}const b=t&&t.structureNotes?t.structureNotes:false;const p=s&&s.structureNotes?s.structureNotes:false;if(b!==p){this.shouldSetChartAccessibilityStructureNotes=true}const g=t&&t.includeDataKeyNames;const v=s&&s.includeDataKeyNames;const m=t&&t.elementDescriptionAccessor?t.elementDescriptionAccessor:false;const y=s&&s.elementDescriptionAccessor?s.elementDescriptionAccessor:false;if(g!==v||m!==y){if(g!==v){this.shouldSetGroupAccessibilityLabel=true}this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true}const k=t&&t.hideTextures?t.hideTextures:false;const x=s&&s.hideTextures?s.hideTextures:false;if(k!==x){this.shouldSetTextures=true;this.shouldUpdateLegend=true;this.shouldDrawInteractionState=true}const w=t&&t.showSmallLabels?t.showSmallLabels:false;const A=s&&s.showSmallLabels?s.showSmallLabels:false;if(w!==A){this.shouldSetLabelOpacity=true}const W=t&&t.hideStrokes?t.hideStrokes:false;const L=s&&s.hideStrokes?s.hideStrokes:false;if(W!==L){this.shouldSetStrokes=true;this.shouldUpdateLegend=true;this.shouldDrawInteractionState=true}const S=t&&t.keyboardNavConfig&&t.keyboardNavConfig.disabled?t.keyboardNavConfig.disabled:false;const T=s&&s.keyboardNavConfig&&s.keyboardNavConfig.disabled?s.keyboardNavConfig.disabled:false;const z=t&&t.elementsAreInterface?t.elementsAreInterface:false;const D=s&&s.elementsAreInterface?s.elementsAreInterface:false;if(S!==T||z!==D){this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldRedrawWrapper=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetChartAccessibilitySubtitle=true;this.shouldSetChartAccessibilityLongDescription=true;this.shouldSetChartAccessibilityContext=true;this.shouldSetChartAccessibilityExecutiveSummary=true;this.shouldSetChartAccessibilityPurpose=true;this.shouldSetChartAccessibilityStatisticalNotes=true;this.shouldSetChartAccessibilityStructureNotes=true}if(z!==D){this.shouldSetSelectionClass=true}}showZeroLabelsWatcher(t,s){this.shouldUpdateLabels=true}legendWatcher(t,s){this.shouldUpdateLegend=true;const i=t&&t.interactive;const e=s&&s.interactive;if(i!==e){this.shouldUpdateLegendInteractivity=true}}annotationsWatcher(t,s){this.shouldValidate=true;this.shouldUpdateAnnotations=true;this.shouldSetAnnotationAccessibility=true}valueOverrideWatcher(t,s){this.shouldUpdateScales=true;this.shouldCheckValueAxis=true;this.shouldUpdateGeometries=true;this.shouldUpdateLabels=true;this.shouldUpdateTotalLabels=true;this.shouldUpdateReferenceLines=true;this.shouldUpdateBaseline=true;this.shouldUpdateAnnotations=true}interactionWatcher(t,s){this.shouldValidateInteractionKeys=true;this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldSetLabelOpacity=true;this.shouldSetSelectionClass=true;this.shouldUpdateTableData=true;this.shouldSetGeometryAriaLabels=true}dataKeyNamesWatcher(t,s){this.shouldUpdateXAxis=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateYAxis=true;this.shouldSetYAxisAccessibility=true;this.shouldSetParentSVGAccessibility=true;this.shouldSetGroupAccessibilityLabel=true;this.shouldSetGeometryAriaLabels=true;this.shouldUpdateTableData=true}hoverWatcher(t,s){this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldSetLabelOpacity=true}clickWatcher(t,s){this.shouldValidateClickHighlight=true;this.shouldDrawInteractionState=true;this.shouldCheckLabelColor=true;this.shouldSetLabelOpacity=true}suppressWatcher(t,s){this.shouldBindInteractivity=true;this.shouldUpdateCursor=true;this.shouldUpdateLegendInteractivity=true;this.shouldSetGeometryAriaLabels=true;this.shouldSetParentSVGAccessibility=true;this.shouldUpdateDescriptionWrapper=true;this.shouldRedrawWrapper=true;this.shouldValidate=true;this.shouldSetSubTitle=true;this.shouldSetChartAccessibilityTitle=true;this.shouldSetChartAccessibilitySubtitle=true;this.shouldSetChartAccessibilityLongDescription=true;this.shouldSetChartAccessibilityContext=true;this.shouldSetChartAccessibilityExecutiveSummary=true;this.shouldSetChartAccessibilityPurpose=true;this.shouldSetChartAccessibilityStatisticalNotes=true;this.shouldSetChartAccessibilityStructureNotes=true}unitTestWatcher(t,s){this.shouldSetTestingAttributes=true}componentWillLoad(){const t=this.uniqueID||"stacked-bar-chart-"+o();this.initialLoadEvent.emit({chartID:t});return new Promise((s=>{this.duration=0;this.defaults=true;this.chartID=t;this.stackedBarChartEl.id=this.chartID;this.setLocalizationConfig();this.setTagLevels();this.prepareData();this.prepareLegendData();this.setDimensions();this.prepareScales();this.validateClickHighlight();this.validateInteractionKeys();this.validateDataLabelAccessor();this.validateAxes();this.setTableData();this.shouldValidateAccessibilityProps();this.shouldValidateLocalizationProps();this.setColors();s("component will load")}))}componentWillUpdate(){return new Promise((t=>{t("component will update")}))}componentDidLoad(){return new Promise((t=>{this.renderRootElements();this.setTooltipInitialStyle();this.setChartDescriptionWrapper();this.setChartAccessibilityTitle();this.setChartAccessibilitySubtitle();this.setChartAccessibilityLongDescription();this.setChartAccessibilityExecutiveSummary();this.setChartAccessibilityPurpose();this.setChartAccessibilityContext();this.setChartAccessibilityStatisticalNotes();this.setChartAccessibilityStructureNotes();this.setParentSVGAccessibility();this.reSetRoot();this.setTextures();this.setStrokes();this.setSubTitleElements();this.drawXGrid();this.drawYGrid();this.setGlobalSelections();this.setTestingAttributes();this.enterGeometries();this.updateGeometries();this.exitGeometries();this.setRoundedCorners();this.drawGeometries();this.enterDataLabels();this.updateDataLabels();this.exitDataLabels();this.enterTotalDataLabels();this.updateTotalDataLabels();this.exitTotalDataLabels();this.setChartCountAccessibility();this.setGeometryAccessibilityAttributes();this.setGeometryAriaLabels();this.drawLegendElements();this.bindLegendInteractivity();this.validateLabelPlacement();this.drawDataLabels();this.drawTotalDataLabels();this.drawReferenceLines();this.setSelectedClass();this.checkLabelColorAgainstBackground();this.updateCursor();this.bindInteractivity();this.drawAnnotations();this.setAnnotationAccessibility();this.drawXAxis();this.setXAxisAccessibility();this.drawYAxis();this.setYAxisAccessibility();this.drawBaseline();H(this.root.node(),this.barG.node());this.setGroupAccessibilityID();this.onChangeHandler();this.defaults=false;t("component did load")})).then((()=>this.initialLoadEndEvent.emit({chartID:this.chartID})))}componentDidUpdate(){return new Promise((t=>{this.duration=!this.animationConfig||!this.animationConfig.disabled?750:0;if(this.shouldUpdateDescriptionWrapper){this.setChartDescriptionWrapper();this.shouldUpdateDescriptionWrapper=false}if(this.shouldSetChartAccessibilityCount){this.setChartCountAccessibility();this.shouldSetChartAccessibilityCount=false}if(this.shouldSetChartAccessibilityTitle){this.setChartAccessibilityTitle();this.shouldSetChartAccessibilityTitle=false}if(this.shouldSetChartAccessibilitySubtitle){this.setChartAccessibilitySubtitle();this.shouldSetChartAccessibilitySubtitle=false}if(this.shouldSetChartAccessibilityLongDescription){this.setChartAccessibilityLongDescription();this.shouldSetChartAccessibilityLongDescription=false}if(this.shouldSetChartAccessibilityExecutiveSummary){this.setChartAccessibilityExecutiveSummary();this.shouldSetChartAccessibilityExecutiveSummary=false}if(this.shouldSetChartAccessibilityPurpose){this.setChartAccessibilityPurpose();this.shouldSetChartAccessibilityPurpose=false}if(this.shouldSetChartAccessibilityContext){this.setChartAccessibilityContext();this.shouldSetChartAccessibilityContext=false}if(this.shouldSetChartAccessibilityStatisticalNotes){this.setChartAccessibilityStatisticalNotes();this.shouldSetChartAccessibilityStatisticalNotes=false}if(this.shouldSetChartAccessibilityStructureNotes){this.setChartAccessibilityStructureNotes();this.shouldSetChartAccessibilityStructureNotes=false}if(this.shouldSetParentSVGAccessibility){this.setParentSVGAccessibility();this.shouldSetParentSVGAccessibility=false}if(this.shouldResetRoot){this.reSetRoot();this.shouldResetRoot=false}if(this.shouldSetTextures){this.setTextures();this.shouldSetTextures=false}if(this.shouldSetStrokes){this.setStrokes();this.shouldSetStrokes=false}if(this.shouldSetGlobalSelections){this.setGlobalSelections();this.shouldSetGlobalSelections=false}if(this.shouldSetTestingAttributes){this.setTestingAttributes();this.shouldSetTestingAttributes=false}if(this.shouldSetSubTitle){this.setSubTitleElements();this.shouldSetSubTitle=false}if(this.shouldUpdateXGrid){this.drawXGrid();this.shouldUpdateXGrid=false}if(this.shouldUpdateYGrid){this.drawYGrid();this.shouldUpdateYGrid=false}if(this.shouldEnterUpdateExit){this.enterGeometries();this.updateGeometries();this.exitGeometries();this.enterDataLabels();this.updateDataLabels();this.exitDataLabels();this.enterTotalDataLabels();this.updateTotalDataLabels();this.exitTotalDataLabels();this.shouldEnterUpdateExit=false}if(this.shouldUpdateCorners){this.setRoundedCorners();this.shouldUpdateCorners=false}if(this.shouldUpdateGeometries){this.drawGeometries();this.shouldUpdateGeometries=false}if(this.shouldSetGeometryAccessibilityAttributes){this.setGeometryAccessibilityAttributes();this.shouldSetGeometryAccessibilityAttributes=false}if(this.shouldSetGeometryAriaLabels){this.setGeometryAriaLabels();this.shouldSetGeometryAriaLabels=false}if(this.shouldSetGroupAccessibilityLabel){this.setGroupAccessibilityID();this.shouldSetGroupAccessibilityLabel=false}if(this.shouldUpdateLegend){this.drawLegendElements();this.shouldUpdateLegend=false}if(this.shouldUpdateLabels){this.drawDataLabels();this.shouldUpdateLabels=false}if(this.shouldUpdateTotalLabels){this.drawTotalDataLabels();this.shouldUpdateTotalLabels=false}if(this.shouldUpdateReferenceLines){this.drawReferenceLines();this.shouldUpdateReferenceLines=false}if(this.shouldDrawInteractionState){this.updateInteractionState();this.shouldDrawInteractionState=false}if(this.shouldSetLabelOpacity){this.setLabelOpacity();this.shouldSetLabelOpacity=false}if(this.shouldCheckLabelColor){this.checkLabelColorAgainstBackground();this.shouldCheckLabelColor=false}if(this.shouldSetSelectionClass){this.setSelectedClass();this.shouldSetSelectionClass=false}if(this.shouldUpdateLegendInteractivity){this.bindLegendInteractivity();this.shouldUpdateLegendInteractivity=false}if(this.shouldUpdateCursor){this.updateCursor();this.shouldUpdateCursor=false}if(this.shouldBindInteractivity){this.bindInteractivity();this.shouldBindInteractivity=false}if(this.shouldUpdateAnnotations){this.drawAnnotations();this.shouldUpdateAnnotations=false}if(this.shouldSetAnnotationAccessibility){this.setAnnotationAccessibility();this.shouldSetAnnotationAccessibility=false}if(this.shouldUpdateXAxis){this.drawXAxis();this.shouldUpdateXAxis=false}if(this.shouldSetXAxisAccessibility){this.setXAxisAccessibility();this.shouldSetXAxisAccessibility=false}if(this.shouldUpdateYAxis){this.drawYAxis();this.shouldUpdateYAxis=false}if(this.shouldSetYAxisAccessibility){this.setYAxisAccessibility();this.shouldSetYAxisAccessibility=false}if(this.shouldUpdateBaseline){this.drawBaseline();this.shouldUpdateBaseline=false}this.onChangeHandler();t("component did update")})).then((()=>this.drawEndEvent.emit({chartID:this.chartID})))}shouldValidateLocalizationProps(){const t=k();const s=t.i18Next.language;const i=t.i18Next.getResourceBundle(s);const e=t.numeral.localeData();if(this.shouldValidateLocalization&&!this.localization.skipValidation){this.shouldValidateLocalization=false;Tt(this.chartID,Object.assign(Object.assign({},this.localization),{language:i,numeralLocale:e}))}}shouldValidateAccessibilityProps(){if(this.shouldValidateAccessibility&&!this.accessibility.disableValidation){this.shouldValidateAccessibility=false;St(this.chartID,this.accessibility,{annotations:this.annotations,data:this.data,uniqueID:this.uniqueID,context:{mainTitle:this.mainTitle,onClickEvent:this.suppressEvents?undefined:this.clickEvent.emit,tooltipLabel:this.tooltipLabel,dataLabel:this.dataLabel,valueAccessor:this.valueAccessor},misc:{normalized:this.normalized}})}}validateLabelPlacement(){if(this.layout==="vertical"){if(!(this.dataLabel.placement==="top"||this.dataLabel.placement==="middle"||this.dataLabel.placement==="bottom"||this.dataLabel.placement==="auto")){this.dataLabel.placement="middle"}}else{if(!(this.dataLabel.placement==="end"||this.dataLabel.placement==="middle"||this.dataLabel.placement==="base"||this.dataLabel.placement==="auto")){this.dataLabel.placement="middle"}}}validateInteractionKeys(){this.innerInteractionKeys=this.interactionKeys&&this.interactionKeys.length?this.interactionKeys:[this.ordinalAccessor]}validateDataLabelAccessor(){this.innerLabelAccessor=this.dataLabel.labelAccessor?this.dataLabel.labelAccessor:this.valueAccessor}validateAxes(){this.innerXAxis=Object.assign(Object.assign({},this.xAxis),{gridVisible:!(this.layout==="vertical")&&this.xAxis.gridVisible});this.innerYAxis=Object.assign(Object.assign({},this.yAxis),{gridVisible:this.layout==="vertical"&&this.yAxis.gridVisible})}getLanguageString(){return w(this.localization)}setLocalizationConfig(){x(this.localization)}modifier(t){return!this.normalized||t.getSum()===0?1:t.getSum()}setDimensions(){this.padding=typeof this.padding==="string"?gt(this.padding):this.padding;this.innerHeight=this.height-this.margin.top-this.margin.bottom;this.innerWidth=this.width-this.margin.left-this.margin.right;this.innerPaddedHeight=this.innerHeight-this.padding.top-this.padding.bottom;this.innerPaddedWidth=this.innerWidth-this.padding.left-this.padding.right}prepareData(){this.extent=[0,0];const t=[];this.data.forEach((s=>{const i=Object.keys(s);const e={};i.forEach((t=>{e[t]=!(s[t]instanceof Date)?s[t]:new Date(s[t].getTime())}));t.push(e)}));const s=a().key((t=>{t[this.valueAccessor]=parseFloat(t[this.valueAccessor]);t[this.groupAccessor]=t[this.groupAccessor]instanceof Date?bt({date:t[this.groupAccessor],format:this.layout==="vertical"?this.xAxis.format:this.yAxis.format,offsetTimezone:true}):t[this.groupAccessor];return t[this.groupAccessor]})).entries(t);this.interpolating=this.series.length?this.series:"";if(this.interpolating){this.interpolating.stackOrder=this.stackOrder}const i={};const e=t=>{let s=0;const e=t.length;const h=[];this.stackOrder={};for(s=0;s<e;s++){const e=Object.assign({},t[s]);let a=0;let r=0;let l=0;const o={positive:0,negative:0};const c=t[s].values;const n=c.length;const u=p(c,(t=>t[this.valueAccessor]));e.values=[];let d=0;for(a=0;a<n;a++){const t=Object.assign({},c[a]);const s=t[this.valueAccessor];if(s>=0&&u!==0){t.stackEnd=o.positive;o.positive+=s;t.stackStart=o.positive}else if(s<0){t.stackStart=o.negative;o.negative+=s;t.stackEnd=o.negative}else{t.stackEnd=o.positive;o.positive+=1e-6;t.stackStart=o.positive}let h=this.stackOrder[t[this.groupAccessor]];if(!h){this.stackOrder[t[this.groupAccessor]]={};h=this.stackOrder[t[this.groupAccessor]]}if(!h[t[this.ordinalAccessor]]){h[t[this.ordinalAccessor]]={previous:d,value:s,stackStart:t.stackStart,stackEnd:t.stackEnd}}t.enteringStackStart=false;if(this.interpolating&&this.interpolating.stackOrder[t[this.groupAccessor]]){const i=this.interpolating.stackOrder[t[this.groupAccessor]];const e=t=>{if(t===0){return 0}else if(i[t]){if(s>=0&&i[t].value>=0){return i[t].stackStart}else if(s<0&&i[t].value<0){return i[t].stackEnd}}const a=h[t].previous;return e(a)};if(!i[t[this.ordinalAccessor]]){t.enteringStackStart=e(d)}}d=t[this.ordinalAccessor];t.getSum=()=>e.sum;r+=s;if(s>0){l+=s}if(!i[t[this.ordinalAccessor]]){i[t[this.ordinalAccessor]]=1}e.values.push(t)}if(o.positive>this.extent[1]){this.extent[1]=o.positive}if(o.negative<this.extent[0]){this.extent[0]=o.negative}e.sum=r;e.sumMessage="Sum "+r;e.sumAboveZero=l;h.push(e)}return h};e(s);this.datakeys=Object.keys(i);this.series=e(s);if(this.sortOrder==="asc"){this.series=[...this.series].sort(((t,s)=>t.sum-s.sum))}else if(this.sortOrder==="desc"){this.series=[...this.series].sort(((t,s)=>s.sum-t.sum))}}prepareLegendData(){this.legendData=this.series[0].values}validateClickHighlight(){if(this.clickHighlight&&this.clickHighlight.length>0){this.clickHighlight.map((t=>{t[this.groupAccessor]=t[this.groupAccessor]instanceof Date?bt({date:t[this.groupAccessor],format:this.layout==="vertical"?this.xAxis.format:this.yAxis.format,offsetTimezone:true}):t[this.groupAccessor]}))}}setTableData(){const t=[];this.series.forEach((s=>{s.values.forEach((s=>{t.push(s)}))}));const s=Wt(this,et,"stacked-bar-chart");if(this.normalized){const i=this.dataKeyNames&&(this.dataKeyNames[`${this.valueAccessor}`]||this.dataKeyNames[`${this.valueAccessor}%`])?this.dataKeyNames[`${this.valueAccessor}%`]||this.dataKeyNames[`${this.valueAccessor}`]+" (%)":`${this.valueAccessor}%`;s[i]="0[.][0][0]%";t.forEach((t=>{t[i]=t[`${this.valueAccessor}`]/t.getSum()}))}this.tableData=yt(t,s);this.tableColumns=Object.keys(s)}setSubTitleElements(){Ct({root:this.subTitleG,subTitle:this.subTitle})}setColors(){this.preparedColors=this.colors?lt(this.colors):vt(this.colorPalette,this.datakeys.length)}setTextures(){const t=this.preparedColors.range?this.preparedColors.range():this.preparedColors;if(this.accessibility.hideTextures||t.length>6){this.colorArr=this.preparedColors}else{const s=t;const i=C({colors:s,rootSVG:this.svg.node(),id:this.chartID,scheme:"categorical",disableTransitions:!this.duration});this.colorArr=this.preparedColors.range?this.preparedColors.copy().range(i):i}}setStrokes(){const t=this.preparedColors.range?this.preparedColors.range():this.preparedColors;this.strokes=D({root:this.svg.node(),id:this.chartID,colors:t,clickStyle:this.clickStyle,hoverStyle:this.hoverStyle,stacked:true});this.textStrokes={};t.forEach((t=>{this.textStrokes[t]=S({root:this.svg.node(),id:this.chartID,color:t})}));if(this.clickStyle&&this.clickStyle.color){this.textStrokes[this.clickStyle.color]=S({root:this.svg.node(),id:this.chartID,color:this.clickStyle.color})}if(this.hoverStyle&&this.hoverStyle.color){this.textStrokes[this.hoverStyle.color]=S({root:this.svg.node(),id:this.chartID,color:this.hoverStyle.color})}}prepareScales(){const t=this.minValueOverride&&this.minValueOverride<this.extent[0]?this.minValueOverride:this.extent[0];const s=this.maxValueOverride||this.extent[1];const i=this.normalized?[0,1]:[t,s];if(this.interpolating){this.interpolating.oldXDomain=this.x.domain();this.interpolating.oldXRange=this.x.range();this.interpolating.oldYDomain=this.y.domain();this.interpolating.oldYRange=this.y.range()}if(this.layout==="vertical"){if(this.interpolating){this.interpolating.padding=this.x.padding();this.interpolating.x=h().domain(this.interpolating.oldXDomain).range(this.interpolating.oldXRange).padding(this.interpolating.padding);this.interpolating.y=r().domain(this.interpolating.oldYDomain).range(this.interpolating.oldYRange)}this.y=r().domain(i).range([this.innerPaddedHeight,0]);this.x=h().domain(this.series.map((t=>t.key))).range([0,this.innerPaddedWidth]).padding(this.barIntervalRatio)}else if(this.layout==="horizontal"){if(this.interpolating){this.interpolating.padding=this.y.padding();this.interpolating.x=r().domain(this.interpolating.oldXDomain).range(this.interpolating.oldXRange);this.interpolating.y=h().domain(this.interpolating.oldYDomain).range(this.interpolating.oldYRange).padding(this.interpolating.padding)}this.x=r().domain(i).range([0,this.innerPaddedWidth]);this.y=h().domain(this.series.map((t=>t.key))).range([0,this.innerPaddedHeight]).padding(this.barIntervalRatio)}}renderRootElements(){this.svg=n(this.stackedBarChartEl).select(".visa-viz-d3-stacked-bar-container").append("svg").attr("width",this.width).attr("height",this.height).attr("viewBox","0 0 "+this.width+" "+this.height);this.root=this.svg.append("g").attr("id","visa-viz-margin-container-g-"+this.chartID);this.rootG=this.root.append("g").attr("id","visa-viz-padding-container-g-"+this.chartID);this.gridG=this.rootG.append("g").attr("class","grid-group");this.barG=this.rootG.append("g").attr("class","stacked-bar-group");this.labelG=this.rootG.append("g").attr("class","stacked-bar-dataLabel-group");this.totalLabels=this.rootG.append("g").attr("class","bar-dataLabel-group");this.legendG=n(this.stackedBarChartEl).select(".stacked-bar-legend").append("svg");this.subTitleG=n(this.stackedBarChartEl).select(".stacked-bar-sub-title");this.tooltipG=n(this.stackedBarChartEl).select(".stacked-bar-tooltip");this.referencesG=this.rootG.append("g").attr("class","stacked-bar-reference-line-group")}setTestingAttributes(){if(this.unitTest){n(this.stackedBarChartEl).select(".visa-viz-d3-stacked-bar-container").attr("data-testid","chart-container");n(this.stackedBarChartEl).select(".stacked-bar-main-title").attr("data-testid","main-title");n(this.stackedBarChartEl).select(".stacked-bar-sub-title").attr("data-testid","sub-title");this.svg.attr("data-testid","root-svg");this.root.attr("data-testid","margin-container");this.rootG.attr("data-testid","padding-container");this.legendG.attr("data-testid","legend-container");this.tooltipG.attr("data-testid","tooltip-container");this.barG.attr("data-testid","stacked-bar-group");this.updateBarWrappers.attr("data-testid","stacked-bar-wrapper").attr("data-id",(t=>`stacked-bar-wrapper-${t.key}`));this.update.attr("data-testid","bar").attr("data-id",(t=>`bar-${t[this.groupAccessor]}-${t[this.ordinalAccessor]}`));this.labelG.attr("data-testid","stacked-bar-dataLabel-group");this.updateLabelWrappers.attr("data-testid","stacked-bar-dataLabel-wrapper").attr("data-id",(t=>`stacked-bar-dataLabel-wrapper-${t.key}`));this.updateLabels.attr("data-testid","dataLabel").attr("data-id",(t=>`dataLabel-${t[this.groupAccessor]}-${t[this.ordinalAccessor]}`));this.totalLabels.attr("data-testid","stacked-bar-totalLabel-group");this.updateTotalLabels.attr("data-testid","totalLabel").attr("data-id",(t=>`totalLabel-${t.key}`));this.referencesG.attr("data-testid","reference-line-group");this.svg.select("defs").attr("data-testid","pattern-defs");this.referencesG.selectAll(".stacked-bar-reference-line").attr("data-testid","reference-line");this.referencesG.selectAll(".stacked-bar-reference-line-label").attr("data-testid","reference-line-label")}else{n(this.stackedBarChartEl).select(".visa-viz-d3-stacked-bar-container").attr("data-testid",null);n(this.stackedBarChartEl).select(".stacked-bar-main-title").attr("data-testid",null);n(this.stackedBarChartEl).select(".stacked-bar-sub-title").attr("data-testid",null);this.svg.attr("data-testid",null);this.root.attr("data-testid",null);this.rootG.attr("data-testid",null);this.legendG.attr("data-testid",null);this.tooltipG.attr("data-testid",null);this.barG.attr("data-testid",null);this.updateBarWrappers.attr("data-testid",null).attr("data-id",null);this.update.attr("data-testid",null).attr("data-id",null);this.labelG.attr("data-testid",null);this.updateLabelWrappers.attr("data-testid",null).attr("data-id",null);this.updateLabels.attr("data-testid",null).attr("data-id",null);this.totalLabels.attr("data-testid",null);this.updateTotalLabels.attr("data-testid",null).attr("data-id",null);this.referencesG.attr("data-testid",null);this.svg.select("defs").attr("data-testid",null);this.referencesG.selectAll(".stacked-bar-reference-line").attr("data-testid",null);this.referencesG.selectAll(".stacked-bar-reference-line-label").attr("data-testid",null)}}reSetRoot(){const t=O({selection:this.svg,duration:this.duration,namespace:"root_reset",easing:d});t.attr("width",this.width).attr("height",this.height).attr("viewBox","0 0 "+this.width+" "+this.height);const s=O({selection:this.root,duration:this.duration,namespace:"root_reset",easing:d});s.attr("transform",`translate(${this.margin.left}, ${this.margin.top})`);const i=O({selection:this.rootG,duration:this.duration,namespace:"root_reset",easing:d});i.attr("transform",`translate(${this.padding.left}, ${this.padding.top})`);tt(this.chartID,this.width)}drawXAxis(){const t=this.layout==="vertical"?this.groupAccessor:this.valueAccessor;const s=this.xAxis.label&&this.xAxis.label!==""?this.xAxis.label:this.dataKeyNames&&this.dataKeyNames[t]?this.dataKeyNames[t]:this.xAxis.label;ot({root:this.rootG,height:this.innerPaddedHeight,width:this.innerPaddedWidth,axisScale:this.x,left:false,wrapLabel:this.wrapLabel&&this.layout==="vertical"?this.x.bandwidth():"",format:this.xAxis.format,dateFormat:this.xAxis.format,tickInterval:this.xAxis.tickInterval,label:s,padding:this.padding,hide:!this.innerXAxis.visible,duration:this.duration})}drawYAxis(){const t=this.layout==="vertical"?this.valueAccessor:this.groupAccessor;const s=this.yAxis.label&&this.yAxis.label!==""?this.yAxis.label:this.dataKeyNames&&this.dataKeyNames[t]?this.dataKeyNames[t]:this.yAxis.label;ot({root:this.rootG,height:this.innerPaddedHeight,width:this.innerPaddedWidth,axisScale:this.y,left:true,wrapLabel:this.wrapLabel?this.padding.left||100:"",format:this.yAxis.format,dateFormat:this.yAxis.format,tickInterval:this.yAxis.tickInterval,label:s,padding:this.padding,hide:!this.innerYAxis.visible,duration:this.duration})}setXAxisAccessibility(){const t=this.layout==="vertical"?this.groupAccessor:this.valueAccessor;const s=this.xAxis.label&&this.xAxis.label!==""?this.xAxis.label:this.dataKeyNames&&this.dataKeyNames[t]?this.dataKeyNames[t]:this.xAxis.label;_({rootEle:this.stackedBarChartEl,hasXAxis:this.innerXAxis?this.innerXAxis.visible:false,xAxis:this.layout==="vertical"?this.x||false:this.y||false,xAxisLabel:s?s:""})}setYAxisAccessibility(){const t=this.layout==="vertical"?this.valueAccessor:this.groupAccessor;const s=this.yAxis.label&&this.yAxis.label!==""?this.yAxis.label:this.dataKeyNames&&this.dataKeyNames[t]?this.dataKeyNames[t]:this.yAxis.label;X({rootEle:this.stackedBarChartEl,hasYAxis:this.innerYAxis?this.innerYAxis.visible:false,yAxis:this.layout==="vertical"?this.y||false:this.x||false,yAxisLabel:s?s:""})}drawBaseline(){if(this.layout==="vertical"){ot({root:this.rootG,height:this.innerPaddedHeight,width:this.innerPaddedWidth,axisScale:this.x,left:false,padding:this.padding,markOffset:this.y(0)||-1,duration:this.duration})}if(this.layout==="horizontal"){ot({root:this.rootG,height:this.innerPaddedHeight,width:this.innerPaddedWidth,axisScale:this.y,left:true,padding:this.padding,markOffset:this.x(0)||-1,duration:this.duration})}}drawXGrid(){ct(this.gridG,this.innerPaddedHeight,this.innerPaddedWidth,this.x,false,!this.innerXAxis.gridVisible,this.xAxis.tickInterval,this.duration)}drawYGrid(){ct(this.gridG,this.innerPaddedHeight,this.innerPaddedWidth,this.y,true,!this.innerYAxis.gridVisible,this.yAxis.tickInterval,this.duration)}setGlobalSelections(){const t=this.barG.selectAll(".stacked-bar-series").data(this.series,(t=>t.key));this.enterBarWrappers=t.enter().append("g");this.exitBarWrappers=t.exit();this.updateBarWrappers=t.merge(this.enterBarWrappers);const s=this.updateBarWrappers.selectAll(".stacked-bar").data((t=>t.values),(t=>t[this.ordinalAccessor]));this.enter=s.enter().append("rect");this.exit=s.exit();this.update=s.merge(this.enter);this.exitSize=this.exit.size();this.enterSize=this.enter.size();const i=this.labelG.selectAll(".stacked-bar-dataLabel-series").data(this.series,(t=>t.key));this.enterLabelWrappers=i.enter().append("g");this.exitLabelWrappers=i.exit();this.updateLabelWrappers=i.merge(this.enterLabelWrappers);const e=this.updateLabelWrappers.selectAll(".stacked-bar-dataLabel").data((t=>t.values),(t=>t[this.ordinalAccessor]));this.enterLabels=e.enter().append("text");this.exitLabels=e.exit();this.updateLabels=e.merge(this.enterLabels);const h=this.totalLabels.selectAll(".bar-dataLabel-group text").data(this.series,(t=>t.key));this.enterTotalLabels=h.enter().append("text");this.exitTotalLabels=h.exit();this.updateTotalLabels=h.merge(this.enterTotalLabels)}enterGeometries(){this.enter.interrupt();const t=this.layout==="vertical"?"x":"y";const s=this.layout==="vertical"?"width":"height";const i=this.layout==="vertical"?"y":"x";const e=this.layout==="vertical"?"height":"width";const h=this.layout==="vertical"?"innerPaddedWidth":"innerPaddedHeight";this.enter.attr("class","stacked-bar").attr("cursor",!this.suppressEvents?this.cursor:null).each(((t,s,i)=>{E(i[s])})).on("click",!this.suppressEvents?(t,s,i)=>this.onClickHandler(t,i[s]):null).on("mouseover",!this.suppressEvents?(t,s,i)=>this.onHoverHandler(t,i[s]):null).on("mouseout",!this.suppressEvents?()=>this.onMouseOutHandler():null).attr("fill",((t,s)=>{const i=this.clickHighlight&&this.clickHighlight.length>0&&at(t,this.clickHighlight,this.innerInteractionKeys);const e=this.hoverHighlight&&rt(t,this.hoverHighlight,this.innerInteractionKeys);const h=this.colorArr[s];return i&&this.clickStyle.color?Lt[this.clickStyle.color]||this.clickStyle.color:i?h:e&&this.hoverStyle.color?Lt[this.hoverStyle.color]||this.hoverStyle.color:h})).attr("opacity",0).attr(i,(t=>{let s=this[i];if(this.interpolating){s=this.interpolating[i]}let e=t.stackEnd;if(t.stackEnd<0){e=t.stackStart}if(typeof t.enteringStackStart==="number"){e=t.enteringStackStart}return s(e/this.modifier(t))})).attr(e,0).attr(t,(s=>{let i=this[t];if(this.interpolating){i=this.interpolating[t]}return i(s[this.groupAccessor])})).attr(s,(()=>{let s=this[t];if(this.interpolating){s=this.interpolating[t]}return s.bandwidth()}));this.enterBarWrappers.attr("class","stacked-bar-series entering").each(((t,s,i)=>{E(i[s])})).selectAll(".stacked-bar").attr(e,(t=>this.layout==="vertical"?this.y(t.stackEnd/this.modifier(t))-this.y(t.stackStart/this.modifier(t)):this.x(t.stackStart/this.modifier(t))-this.x(t.stackEnd/this.modifier(t))));this.enterBarWrappers.selectAll(".stacked-bar").attr(i,(t=>this.layout==="vertical"?this.y(t.stackStart/this.modifier(t)):this.x(t.stackEnd/this.modifier(t)))).attr(t,(s=>{let i=this[t](s[this.groupAccessor])+this[t].bandwidth()/2;i=this[t](s[this.groupAccessor])+this[t].bandwidth()/2*(i/(this[h]/2));return i})).attr(s,0);this.enterBarWrappers.order();this.enter.order()}updateGeometries(){this.update.interrupt();this.update.transition("opacity").duration(((t,s,i)=>{if(n(i[s]).classed("entering")){n(i[s]).classed("entering",false);return this.duration}return 0})).ease(d).attr("opacity",(t=>ht(t,1,this.hoverOpacity,this.hoverHighlight,this.clickHighlight,this.innerInteractionKeys))).call(At,(()=>{this.update.classed("entering",false)}))}exitGeometries(){this.exit.interrupt();const t=this.layout==="vertical"?"x":"y";const s=this.layout==="vertical"?"width":"height";const i=this.layout==="vertical"?"y":"x";const e=this.layout==="vertical"?"height":"width";const h=this.layout==="vertical"?"innerPaddedWidth":"innerPaddedHeight";this.exit.attr("filter",null).transition("exit").duration(this.duration).ease(d).attr(e,0).attr(i,(t=>{let s=t.stackEnd;if(t.stackEnd<0){s=t.stackStart}return this[i](s/this.modifier(t))})).attr(t,(s=>this[t](s[this.groupAccessor])));this.exitBarWrappers.selectAll(".stacked-bar").attr("filter",null).transition("exit").duration(this.duration).ease(d).attr("opacity",0).attr(i,((t,s,e)=>n(e[s]).attr(i))).attr(t,((i,e,a)=>{const r=n(a[e]);let l=+r.attr(t)+ +r.attr(s)/2;l=+r.attr(t)+ +r.attr(s)/2*(l/(this[h]/2));return l})).attr(e,((t,s,i)=>n(i[s]).attr(e))).attr(s,0);this.update.transition("accessibilityAfterExit").duration(this.duration).ease(d).call(At,(()=>{const t=J(this.rootG.node());this.exit.remove();this.exitBarWrappers.remove();this.setChartCountAccessibility();this.setGroupAccessibilityID();this.setGeometryAriaLabels();Z({parentGNode:this.rootG.node(),focusDidExist:t})}))}drawGeometries(){const t=this.layout==="vertical"?"x":"y";const s=this.layout==="vertical"?"width":"height";const i=this.layout==="vertical"?"y":"x";const e=this.layout==="vertical"?"height":"width";this.updateBarWrappers.transition("update").duration(this.duration).ease(d).call(At,(()=>{this.updateBarWrappers.classed("entering",false)}));this.update.classed("geometryIsMoving",((h,a,r)=>{const l=L(n(r[a]),[{attr:t,numeric:true,newValue:this[t](h[this.groupAccessor])},{attr:s,numeric:true,newValue:this[t].bandwidth()},{attr:i,numeric:true,newValue:this.layout==="vertical"?this.y(h.stackStart/this.modifier(h)):this.x(h.stackEnd/this.modifier(h))},{attr:e,numeric:true,newValue:this.layout==="vertical"?this.y(h.stackEnd/this.modifier(h))-this.y(h.stackStart/this.modifier(h)):this.x(h.stackStart/this.modifier(h))-this.x(h.stackEnd/this.modifier(h))}]);return l})).attr(`data-${t}`,(s=>this[t](s[this.groupAccessor]))).attr(`data-${s}`,this[t].bandwidth()).attr(`data-${i}`,(t=>this.layout==="vertical"?this.y(t.stackStart/this.modifier(t)):this.x(t.stackEnd/this.modifier(t)))).attr(`data-${e}`,(t=>this.layout==="vertical"?this.y(t.stackEnd/this.modifier(t))-this.y(t.stackStart/this.modifier(t)):this.x(t.stackStart/this.modifier(t))-this.x(t.stackEnd/this.modifier(t)))).attr("data-translate-x",this.padding.left+this.margin.left).attr("data-translate-y",this.padding.top+this.margin.top).transition("update").duration(this.duration).ease(d).attr(i,(t=>this.layout==="vertical"?this.y(t.stackStart/this.modifier(t)):this.x(t.stackEnd/this.modifier(t)))).attr(e,(t=>this.layout==="vertical"?this.y(t.stackEnd/this.modifier(t))-this.y(t.stackStart/this.modifier(t)):this.x(t.stackStart/this.modifier(t))-this.x(t.stackEnd/this.modifier(t)))).attr(t,(s=>this[t](s[this.groupAccessor]))).attr(s,this[t].bandwidth()).call(At,(()=>{setTimeout((()=>{this.update.classed("geometryIsMoving",false);this.updateInteractionState();this.updateLabels.classed("textIsMoving",false);this.checkLabelColorAgainstBackground()}),0);Z({parentGNode:this.rootG.node()});this.transitionEndEvent.emit({chartID:this.chartID})}))}updateInteractionState(){z(this.svg.node());this.update.interrupt("opacity");this.updateLabels.interrupt("opacity");this.update.attr("opacity",(t=>ht(t,1,this.hoverOpacity,this.hoverHighlight,this.clickHighlight,this.innerInteractionKeys))).attr("fill",((t,s)=>{const i=this.clickHighlight&&this.clickHighlight.length>0&&at(t,this.clickHighlight,this.innerInteractionKeys);const e=this.hoverHighlight&&rt(t,this.hoverHighlight,this.innerInteractionKeys);const h=this.colorArr[s];return i&&this.clickStyle.color?Lt[this.clickStyle.color]||this.clickStyle.color:i?h:e&&this.hoverStyle.color?Lt[this.hoverStyle.color]||this.hoverStyle.color:h})).each(((t,s,i)=>{const e=n(i[s]);if(!this.accessibility.hideStrokes&&!e.classed("geometryIsMoving")){const h=this.clickHighlight&&this.clickHighlight.length>0&&at(t,this.clickHighlight,this.innerInteractionKeys);const a=this.hoverHighlight&&rt(t,this.hoverHighlight,this.innerInteractionKeys);const r=this.preparedColors[s];const l=h?"click":a?"hover":"rest";const o=h&&this.clickStyle.color?Lt[this.clickStyle.color]||this.clickStyle.color:h?r:a&&this.hoverStyle.color?Lt[this.hoverStyle.color]||this.hoverStyle.color:r;if(l==="hover"){T({inputElement:i[s],id:this.chartID,key:t[this.ordinalAccessor]+t[this.groupAccessor],strokeWidth:this.hoverStyle.strokeWidth,fill:o})}const c=this.strokes[l+o];if(c!==e.attr("filter")){if(this.isSafari){e.attr("filter",null);setTimeout((()=>{e.attr("filter",c)}),0)}else{e.attr("filter",c)}}}else{e.attr("filter",null)}}));Z({parentGNode:this.rootG.node()});ut({root:this.legendG,uniqueID:this.chartID,interactionKeys:this.innerInteractionKeys,groupAccessor:this.ordinalAccessor,hoverHighlight:this.hoverHighlight,clickHighlight:this.clickHighlight,hoverStyle:this.hoverStyle,clickStyle:this.clickStyle,hoverOpacity:this.hoverOpacity})}setLabelOpacity(){const t=this.dataLabel.placement==="auto"||this.dataLabel.collisionHideOnly;const s=this.dataLabel.placement!=="auto"&&this.dataLabel.collisionHideOnly;let i=15;this.updateLabels.each(((t,s,e)=>{if(s===0){const t=e[s];const h=getComputedStyle(t);const a=parseFloat(h.fontSize);i=Math.max(a-1,1)}}));this.processLabelOpacity(this.updateLabels,t);this.updateTotalLabels.attr("opacity",this.showTotalValue&&!this.normalized?1:0);if(t){const t=this.updateLabels.filter(((t,s,i)=>n(i[s]).classed("collision-added")));const e=this.updateLabels.filter(((t,s,i)=>n(i[s]).classed("collision-removed"))).attr("data-use-dx",s).attr("data-use-dy",s);const h={vertical:{top:{validPositions:["bottom"],offsets:[5]},middle:{validPositions:["middle"],offsets:[1]},bottom:{validPositions:["top"],offsets:[i/2]}},horizontal:{right:{validPositions:["left"],offsets:[8]},middle:{validPositions:["middle"],offsets:[1]},left:{validPositions:["right"],offsets:[20]}}};const a=this.dataLabel&&this.dataLabel.collisionPlacement;const r=a&&h[this.layout][a]?this.dataLabel.collisionPlacement:this.layout==="vertical"?"top":"right";if(e.size()>0){this.bitmaps=Dt({bitmaps:this.bitmaps,labelSelection:e,avoidMarks:[],validPositions:["middle"],offsets:[1],accessors:["key"],size:[zt(this.width,0),zt(this.height,0)],hideOnly:false,removeOnly:true});e.classed("collision-removed",false)}if(t.size()>0){this.bitmaps=wt({root:t,xScale:this.x,yScale:this.y,ordinalAccessor:this.groupAccessor,valueAccessor:this.valueAccessor,placement:this.dataLabel.placement,layout:this.layout,chartType:"stacked",normalized:this.normalized,avoidCollision:{runOccupancyBitmap:this.dataLabel.visible&&this.dataLabel.placement==="auto",bitmaps:this.bitmaps,labelSelection:t,avoidMarks:[this.update],validPositions:s?["middle"]:h[this.layout][r].validPositions,offsets:s?[1]:h[this.layout][r].offsets,accessors:[this.groupAccessor,this.ordinalAccessor,"key"],size:[zt(this.width,0),zt(this.height,0)],boundsScope:s?undefined:r,hideOnly:this.dataLabel.visible&&this.dataLabel.collisionHideOnly,suppressMarkDraw:true}});t.classed("collision-added",false)}}}processLabelOpacity(t,s){const i=this.dataLabel.visible?1:0;const e=this.layout==="vertical"?"x":"y";const h=this.layout==="vertical"?"width":"height";const a=this.layout==="vertical"?"height":"width";t.attr("opacity",((t,r,l)=>{const o=+n(l[r]).attr("opacity");const c=n(l[r]).style("visibility");const u={};u[h]=this[e].bandwidth();u[a]=this.layout==="vertical"?this.y(t.stackEnd/this.modifier(t))-this.y(t.stackStart/this.modifier(t)):this.x(t.stackStart/this.modifier(t))-this.x(t.stackEnd/this.modifier(t));const d=this.dataLabel.placement==="auto"||this.dataLabel.collisionHideOnly||this.accessibility.showSmallLabels||W({text:pt(t,this.innerLabelAccessor,this.dataLabel.format,this.normalized),dimensions:u,fontSize:14});const f=d?ht(t,i,this.hoverOpacity,this.hoverHighlight,this.clickHighlight,this.innerInteractionKeys)<1?s?Number.EPSILON:0:1:0;if((f===1&&c==="hidden"||o!==f)&&s){if(f===1){n(l[r]).classed("collision-added",true).style("visibility",null)}else{n(l[r]).classed("collision-removed",true)}}return f}))}checkLabelColorAgainstBackground(){this.updateLabels.attr("fill",((t,s,i)=>this.textTreatmentHandler(t,s,i)))}bindInteractivity(){this.update.on("click",!this.suppressEvents?(t,s,i)=>this.onClickHandler(t,i[s]):null).on("mouseover",!this.suppressEvents?(t,s,i)=>this.onHoverHandler(t,i[s]):null).on("mouseout",!this.suppressEvents?()=>this.onMouseOutHandler():null)}setRoundedCorners(){this.update.transition("shared_update").duration(this.duration).ease(d).attr("rx",this.roundedCorner).attr("ry",this.roundedCorner)}setSelectedClass(){this.update.classed("highlight",((t,s,i)=>{let e=ht(t,true,false,"",this.clickHighlight,this.innerInteractionKeys);e=this.clickHighlight&&this.clickHighlight.length?e:false;const h=this.accessibility.elementsAreInterface;Q(i[s],e,h);return e}))}updateCursor(){this.update.attr("cursor",!this.suppressEvents?this.cursor:null);n(this.stackedBarChartEl).selectAll(".legend").style("cursor",!this.suppressEvents&&this.legend.interactive&&this.legend.visible?this.cursor:null)}enterDataLabels(){const t=this.dataLabel.visible?1:0;this.enterLabelWrappers.attr("class","stacked-bar-dataLabel-series entering");this.enterLabels.attr("class","stacked-bar-dataLabel entering").style("pointer-events","none").classed("stacked-bar-dataLabel-"+this.layout,true).attr("opacity",(s=>ht(s,t,this.hoverOpacity,this.hoverHighlight,this.clickHighlight,this.innerInteractionKeys)<1?0:Number.EPSILON)).attr("fill",this.textTreatmentHandler);wt({root:this.enterLabels,xScale:this.x,yScale:this.y,ordinalAccessor:this.groupAccessor,valueAccessor:this.valueAccessor,placement:this.dataLabel.placement,layout:this.layout,chartType:"stacked",normalized:this.normalized})}updateDataLabels(){this.updateLabels.interrupt();this.updateLabelWrappers.transition("update").duration(this.duration).ease(d).call(At,(()=>{this.updateLabelWrappers.classed("entering",false)}));const t=this.updateLabels.transition("opacity").ease(d).duration(((t,s,i)=>{if(n(i[s]).classed("entering")){n(i[s]).classed("entering",false);return this.duration}return 0}));this.processLabelOpacity(t);t.call(At,(()=>{this.updateLabels.classed("entering",false)}))}exitDataLabels(){this.exitLabelWrappers.selectAll("text").attr("filter",null).transition("exit").ease(d).duration(this.duration/2).attr("opacity",0).call(At,(()=>{this.exitLabelWrappers.remove()}));this.exitLabels.attr("filter",null).transition("exit").ease(d).duration(this.duration/2).attr("opacity",0).remove()}drawDataLabels(){let t=15;const s=this.dataLabel.placement!=="auto"&&this.dataLabel.collisionHideOnly;this.updateLabels.classed("stacked-bar-dataLabel-horizontal",false).classed("stacked-bar-dataLabel-vertical",false).classed("stacked-bar-dataLabel-"+this.layout,true).text(((s,i,e)=>{if(s[this.valueAccessor]===0&&!this.showZeroLabels){return""}if(i===0){const s=e[i];const h=getComputedStyle(s);const a=parseFloat(h.fontSize);t=Math.max(a-1,1)}return pt(s,this.innerLabelAccessor,this.dataLabel.format,this.normalized)})).style("visibility",((t,s,i)=>this.dataLabel.placement==="auto"||this.dataLabel.collisionHideOnly?n(i[s]).style("visibility"):null));this.updateLabelWrappers.transition("update").duration(this.duration).ease(d).call(At,(()=>{this.updateLabelWrappers.classed("entering",false)}));const i=this.layout==="vertical"?"x":"y";const e=this.layout==="vertical"?"y":"x";const h=this.layout==="vertical"?"stackStart":"stackEnd";const a=this.updateLabels.classed("textIsMoving",(t=>{if(!this.interpolating){return false}const s=this.interpolating[i](t[this.groupAccessor])!==this[i](t[this.groupAccessor])||this.interpolating[e](t[h]/this.modifier(t))!==this[e](t[h]/this.modifier(t));return s})).attr("data-translate-x",this.padding.left+this.margin.left).attr("data-translate-y",this.padding.top+this.margin.top).transition("update").ease(d).duration(this.duration);const r={vertical:{top:{validPositions:["bottom"],offsets:[5]},middle:{validPositions:["middle"],offsets:[1]},bottom:{validPositions:["top"],offsets:[t/2]}},horizontal:{right:{validPositions:["left"],offsets:[8]},middle:{validPositions:["middle"],offsets:[1]},left:{validPositions:["right"],offsets:[20]}}};const l=this.dataLabel&&this.dataLabel.collisionPlacement;const o=l&&r[this.layout][l]?this.dataLabel.collisionPlacement:this.layout==="vertical"?"top":"right";this.bitmaps=wt({root:a,xScale:this.x,yScale:this.y,ordinalAccessor:this.groupAccessor,valueAccessor:this.valueAccessor,placement:this.dataLabel.placement,layout:this.layout,chartType:"stacked",normalized:this.normalized,avoidCollision:{runOccupancyBitmap:this.dataLabel.visible&&this.dataLabel.placement==="auto",labelSelection:a,avoidMarks:[this.update],validPositions:s?["middle"]:r[this.layout][o].validPositions,offsets:s?[1]:r[this.layout][o].offsets,accessors:[this.groupAccessor,this.ordinalAccessor,"key"],size:[zt(this.width,0),zt(this.height,0)],boundsScope:s?undefined:o,hideOnly:this.dataLabel.visible&&this.dataLabel.collisionHideOnly}})}enterTotalDataLabels(){const t=this.layout==="vertical"?"x":"y";const s=this.layout==="vertical"?"y":"x";this.enterTotalLabels.attr("class","bar-dataLabel-"+this.layout).attr("opacity",Number.EPSILON).attr("fill",Lt.dark_text).attr(t,(s=>this[t](s.key)+this[t].bandwidth()/2)).attr(s,(t=>this[s](t.sumAboveZero)+4))}updateTotalDataLabels(){const t=this.showTotalValue&&!this.normalized?1:0;this.updateTotalLabels.transition("total_opacity").ease(d).duration(this.duration).attr("opacity",t)}exitTotalDataLabels(){this.exitTotalLabels.transition("exit").ease(d).duration(this.duration/2).attr("opacity",0).remove()}drawTotalDataLabels(){const t=this.layout==="vertical"?"x":"y";const s=this.layout==="vertical"?"y":"x";const i=this.showTotalValue&&!this.normalized?1:0;this.updateTotalLabels.text((t=>ft(t.sum,this.dataLabel.format))).attr("text-anchor",this.layout==="vertical"?"middle":"start");const e=this.updateTotalLabels.classed("bar-dataLabel-horizontal",false).classed("bar-dataLabel-vertical",false).classed("bar-dataLabel-"+this.layout,true).attr(`data-${t}`,(s=>this[t](s.key)+this[t].bandwidth()/2)).attr(`data-${s}`,(t=>this[s](t.sumAboveZero))).attr("data-use-dx",true).attr("data-use-dy",true).attr("data-translate-x",this.padding.left+this.margin.left).attr("data-translate-y",this.padding.top+this.margin.top).attr("dx",this.layout==="vertical"?"0":"0.3em").attr("dy",this.layout==="vertical"?"-0.3em":".3em").style("visibility",((t,s,i)=>this.dataLabel.placement==="auto"||this.dataLabel.collisionHideOnly?n(i[s]).style("visibility"):null)).transition("update").ease(d).duration(this.duration).attr("opacity",i);if(this.showTotalValue&&(this.dataLabel.placement==="auto"||this.dataLabel.collisionHideOnly)){this.bitmaps=Dt({bitmaps:this.bitmaps,labelSelection:e,avoidMarks:[this.update],validPositions:["middle"],offsets:[1],accessors:[this.ordinalAccessor],size:[zt(this.width,0),zt(this.height,0)],hideOnly:true});e.attr(t,(s=>this[t](s.key)+this[t].bandwidth()/2)).attr(s,(t=>this[s](t.sumAboveZero)))}else{e.attr(t,(s=>this[t](s.key)+this[t].bandwidth()/2)).attr(s,(t=>this[s](t.sumAboveZero)))}}drawReferenceLines(){It({groupName:"stack",root:this.referencesG,referenceLines:this.referenceLines,referenceStyle:this.referenceStyle,innerPaddedWidth:this.innerPaddedWidth,innerPaddedHeight:this.innerPaddedHeight,duration:this.duration,layout:this.layout,x:this.x,y:this.y,unitTest:this.unitTest})}drawAnnotations(){let t=this.layout!=="horizontal"?this.x:this.y;const s=this.layout!=="horizontal"?this.y:this.x;if(this.data[0][this.groupAccessor]instanceof Date){const s=f(this.data,(t=>t[this.groupAccessor]));const i=b(this.data,(t=>t[this.groupAccessor]));const e=this.layout!=="horizontal"?[0,this.innerPaddedWidth]:[this.innerPaddedHeight,0];t=l().domain([i,s]).range(e)}it({source:this.rootG.node(),data:this.annotations,xScale:this.layout!=="horizontal"?t:s,xAccessor:this.layout!=="horizontal"?this.groupAccessor:this.valueAccessor,yScale:this.layout!=="horizontal"?s:t,yAccessor:this.layout!=="horizontal"?this.valueAccessor:this.groupAccessor,width:this.width,height:this.height,padding:this.padding,margin:this.margin,bitmaps:this.bitmaps})}setAnnotationAccessibility(){U(this.getLanguageString(),this.stackedBarChartEl,this.annotations,this.referenceLines)}drawLegendElements(){nt({root:this.legendG,uniqueID:this.chartID,width:this.innerPaddedWidth,height:this.margin.top+20,colorArr:this.colorArr,baseColorArr:this.preparedColors,hideStrokes:this.accessibility.hideStrokes,margin:this.margin,padding:this.padding,duration:this.duration,type:"bar",fontSize:16,data:this.legendData,labelKey:this.ordinalAccessor,label:this.legend.labels,hide:!this.legend.visible,interactionKeys:this.innerInteractionKeys,groupAccessor:this.ordinalAccessor,hoverHighlight:this.hoverHighlight,clickHighlight:this.clickHighlight,hoverStyle:this.hoverStyle,clickStyle:this.clickStyle,hoverOpacity:this.hoverOpacity})}bindLegendInteractivity(){n(this.stackedBarChartEl).selectAll(".legend").style("cursor",!this.suppressEvents&&this.legend.interactive&&this.legend.visible?this.cursor:null).on("click",!this.suppressEvents&&this.legend.interactive&&this.legend.visible?(t,s,i)=>this.onClickHandler(t,i[s]):null).on("mouseover",!this.suppressEvents&&this.legend.interactive&&this.legend.visible?(t,s,i)=>{this.hoverEvent.emit({data:t,target:i[s]})}:null).on("mouseout",!this.suppressEvents&&this.legend.interactive&&this.legend.visible?()=>this.onMouseOutHandler():null)}setTagLevels(){this.topLevel=I(this.highestHeadingLevel);this.bottomLevel=I(this.highestHeadingLevel,3)}setChartDescriptionWrapper(){P({language:this.getLanguageString(),rootEle:this.stackedBarChartEl,title:this.accessibility.title||this.mainTitle,chartTag:"stacked-bar-chart",uniqueID:this.chartID,highestHeadingLevel:this.highestHeadingLevel,redraw:this.shouldRedrawWrapper,disableKeyNav:this.suppressEvents&&this.accessibility.elementsAreInterface===false&&this.accessibility.keyboardNavConfig&&this.accessibility.keyboardNavConfig.disabled,hideDataTable:this.accessibility.hideDataTableButton});this.shouldRedrawWrapper=false}setParentSVGAccessibility(){$({chartTag:"stacked-bar-chart",language:this.getLanguageString(),node:this.svg.node(),title:this.accessibility.title||this.mainTitle,description:this.subTitle,uniqueID:this.chartID,geomType:"bar",includeKeyNames:this.accessibility.includeDataKeyNames,dataKeys:Wt(this,et,"stacked-bar-chart"),dataKeyNames:this.dataKeyNames,groupAccessor:this.groupAccessor,groupName:"stack",groupKeys:this.showTotalValue?["sumMessage"]:false,disableKeyNav:this.suppressEvents&&this.accessibility.elementsAreInterface===false&&this.accessibility.keyboardNavConfig&&this.accessibility.keyboardNavConfig.disabled,normalized:this.normalized,valueAccessor:this.valueAccessor})}setGeometryAccessibilityAttributes(){this.update.each(((t,s,i)=>{E(i[s])}))}setGeometryAriaLabels(){const t=Wt(this,et,"stacked-bar-chart");this.update.each(((s,i,e)=>{N({chartTag:"stacked-bar-chart",language:this.getLanguageString(),node:e[i],geomType:"bar",includeKeyNames:this.accessibility.includeDataKeyNames,dataKeys:t,dataKeyNames:this.dataKeyNames,groupKeys:this.showTotalValue?["sumMessage"]:false,groupName:"stack",uniqueID:this.chartID,disableKeyNav:this.suppressEvents&&this.accessibility.elementsAreInterface===false&&this.accessibility.keyboardNavConfig&&this.accessibility.keyboardNavConfig.disabled,normalized:this.normalized,valueAccessor:this.valueAccessor});j({node:e[i],uniqueID:this.chartID})}))}setGroupAccessibilityID(){this.updateBarWrappers.each(((t,s,i)=>{j({node:i[s],uniqueID:this.chartID})}))}setChartAccessibilityTitle(){K(this.getLanguageString(),this.stackedBarChartEl,this.accessibility.title||this.mainTitle)}setChartAccessibilitySubtitle(){G(this.getLanguageString(),this.stackedBarChartEl,this.subTitle)}setChartAccessibilityLongDescription(){V(this.getLanguageString(),this.stackedBarChartEl,this.accessibility.longDescription)}setChartAccessibilityExecutiveSummary(){M(this.getLanguageString(),this.stackedBarChartEl,this.accessibility.executiveSummary)}setChartAccessibilityPurpose(){q(this.getLanguageString(),this.stackedBarChartEl,this.accessibility.purpose)}setChartAccessibilityContext(){R(this.getLanguageString(),this.stackedBarChartEl,this.accessibility.contextExplanation)}setChartAccessibilityStatisticalNotes(){B(this.getLanguageString(),this.stackedBarChartEl,this.accessibility.statisticalNotes)}setChartCountAccessibility(){F({rootEle:this.stackedBarChartEl,parentGNode:this.barG.node(),chartTag:"stacked-bar-chart",geomType:"bars",groupName:"stacks"})}setChartAccessibilityStructureNotes(){Y(this.getLanguageString(),this.stackedBarChartEl,this.accessibility.structureNotes)}onChangeHandler(){if(this.accessibility&&typeof this.accessibility.onChangeFunc==="function"){const t={updated:this.updated,added:this.enterSize,removed:this.exitSize};this.accessibility.onChangeFunc(t)}this.updated=false;this.enterSize=0;this.exitSize=0}onClickHandler(t,s){this.clickEvent.emit({data:t,target:s})}onHoverHandler(t,s){xt(this.chartID,true);this.hoverEvent.emit({data:t,target:s});if(this.showTooltip&&t){this.eventsTooltip({data:t,evt:u,isToShow:true})}}onMouseOutHandler(){xt(this.chartID,false);this.mouseOutEvent.emit();if(this.showTooltip){this.eventsTooltip({isToShow:false})}}setTooltipInitialStyle(){kt(this.tooltipG)}eventsTooltip({data:t,evt:s,isToShow:i}){dt({root:this.tooltipG,data:t,event:s,isToShow:i,tooltipLabel:this.tooltipLabel,dataKeyNames:this.dataKeyNames,xAxis:this.xAxis,yAxis:this.yAxis,dataLabel:this.dataLabel,layout:this.layout,ordinalAccessor:this.groupAccessor,groupAccessor:this.ordinalAccessor,valueAccessor:this.valueAccessor,normalized:this.normalized,chartType:"stacked"})}render(){this.drawStartEvent.emit({chartID:this.chartID});const t="light";this.init();if(this.shouldSetLocalizationConfig){this.setLocalizationConfig();this.shouldSetLocalizationConfig=false}if(this.shouldSetTagLevels){this.setTagLevels();this.shouldSetTagLevels=false}if(this.shouldCheckValueAxis){if(this.layout==="horizontal"){this.shouldUpdateXAxis=true;this.shouldSetXAxisAccessibility=true;this.shouldUpdateXGrid=true}else if(this.layout==="vertical"){this.shouldUpdateYAxis=true;this.shouldSetYAxisAccessibility=true;this.shouldUpdateYGrid=true}this.shouldCheckValueAxis=false}if(this.shouldCheckLabelAxis){if(this.layout==="vertical"){this.shouldUpdateXAxis=true;this.shouldSetXAxisAccessibility=true}else if(this.layout==="horizontal"){this.shouldUpdateYAxis=true;this.shouldSetYAxisAccessibility=true}this.shouldCheckLabelAxis=false}if(this.shouldUpdateData){this.prepareData();this.shouldUpdateData=false}if(this.shouldUpdateLegendData){this.prepareLegendData();this.shouldUpdateLegendData=false}if(this.shouldSetDimensions){this.setDimensions();this.shouldSetDimensions=false}if(this.shouldUpdateScales){this.prepareScales();this.shouldUpdateScales=false}if(this.shouldValidateClickHighlight){this.validateClickHighlight();this.shouldValidateClickHighlight=false}if(this.shouldValidateInteractionKeys){this.validateInteractionKeys();this.shouldValidateInteractionKeys=false}if(this.shouldValidateDataLabelAccessor){this.validateDataLabelAccessor();this.shouldValidateDataLabelAccessor=false}if(this.shouldValidateAxes){this.validateAxes();this.shouldValidateAxes=false}if(this.shouldUpdateTableData){this.setTableData();this.shouldUpdateTableData=false}if(this.shouldValidate){this.shouldValidateAccessibilityProps();this.shouldValidateLocalizationProps();this.shouldValidate=false}if(this.shouldSetColors){this.setColors();this.shouldSetColors=false}if(this.shouldValidateLabelPlacement){this.validateLabelPlacement();this.shouldValidateLabelPlacement=false}return i("div",{key:"a6c9e18dda01fab95dcb31bd89469c95abf5063d",class:`o-layout is--${this.layout} ${t}`},i("div",{key:"aca5e0ef8d0888c17ebfc55a7f6ef826ba79a276",class:"o-layout--chart"},i(this.topLevel,{key:"6f99839f6339b71623adfae6c0e0551b01061a2b",class:"stacked-bar-main-title vcl-main-title"},this.mainTitle),i(this.bottomLevel,{key:"7c38861200dab80e54bd6f86a4aed2e15c199b2e",class:"visa-ui-text--instructions stacked-bar-sub-title vcl-sub-title"}),i("div",{key:"4c8fa849d08775ffa94164ec957b4aa7531f674c",class:"stacked-bar-legend vcl-legend",style:{display:this.legend.visible?"block":"none"}}),i("keyboard-instructions",{key:"0f605639db151c98e894fb5481224869d10d4579",uniqueID:this.chartID,geomType:"bar",groupName:"stack",language:this.getLanguageString(),chartTag:"stacked-bar-chart",width:this.width-(this.margin?this.margin.right||0:0),isInteractive:this.accessibility.elementsAreInterface,hasCousinNavigation:true,disabled:this.suppressEvents&&this.accessibility.elementsAreInterface===false&&this.accessibility.keyboardNavConfig&&this.accessibility.keyboardNavConfig.disabled}),i("div",{key:"b0ed2312c4396444efc7be5d7d2cd1d1943b5b6b",class:"visa-viz-d3-stacked-bar-container"}),i("div",{key:"ef8709a12e7201b9b455405fd1f0bd09cd89f130",class:"stacked-bar-tooltip vcl-tooltip",style:{display:this.showTooltip?"block":"none"}}),i("data-table",{key:"c8790a7fbc4d947db45bdd782c827cd509edd868",uniqueID:this.chartID,isCompact:true,language:this.getLanguageString(),tableColumns:this.tableColumns,dataKeyNames:this.dataKeyNames,data:this.tableData,padding:this.padding,margin:this.margin,hideDataTable:this.accessibility.hideDataTableButton,unitTest:this.unitTest})))}init(){const t=Object.keys(v);let s=0;const i={mainTitle:{exception:""},subTitle:{exception:""},showTooltip:{exception:false},wrapLabel:{exception:false},showTotalValue:{exception:false},barIntervalRatio:{exception:0},hoverOpacity:{exception:0}};for(s=0;s<t.length;s++){const e=!i[t[s]]?false:this[t[s]]===i[t[s]].exception;this[t[s]]=this[t[s]]||e?this[t[s]]:v[t[s]]}}get stackedBarChartEl(){return e(this)}static get watchers(){return{data:["dataWatcher"],uniqueID:["idWatcher"],highestHeadingLevel:["headingWatcher"],mainTitle:["titleWatcher"],subTitle:["subtitleWatcher"],height:["dimensionWatcher"],width:["dimensionWatcher"],padding:["dimensionWatcher"],margin:["dimensionWatcher"],layout:["layoutWatcher"],ordinalAccessor:["ordinalAccessorWatcher"],valueAccessor:["valueAccessorWatcher"],groupAccessor:["groupAccessorWatcher"],sortOrder:["sortWatcher"],xAxis:["xAxisWatcher"],yAxis:["yAxisWatcher"],wrapLabel:["wrapLabelWatcher"],normalized:["normalizedWatcher"],colorPalette:["paletteWatcher"],colors:["colorsWatcher"],hoverStyle:["hoverStyleWatcher"],clickStyle:["clickStyleWatcher"],referenceLines:["referenceWatcher"],referenceStyle:["referenceWatcher"],cursor:["cursorWatcher"],roundedCorner:["cornerWatcher"],barIntervalRatio:["intervalRatioWatcher"],hoverOpacity:["hoverOpacityWatcher"],dataLabel:["labelWatcher"],showTotalValue:["showTotalValueWatcher"],showTooltip:["showTooltipWatcher"],tooltipLabel:["tooltipLabelWatcher"],localization:["localizationWatcher"],accessibility:["accessibilityWatcher"],showZeroLabels:["showZeroLabelsWatcher"],legend:["legendWatcher"],annotations:["annotationsWatcher"],maxValueOverride:["valueOverrideWatcher"],minValueOverride:["valueOverrideWatcher"],interactionKeys:["interactionWatcher"],dataKeyNames:["dataKeyNamesWatcher"],hoverHighlight:["hoverWatcher"],clickHighlight:["clickWatcher"],suppressEvents:["suppressWatcher"],unitTest:["unitTestWatcher"]}}};window["VisaChartsLibOSSLicenses"]=mt();Ot.style=y;export{Ot as stacked_bar_chart};
//# sourceMappingURL=p-aa456f9b.entry.js.map