/*
 * Decompiled with CFR 0.152.
 */
package roemetz.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileNameExtensionFilter;
import mrmc.chart.exportToFile;
import mrmc.core.DBRecord;
import mrmc.core.InputFile;
import mrmc.core.Matrix;
import mrmc.gui.SizePanel;
import mrmc.gui.StatPanel;
import roemetz.core.CalcGenRoeMetz;
import roemetz.core.RoeMetz;
import roemetz.core.SimRoeMetz;
import roemetz.core.validateFunction;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.rng.WELL1024;

public class RMGUInterface {
    private final int USE_MLE = 1;
    private final int NO_MLE = 0;
    private static RoeMetz RoeMetz1;
    public DBRecord varDBRecordStat;
    private File inputDirectory = null;
    private File outputDirectory = null;
    private String inputFileName = "";
    public SizePanel SizePanelRoeMetz;
    public boolean processDone = false;
    public DBRecord avgDBRecordStat;
    public StatPanel StatPanel1;
    public StatPanel StatPanelNumerical;
    public static int RandomStreamID;
    private double[][] trialResultArray;
    private double[][][] SizingResultArray;
    private double[][] SizingResultMean;
    JPanel studyDesignJPanel;
    public static JTextField mu0;
    public static JTextField mu1;
    public static JTextField v_R0;
    public static JTextField v_C0;
    public static JTextField v_RC0;
    public static JTextField v_R1;
    public static JTextField v_C1;
    public static JTextField v_RC1;
    public static JTextField v_AR0;
    public static JTextField v_AC0;
    public static JTextField v_ARC0;
    public static JTextField v_AR1;
    public static JTextField v_AC1;
    public static JTextField v_ARC1;
    public static JTextField v_BR0;
    public static JTextField v_BC0;
    public static JTextField v_BRC0;
    public static JTextField v_BR1;
    public static JTextField v_BC1;
    public static JTextField v_BRC1;
    public static JTextField NnormalJTextField;
    public static JTextField NdiseaseJTextField;
    public static JTextField NreaderJTextField;
    public static JTextField JTextField_Nexp;
    public static JTextField JTextField_seed;
    private JDialog progDialog;
    private JCheckBox useMLEbox = new JCheckBox("Use MLE?");
    private int useMLE = 0;
    private String simSaveDirectory;
    private static JProgressBar simProgress;
    public String calcSaveDirectory;
    public DecimalFormat threeDecOpt = new DecimalFormat("0.###");
    public DecimalFormat threeDecOptE = new DecimalFormat("0.###E0");
    public DecimalFormat threeDec = new DecimalFormat("0.000");
    public DecimalFormat threeDecE = new DecimalFormat("0.000E0");
    public DecimalFormat fourDecE = new DecimalFormat("0.0000E0");
    public DecimalFormat fiveDecOpt = new DecimalFormat("0.#####");
    public DecimalFormat fiveDecOptE = new DecimalFormat("0.#####E0");
    public DecimalFormat fiveDec = new DecimalFormat("0.00000");
    public DecimalFormat fiveDecE = new DecimalFormat("0.00000E0");

    static {
        RandomStreamID = 1;
        mu0 = new JTextField("1.0", 6);
        mu1 = new JTextField("1.0", 6);
        v_R0 = new JTextField("0.166", 6);
        v_C0 = new JTextField("0.166", 6);
        v_RC0 = new JTextField("0.166", 6);
        v_R1 = new JTextField("0.166", 6);
        v_C1 = new JTextField("0.166", 6);
        v_RC1 = new JTextField("0.166", 6);
        v_AR0 = new JTextField("0.166", 6);
        v_AC0 = new JTextField("0.166", 6);
        v_ARC0 = new JTextField("0.166", 6);
        v_AR1 = new JTextField("0.166", 6);
        v_AC1 = new JTextField("0.166", 6);
        v_ARC1 = new JTextField("0.166", 6);
        v_BR0 = new JTextField("0.166", 6);
        v_BC0 = new JTextField("0.166", 6);
        v_BRC0 = new JTextField("0.166", 6);
        v_BR1 = new JTextField("0.166", 6);
        v_BC1 = new JTextField("0.166", 6);
        v_BRC1 = new JTextField("0.166", 6);
        NnormalJTextField = new JTextField("20", 6);
        NdiseaseJTextField = new JTextField("20", 6);
        NreaderJTextField = new JTextField("4", 6);
        JTextField_Nexp = new JTextField("10", 7);
    }

    public double[] getMeans() {
        return new double[]{Double.valueOf(mu0.getText()), Double.valueOf(mu1.getText())};
    }

    public double[] getVariances() {
        return new double[]{Double.valueOf(v_AR0.getText()), Double.valueOf(v_AC0.getText()), Double.valueOf(v_ARC0.getText()), Double.valueOf(v_AR1.getText()), Double.valueOf(v_AC1.getText()), Double.valueOf(v_ARC1.getText()), Double.valueOf(v_BR0.getText()), Double.valueOf(v_BC0.getText()), Double.valueOf(v_BRC0.getText()), Double.valueOf(v_BR1.getText()), Double.valueOf(v_BC1.getText()), Double.valueOf(v_BRC1.getText()), Double.valueOf(v_R0.getText()), Double.valueOf(v_C0.getText()), Double.valueOf(v_RC0.getText()), Double.valueOf(v_R1.getText()), Double.valueOf(v_C1.getText()), Double.valueOf(v_RC1.getText())};
    }

    public RMGUInterface(RoeMetz tempRoeMetz, Container cp) {
        RoeMetz1 = tempRoeMetz;
        cp.setLayout(new BoxLayout(cp, 1));
        JPanel cofvInputPanel = new JPanel();
        cofvInputPanel.setLayout(new BoxLayout(cofvInputPanel, 1));
        JPanel meansJPanel = new JPanel(new FlowLayout(0));
        meansJPanel.add(new JLabel("Input Means: "));
        JPanel meansFields = new JPanel(new FlowLayout(0));
        meansFields.add(Box.createHorizontalStrut(20));
        meansFields.add(new JLabel("\u00b5_A: "));
        meansFields.add(mu0);
        meansFields.add(new JLabel("\u00b5_B: "));
        meansFields.add(mu1);
        JPanel varJPanel0 = new JPanel(new FlowLayout(0));
        varJPanel0.add(new JLabel("Input Variances Invariant to Modality: "));
        JPanel varFieldsO = new JPanel(new FlowLayout(0));
        varFieldsO.add(Box.createHorizontalStrut(20));
        varFieldsO.add(new JLabel("  v_R0: "));
        varFieldsO.add(v_R0);
        varFieldsO.add(new JLabel("  v_C0: "));
        varFieldsO.add(v_C0);
        varFieldsO.add(new JLabel("  v_RC0: "));
        varFieldsO.add(v_RC0);
        varFieldsO.add(new JLabel("  v_R1: "));
        varFieldsO.add(v_R1);
        varFieldsO.add(new JLabel("  v_C1: "));
        varFieldsO.add(v_C1);
        varFieldsO.add(new JLabel("  v_RC1: "));
        varFieldsO.add(v_RC1);
        JPanel varJPanelA = new JPanel(new FlowLayout(0));
        varJPanelA.add(new JLabel("Input Variances Specific to Modality A: "));
        JPanel varFieldsA = new JPanel(new FlowLayout(0));
        varFieldsA.add(Box.createHorizontalStrut(20));
        varFieldsA.add(new JLabel("v_AR0: "));
        varFieldsA.add(v_AR0);
        varFieldsA.add(new JLabel("v_AC0: "));
        varFieldsA.add(v_AC0);
        varFieldsA.add(new JLabel("v_ARC0: "));
        varFieldsA.add(v_ARC0);
        varFieldsA.add(new JLabel("v_AR1: "));
        varFieldsA.add(v_AR1);
        varFieldsA.add(new JLabel("v_AC1: "));
        varFieldsA.add(v_AC1);
        varFieldsA.add(new JLabel("v_ARC1: "));
        varFieldsA.add(v_ARC1);
        JPanel varJPanelB = new JPanel(new FlowLayout(0));
        varJPanelB.add(new JLabel("Input Variances Specific to Modality B: "));
        JPanel varFieldsB = new JPanel(new FlowLayout(0));
        varFieldsB.add(Box.createHorizontalStrut(20));
        varFieldsB.add(new JLabel("v_BR0: "));
        varFieldsB.add(v_BR0);
        varFieldsB.add(new JLabel("v_BC0: "));
        varFieldsB.add(v_BC0);
        varFieldsB.add(new JLabel("v_BRC0: "));
        varFieldsB.add(v_BRC0);
        varFieldsB.add(new JLabel("v_BR1: "));
        varFieldsB.add(v_BR1);
        varFieldsB.add(new JLabel("v_BC1: "));
        varFieldsB.add(v_BC1);
        varFieldsB.add(new JLabel("v_BRC1: "));
        varFieldsB.add(v_BRC1);
        JPanel sizeJPanel = new JPanel(new FlowLayout(0));
        sizeJPanel.add(new JLabel("Input Experiment Size: "));
        JPanel sizeFields = new JPanel(new FlowLayout(0));
        sizeFields.add(Box.createHorizontalStrut(20));
        sizeFields.add(new JLabel("N0: "));
        sizeFields.add(NnormalJTextField);
        sizeFields.add(new JLabel("N1: "));
        sizeFields.add(NdiseaseJTextField);
        sizeFields.add(new JLabel("Nr: "));
        sizeFields.add(NreaderJTextField);
        this.SizePanelRoeMetz = new SizePanel();
        this.studyDesignJPanel = this.SizePanelRoeMetz.setStudyDesign();
        JPanel populateFields = new JPanel(new FlowLayout(0));
        JButton clearButton = new JButton("Clear Fields");
        clearButton.addActionListener(new ClearBtnListener());
        JButton popFromFile = new JButton("Populate Components from File");
        popFromFile.addActionListener(new PopFromFileListener());
        JButton saveFields = new JButton("Save Components to File");
        saveFields.addActionListener(new SaveFieldsListener());
        populateFields.add(Box.createHorizontalStrut(20));
        populateFields.add(clearButton);
        populateFields.add(popFromFile);
        populateFields.add(saveFields);
        cofvInputPanel.add(meansJPanel);
        cofvInputPanel.add(meansFields);
        cofvInputPanel.add(varJPanel0);
        cofvInputPanel.add(varFieldsO);
        cofvInputPanel.add(varJPanelA);
        cofvInputPanel.add(varFieldsA);
        cofvInputPanel.add(varJPanelB);
        cofvInputPanel.add(varFieldsB);
        cofvInputPanel.add(sizeJPanel);
        cofvInputPanel.add(sizeFields);
        cofvInputPanel.add(this.studyDesignJPanel);
        cofvInputPanel.add(populateFields);
        JPanel simExpPanel = new JPanel();
        simExpPanel.setLayout(new BoxLayout(simExpPanel, 1));
        JPanel simExpDesc = new JPanel(new FlowLayout(0));
        simExpDesc.add(new JLabel("Simulation Experiments:"));
        JPanel simExp = new JPanel(new FlowLayout(0));
        simExp.add(Box.createHorizontalStrut(20));
        JLabel seedLabel = new JLabel("Seed for RNG");
        simExp.add(seedLabel);
        JTextField_seed = new JTextField(10);
        JTextField_seed.addFocusListener(new SeedInputListener());
        simExp.add(JTextField_seed);
        String String_seed = Long.toString(System.currentTimeMillis());
        if (String_seed.length() > 9) {
            String_seed = String_seed.substring(String_seed.length() - 9, String_seed.length());
        }
        JTextField_seed.setText(String_seed);
        JLabel NexpLabel = new JLabel("# of MC Trials");
        simExp.add(NexpLabel);
        simExp.add(JTextField_Nexp);
        this.useMLEbox.addItemListener(new UseMLEListener());
        simExp.add(this.useMLEbox);
        JPanel simExpButtons = new JPanel(new FlowLayout(0));
        simExpButtons.add(Box.createHorizontalStrut(20));
        JButton saveLoc = new JButton("Output Raw Data");
        saveLoc.addActionListener(new SaveSimulationListener());
        simExpButtons.add(saveLoc);
        JButton doSimExp = new JButton("Perform Simulation Experiments");
        doSimExp.addActionListener(new DoSimBtnListener());
        simExpButtons.add(doSimExp);
        simExpPanel.add(simExpDesc);
        simExpPanel.add(simExp);
        simExpPanel.add(simExpButtons);
        JPanel calculatePanel = new JPanel();
        calculatePanel.setLayout(new BoxLayout(calculatePanel, 1));
        JPanel cofvResultsDesc = new JPanel(new FlowLayout(0));
        JLabel cofvLabel = new JLabel("Calculate Components of Variance by Numerical Integration:");
        cofvResultsDesc.add(cofvLabel);
        JPanel cofvResults = new JPanel(new FlowLayout(0));
        JButton doGenRoeMetz = new JButton("Do Numerical Integration");
        doGenRoeMetz.addActionListener(new DoNumericalIntegrationBtnListener());
        cofvResults.add(Box.createHorizontalStrut(20));
        cofvResults.add(doGenRoeMetz);
        calculatePanel.add(cofvResultsDesc);
        calculatePanel.add(cofvResults);
        cp.add(cofvInputPanel);
        cp.add(new JSeparator());
        cp.add(simExpPanel);
        cp.add(new JSeparator());
        cp.add(calculatePanel);
    }

    private void clearInputs() {
        v_AR0.setText("");
        v_AC0.setText("");
        v_ARC0.setText("");
        v_AR1.setText("");
        v_AC1.setText("");
        v_ARC1.setText("");
        v_BR0.setText("");
        v_BC0.setText("");
        v_BRC0.setText("");
        v_BR1.setText("");
        v_BC1.setText("");
        v_BRC1.setText("");
        v_R0.setText("");
        v_C0.setText("");
        v_RC0.setText("");
        v_R1.setText("");
        v_C1.setText("");
        v_RC1.setText("");
        mu0.setText("");
        mu1.setText("");
        NnormalJTextField.setText("");
        NdiseaseJTextField.setText("");
        NreaderJTextField.setText("");
        this.SizePanelRoeMetz.NumSplitPlotsJTextField.setText("1");
        this.SizePanelRoeMetz.numSplitPlots = 1;
        this.SizePanelRoeMetz.ButtonPairedReadersYes.setSelected(true);
        this.SizePanelRoeMetz.ButtonPairedReadersNo.setSelected(false);
        this.SizePanelRoeMetz.pairedReadersFlag = 1;
        this.SizePanelRoeMetz.ButtonPairedNormalsYes.setSelected(true);
        this.SizePanelRoeMetz.ButtonPairedNormalsNo.setSelected(false);
        this.SizePanelRoeMetz.pairedNormalsFlag = 1;
        this.SizePanelRoeMetz.ButtonPairedDiseasedYes.setSelected(true);
        this.SizePanelRoeMetz.ButtonPairedDiseasedNo.setSelected(false);
        this.SizePanelRoeMetz.pairedDiseasedFlag = 1;
        JTextField_Nexp.setText("10");
        this.useMLEbox.setSelected(false);
        this.useMLE = 0;
    }

    public void parseCofVfile(File f) {
        ArrayList<String> fileContent = new ArrayList();
        if (f == null) {
            return;
        }
        fileContent = this.readFile(f.getPath());
        this.clearInputs();
        this.setInputsFromFile(fileContent);
    }

    private void setInputsFromFile(ArrayList<String> fileContent) {
        int totalLine = fileContent.size();
        int counter = 0;
        while (counter < totalLine) {
            String str;
            int tmploc;
            String tempstr = fileContent.get(counter).toUpperCase();
            ++counter;
            int loc = tempstr.indexOf("ARC0:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_ARC0.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("ARC1:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_ARC1.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("BRC0:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_BRC0.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("BRC1:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_BRC1.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("RC0:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_RC0.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("RC1:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_RC1.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("AR0:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_AR0.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("AC0:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_AC0.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("AR1:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_AR1.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("AC1:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_AC1.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("BR0:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_BR0.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("BC0:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_BC0.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("BR1:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_BR1.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("BC1:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_BC1.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("R0:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_R0.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("C0:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_C0.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("R1:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_R1.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("C1:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                v_C1.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("UA:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                mu0.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("UB:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                mu1.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("N0:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                NnormalJTextField.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("N1:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                NdiseaseJTextField.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("NR:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                NreaderJTextField.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("SPLIT-PLOT GROUPS:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                this.SizePanelRoeMetz.NumSplitPlotsJTextField.setText(tempstr.substring(tmploc + 1).trim());
                this.SizePanelRoeMetz.numSplitPlots = Integer.parseInt(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("PAIRED READERS:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                str = tempstr.substring(tmploc + 1).trim();
                if (str.equals("YES")) {
                    this.SizePanelRoeMetz.ButtonPairedReadersYes.setSelected(true);
                    this.SizePanelRoeMetz.ButtonPairedReadersNo.setSelected(false);
                    this.SizePanelRoeMetz.pairedReadersFlag = 1;
                    continue;
                }
                this.SizePanelRoeMetz.ButtonPairedReadersYes.setSelected(false);
                this.SizePanelRoeMetz.ButtonPairedReadersNo.setSelected(true);
                this.SizePanelRoeMetz.pairedReadersFlag = 0;
                continue;
            }
            loc = tempstr.indexOf("PAIRED NORMAL:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                str = tempstr.substring(tmploc + 1).trim();
                if (str.equals("YES")) {
                    this.SizePanelRoeMetz.ButtonPairedNormalsYes.setSelected(true);
                    this.SizePanelRoeMetz.ButtonPairedNormalsNo.setSelected(false);
                    this.SizePanelRoeMetz.pairedNormalsFlag = 1;
                    continue;
                }
                this.SizePanelRoeMetz.ButtonPairedNormalsYes.setSelected(false);
                this.SizePanelRoeMetz.ButtonPairedNormalsNo.setSelected(true);
                this.SizePanelRoeMetz.pairedNormalsFlag = 0;
                continue;
            }
            loc = tempstr.indexOf("PAIRED DISEASE:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                str = tempstr.substring(tmploc + 1).trim();
                if (str.equals("YES")) {
                    this.SizePanelRoeMetz.ButtonPairedDiseasedYes.setSelected(true);
                    this.SizePanelRoeMetz.ButtonPairedDiseasedNo.setSelected(false);
                    this.SizePanelRoeMetz.pairedDiseasedFlag = 1;
                    continue;
                }
                this.SizePanelRoeMetz.ButtonPairedDiseasedYes.setSelected(false);
                this.SizePanelRoeMetz.ButtonPairedDiseasedNo.setSelected(true);
                this.SizePanelRoeMetz.pairedDiseasedFlag = 0;
                continue;
            }
            loc = tempstr.indexOf("SEED FOR RNG: ");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                JTextField_seed.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("RANDOM STREAM");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                RandomStreamID = Integer.parseInt(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("NUMBER OF EXPERIMENTS:");
            if (loc != -1) {
                tmploc = tempstr.indexOf(":");
                JTextField_Nexp.setText(tempstr.substring(tmploc + 1).trim());
                continue;
            }
            loc = tempstr.indexOf("MLE ANALYSIS:");
            if (loc == -1) continue;
            tmploc = tempstr.indexOf(":");
            str = tempstr.substring(tmploc + 1).trim();
            if (str.equals("NO")) {
                this.useMLEbox.setSelected(false);
                this.useMLE = 0;
                continue;
            }
            this.useMLEbox.setSelected(true);
            this.useMLE = 1;
        }
    }

    private ArrayList<String> readFile(String filename) {
        ArrayList<String> content = new ArrayList<String>();
        try {
            String strtemp;
            FileInputStream fstream = new FileInputStream(filename);
            DataInputStream din = new DataInputStream(fstream);
            InputStreamReader isr = new InputStreamReader(din);
            BufferedReader br = new BufferedReader(isr);
            while ((strtemp = br.readLine()) != null) {
                content.add(strtemp);
            }
            br.close();
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (Exception e) {
            System.err.println("read file Error in RMGUInterface.java: " + e.getMessage());
        }
        return content;
    }

    public void writeInputFile(DBRecord currDBRecord, String filename, long l) {
        try {
            File file = new File(String.valueOf(this.simSaveDirectory) + "/" + "sim-" + filename + "-" + String.format("%05d", l) + ".imrmc");
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write("Simulated iMRMC input from " + filename + "\n");
            bw.write("\n");
            bw.write("NR: " + currDBRecord.Nreader + "\n");
            bw.write("N0: " + currDBRecord.Nnormal + "\n");
            bw.write("N1: " + currDBRecord.Ndisease + "\n");
            bw.write("NM: 2\n");
            bw.write("\n");
            bw.write("AUC1: " + this.threeDecOpt.format(currDBRecord.AUCsReaderAvg[0]) + "\n");
            bw.write("AUC2: " + this.threeDecOpt.format(currDBRecord.AUCsReaderAvg[1]) + "\n");
            bw.write("DAUC: " + this.threeDecOpt.format(currDBRecord.AUCsReaderAvg[0] - currDBRecord.AUCsReaderAvg[1]) + "\n");
            bw.write("\n");
            bw.write("BEGIN DATA:\n");
            int nrows = currDBRecord.InputFile1.observerData.length;
            String[][] observerDataTemp = currDBRecord.InputFile1.observerData;
            int i = 0;
            while (i < nrows) {
                bw.write(String.valueOf(observerDataTemp[i][0]) + ", " + observerDataTemp[i][1] + ", " + observerDataTemp[i][2] + ", " + observerDataTemp[i][3] + "\n");
                ++i;
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeSummaryFile(String saveDirectory, String summaryTitle, String filename, double[][][] allDecomps, double[][][] allCoeffs, double[] AUCs) {
        try {
            if (saveDirectory == null || saveDirectory.equals("")) {
                System.out.println("No save directory specified.");
            } else {
                System.out.println("filename: " + filename);
                File file = new File(String.valueOf(saveDirectory) + "//" + filename + ".txt");
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileWriter fw = new FileWriter(file.getAbsoluteFile());
                BufferedWriter bw = new BufferedWriter(fw);
                bw.write(String.valueOf(summaryTitle) + "\n\n");
                bw.write("AUC1: " + AUCs[0] + " AUC2: " + AUCs[1] + " AUC1-AUC2: " + AUCs[2] + "\n\n");
                double[][] BDGTab = DBRecord.getBDGTab(3, allDecomps[0], allCoeffs[0]);
                double[][] BCKTab = DBRecord.getBCKTab(3, allDecomps[1], allCoeffs[1]);
                double[][] DBMTab0 = DBRecord.getDBMTab(0, allDecomps[2], allCoeffs[2]);
                double[][] DBMTab1 = DBRecord.getDBMTab(0, allDecomps[2], allCoeffs[2]);
                double[][] DBMTabDiff = DBRecord.getDBMTab(0, allDecomps[2], allCoeffs[2]);
                double[][] ORTab0 = DBRecord.getORTab(0, allDecomps[2], allCoeffs[2]);
                double[][] ORTab1 = DBRecord.getORTab(0, allDecomps[2], allCoeffs[2]);
                double[][] ORTabDiff = DBRecord.getORTab(0, allDecomps[2], allCoeffs[2]);
                double[][] MSTab0 = DBRecord.getMSTab(0, allDecomps[2], allCoeffs[2]);
                double[][] MSTab1 = DBRecord.getMSTab(0, allDecomps[2], allCoeffs[2]);
                double[][] MSTabDiff = DBRecord.getMSTab(0, allDecomps[2], allCoeffs[2]);
                bw.write("BDG:\n");
                bw.write("components M0: \t\t");
                int i = 0;
                while (i < 8) {
                    bw.write(String.valueOf(this.threeDecE.format(BDGTab[0][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients M0: \t");
                i = 0;
                while (i < 8) {
                    bw.write(String.valueOf(this.threeDecE.format(BDGTab[1][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("components M1: \t\t");
                i = 0;
                while (i < 8) {
                    bw.write(String.valueOf(this.threeDecE.format(BDGTab[2][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients M1: \t");
                i = 0;
                while (i < 8) {
                    bw.write(String.valueOf(this.threeDecE.format(BDGTab[3][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("product M0,M1: \t\t");
                i = 0;
                while (i < 8) {
                    bw.write(String.valueOf(this.threeDecE.format(BDGTab[4][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("2*coeff M0-M1: \t\t");
                i = 0;
                while (i < 8) {
                    bw.write(String.valueOf(this.threeDecE.format(BDGTab[5][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("total: \t\t\t");
                i = 0;
                while (i < 8) {
                    bw.write(String.valueOf(this.threeDecE.format(BDGTab[6][i])) + "\t");
                    ++i;
                }
                bw.write("\n\n");
                bw.write("BCK:\n");
                bw.write("components M0: \t\t");
                i = 0;
                while (i < 7) {
                    bw.write(String.valueOf(this.threeDecE.format(BCKTab[0][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients M0: \t");
                i = 0;
                while (i < 7) {
                    bw.write(String.valueOf(this.threeDecE.format(BCKTab[1][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("components M1: \t\t");
                i = 0;
                while (i < 7) {
                    bw.write(String.valueOf(this.threeDecE.format(BCKTab[2][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients M1: \t");
                i = 0;
                while (i < 7) {
                    bw.write(String.valueOf(this.threeDecE.format(BCKTab[3][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("product M0,M1: \t\t");
                i = 0;
                while (i < 7) {
                    bw.write(String.valueOf(this.threeDecE.format(BCKTab[4][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("2*coeff M0-M1: \t\t");
                i = 0;
                while (i < 7) {
                    bw.write(String.valueOf(this.threeDecE.format(BCKTab[5][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("total: \t\t\t");
                i = 0;
                while (i < 7) {
                    bw.write(String.valueOf(this.threeDecE.format(BCKTab[6][i])) + "\t");
                    ++i;
                }
                bw.write("\n\n");
                bw.write("DBM Modality 0: \n");
                bw.write("components: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(DBMTab0[0][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(DBMTab0[1][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("total: \t\t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(DBMTab0[2][i])) + "\t");
                    ++i;
                }
                bw.write("\n\n");
                bw.write("DBM Modality 1: \n");
                bw.write("components: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(DBMTab1[0][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(DBMTab1[1][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("total: \t\t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(DBMTab1[2][i])) + "\t");
                    ++i;
                }
                bw.write("\n\n");
                bw.write("DBM Difference: \n");
                bw.write("components: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(DBMTabDiff[0][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(DBMTabDiff[1][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("total: \t\t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(DBMTabDiff[2][i])) + "\t");
                    ++i;
                }
                bw.write("\n\n");
                bw.write("OR Modality 0: \n");
                bw.write("components: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(ORTab0[0][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(ORTab0[1][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("total: \t\t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(ORTab0[2][i])) + "\t");
                    ++i;
                }
                bw.write("\n\n");
                bw.write("OR Modality 1: \n");
                bw.write("components: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(ORTab1[0][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(ORTab1[1][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("total: \t\t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(ORTab1[2][i])) + "\t");
                    ++i;
                }
                bw.write("\n\n");
                bw.write("OR Difference: \n");
                bw.write("components: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(ORTabDiff[0][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(ORTabDiff[1][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("total: \t\t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(ORTabDiff[2][i])) + "\t");
                    ++i;
                }
                bw.write("\n\n");
                bw.write("MS Modality 0: \n");
                bw.write("components: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(MSTab0[0][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(MSTab0[1][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("total: \t\t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(MSTab0[2][i])) + "\t");
                    ++i;
                }
                bw.write("\n\n");
                bw.write("MS Modality 1: \n");
                bw.write("components: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(MSTab1[0][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(MSTab1[1][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("total: \t\t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(MSTab1[2][i])) + "\t");
                    ++i;
                }
                bw.write("\n\n");
                bw.write("MS Difference: \n");
                bw.write("components: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(MSTabDiff[0][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("coefficients: \t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(MSTabDiff[1][i])) + "\t");
                    ++i;
                }
                bw.write("\n");
                bw.write("total: \t\t");
                i = 0;
                while (i < 6) {
                    bw.write(String.valueOf(this.threeDecE.format(MSTabDiff[2][i])) + "\t");
                    ++i;
                }
                bw.write("\n\n");
                bw.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JTabbedPane makeTableTabs(double[][][] allDecomps, double[][][] allCoeffs) {
        JTabbedPane tabTables = new JTabbedPane();
        JComponent BDGpane = this.makeTablePane(new String[]{"", "M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8"});
        JComponent BCKpane = this.makeTablePane(new String[]{"", "N", "D", "N~D", "R", "N~R", "D~R", "R~N~D"});
        JComponent DBMpane = this.makeTablePane(new String[]{"", "R", "C", "R~C", "T~R", "T~C", "T~R~C"});
        JComponent ORpane = this.makeTablePane(new String[]{"", "R", "TR", "COV1", "COV2", "COV3", "ERROR"});
        JComponent MSpane = this.makeTablePane(new String[]{"", "R", "C", "RC", "MR", "MC", "MRC"});
        tabTables.addTab("BDG", BDGpane);
        tabTables.addTab("BCK", BCKpane);
        tabTables.addTab("DBM", DBMpane);
        tabTables.addTab("OR", ORpane);
        tabTables.addTab("MS", MSpane);
        this.updateBDGpane(BDGpane, 0, allDecomps[0], allCoeffs[0]);
        this.updateBCKpane(BCKpane, 0, allDecomps[1], allCoeffs[1]);
        return tabTables;
    }

    private JComponent makeTablePane(String[] colNames) {
        JPanel thePane = new JPanel(false);
        Object[][] theData = new Object[3][colNames.length];
        JTable table = new JTable(theData, colNames);
        table.setValueAt("components", 0, 0);
        table.setValueAt("coeff", 1, 0);
        table.setValueAt("total", 2, 0);
        thePane.setLayout(new BorderLayout());
        thePane.add((Component)table.getTableHeader(), "First");
        thePane.add(table);
        thePane.add((Component)new JLabel("sqrt(Var) = "), "East");
        return thePane;
    }

    private void updateBDGpane(JComponent BDGpane, int mod, double[][] BDG, double[][] BDGcoeff) {
        JTable table = (JTable)BDGpane.getComponent(1);
        JLabel varLabel = (JLabel)BDGpane.getComponent(2);
        double[][] BDGdata = new double[7][8];
        double[][] tempBDGTab = DBRecord.getBDGTab(mod, BDG, BDGcoeff);
        String output1 = "sqrt(Var) = ";
        if (mod == 0) {
            BDGdata[0] = tempBDGTab[0];
            BDGdata[1] = tempBDGTab[1];
        } else if (mod == 1) {
            BDGdata[0] = tempBDGTab[2];
            BDGdata[1] = tempBDGTab[3];
        } else if (mod == 3) {
            BDGdata[0] = tempBDGTab[4];
            BDGdata[1] = Matrix.scale(tempBDGTab[5], 0.5);
            output1 = "sqrt(Cov) = ";
        }
        double currVar = 0.0;
        int j = 0;
        while (j < 8) {
            BDGdata[2][j] = BDGdata[0][j] * BDGdata[1][j];
            currVar += BDGdata[2][j];
            ++j;
        }
        int i = 0;
        while (i < 3) {
            int j2 = 0;
            while (j2 < 8) {
                table.setValueAt(this.threeDecOptE.format(BDGdata[i][j2]), i, j2 + 1);
                ++j2;
            }
            ++i;
        }
        String output = this.threeDec.format(Math.sqrt(currVar));
        varLabel.setText(String.valueOf(output1) + output);
    }

    private void updateBCKpane(JComponent BCKpane, int mod, double[][] BCK, double[][] BCKcoeff) {
        JTable table = (JTable)BCKpane.getComponent(1);
        JLabel varLabel = (JLabel)BCKpane.getComponent(2);
        double[][] BCKdata = new double[3][7];
        double[][] tempBCKTab = DBRecord.getBCKTab(mod, BCK, BCKcoeff);
        String output1 = "sqrt(Var) = ";
        if (mod == 0) {
            BCKdata[0] = tempBCKTab[0];
            BCKdata[1] = tempBCKTab[1];
        } else if (mod == 1) {
            BCKdata[0] = tempBCKTab[2];
            BCKdata[1] = tempBCKTab[3];
        } else if (mod == 3) {
            BCKdata[0] = tempBCKTab[4];
            BCKdata[1] = Matrix.scale(tempBCKTab[5], 0.5);
            output1 = "sqrt(Cov) = ";
        }
        double currVar = 0.0;
        int j = 0;
        while (j < 7) {
            BCKdata[2][j] = BCKdata[0][j] * BCKdata[1][j];
            currVar += BCKdata[2][j];
            ++j;
        }
        int i = 0;
        while (i < 3) {
            int j2 = 0;
            while (j2 < 7) {
                table.setValueAt(this.threeDecOptE.format(BCKdata[i][j2]), i, j2 + 1);
                ++j2;
            }
            ++i;
        }
        String output = this.threeDec.format(Math.sqrt(currVar));
        varLabel.setText(String.valueOf(output1) + output);
    }

    private void updateDBMpane(JComponent DBMpane, int mod, double[][] DBM, double[][] DBMcoeff) {
        JTable table = (JTable)DBMpane.getComponent(1);
        JLabel varLabel = (JLabel)DBMpane.getComponent(2);
        double[][] DBMdata = DBRecord.getDBMTab(mod, DBM, DBMcoeff);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 6) {
                table.setValueAt(this.threeDecOptE.format(DBMdata[i][j]), i, j + 1);
                ++j;
            }
            ++i;
        }
        double currVar = Matrix.total(DBMdata[2]);
        String output = this.threeDec.format(Math.sqrt(currVar));
        varLabel.setText("sqrt(Var) = " + output);
    }

    private void updateORpane(JComponent ORpane, int mod, double[][] OR, double[][] ORcoeff) {
        JTable table = (JTable)ORpane.getComponent(1);
        JLabel varLabel = (JLabel)ORpane.getComponent(2);
        double[][] ORdata = DBRecord.getORTab(mod, OR, ORcoeff);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 6) {
                table.setValueAt(this.threeDecOptE.format(ORdata[i][j]), i, j + 1);
                ++j;
            }
            ++i;
        }
        double currVar = Matrix.total(ORdata[2]);
        String output = this.threeDec.format(Math.sqrt(currVar));
        varLabel.setText("sqrt(Var) = " + output);
    }

    private void updateMSpane(JComponent MSpane, int mod, double[][] MS, double[][] MScoeff) {
        JTable table = (JTable)MSpane.getComponent(1);
        JLabel varLabel = (JLabel)MSpane.getComponent(2);
        double[][] MSdata = DBRecord.getMSTab(mod, MS, MScoeff);
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 6) {
                table.setValueAt(this.threeDecOptE.format(MSdata[i][j]), i, j + 1);
                ++j;
            }
            ++i;
        }
        double currVar = Matrix.total(MSdata[2]);
        String output = this.threeDec.format(Math.sqrt(currVar));
        varLabel.setText("sqrt(Var) = " + output);
    }

    private class CalculateCofV
    extends SwingWorker<DBRecord, Integer> {
        double[] u;
        double[] var_t;
        SizePanel SizePanelRoeMetz;

        public CalculateCofV(double[] u, double[] var_t, SizePanel SizePanelRoeMetz) {
            this.u = u;
            this.var_t = var_t;
            this.SizePanelRoeMetz = SizePanelRoeMetz;
        }

        @Override
        public DBRecord doInBackground() {
            CalcGenRoeMetz.genRoeMetz(this.u, this.var_t, this.SizePanelRoeMetz);
            return CalcGenRoeMetz.DBRecordNumerical;
        }

        @Override
        protected void done() {
            this.firePropertyChange("done", 0, 1);
        }
    }

    class ClearBtnListener
    implements ActionListener {
        ClearBtnListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            RMGUInterface.this.clearInputs();
        }
    }

    public class DoNumericalIntegrationBtnListener
    implements ActionListener {
        public DBRecord DBRecordNumerical;

        @Override
        public void actionPerformed(ActionEvent e) {
            RMGUInterface.this.SizePanelRoeMetz.NreaderJTextField = NreaderJTextField;
            RMGUInterface.this.SizePanelRoeMetz.NnormalJTextField = NnormalJTextField;
            RMGUInterface.this.SizePanelRoeMetz.NdiseaseJTextField = NdiseaseJTextField;
            System.out.println(NreaderJTextField.getText());
            this.doNumericalAnalysisSEQ();
        }

        public void doNumericalAnalysisBKG() {
            try {
                double[] u = RMGUInterface.this.getMeans();
                double[] var_t = RMGUInterface.this.getVariances();
                RMGUInterface.this.SizePanelRoeMetz.NreaderJTextField = NreaderJTextField;
                RMGUInterface.this.SizePanelRoeMetz.NnormalJTextField = NnormalJTextField;
                RMGUInterface.this.SizePanelRoeMetz.NdiseaseJTextField = NdiseaseJTextField;
                System.out.println(NreaderJTextField.getText());
                SizePanel SizePanelRoeMetz1 = RMGUInterface.this.SizePanelRoeMetz;
                final CalculateCofV calcTask = new CalculateCofV(u, var_t, RMGUInterface.this.SizePanelRoeMetz);
                calcTask.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        if (evt.getPropertyName().equals("done")) {
                            try {
                                DoNumericalIntegrationBtnListener.this.DBRecordNumerical = (DBRecord)calcTask.get();
                                DoNumericalIntegrationBtnListener.this.processResults();
                                ((DoNumericalIntegrationBtnListener)DoNumericalIntegrationBtnListener.this).RMGUInterface.this.processDone = true;
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            catch (ExecutionException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
                calcTask.execute();
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(RoeMetz1.getFrame(), "Incorrect / Incomplete Input", "Error", 0);
            }
        }

        public void doNumericalAnalysisSEQ() {
            try {
                double[] u = RMGUInterface.this.getMeans();
                double[] var_t = RMGUInterface.this.getVariances();
                RMGUInterface.this.SizePanelRoeMetz.NreaderJTextField = NreaderJTextField;
                RMGUInterface.this.SizePanelRoeMetz.NnormalJTextField = NnormalJTextField;
                RMGUInterface.this.SizePanelRoeMetz.NdiseaseJTextField = NdiseaseJTextField;
                System.out.println(NreaderJTextField.getText());
                CalcGenRoeMetz.genRoeMetz(u, var_t, RMGUInterface.this.SizePanelRoeMetz);
                this.DBRecordNumerical = CalcGenRoeMetz.DBRecordNumerical;
                this.processResults();
            }
            catch (NumberFormatException e1) {
                JOptionPane.showMessageDialog(RoeMetz1.getFrame(), "Incorrect / Incomplete Input", "Error", 0);
            }
        }

        public void processResults() {
            this.DBRecordNumerical.Decompositions();
            this.DBRecordNumerical.NreaderDB = this.DBRecordNumerical.Nreader;
            this.DBRecordNumerical.NnormalDB = this.DBRecordNumerical.Nnormal;
            this.DBRecordNumerical.NdiseaseDB = this.DBRecordNumerical.Ndisease;
            this.DBRecordNumerical.InputFile1 = new InputFile();
            int i = 1;
            while ((long)i < this.DBRecordNumerical.Nreader + 1L) {
                this.DBRecordNumerical.InputFile1.readerIDs.put(Integer.toString(i), i);
                ++i;
            }
            RMGUInterface.this.StatPanelNumerical = new StatPanel(RoeMetz1.getFrame(), this.DBRecordNumerical);
            RMGUInterface.this.StatPanelNumerical.setStatPanel();
            RMGUInterface.this.StatPanelNumerical.setTable1();
            JDialog numericalOutput = new JDialog((Frame)RoeMetz1.getFrame(), "Numerical Integration Results");
            numericalOutput.add(RMGUInterface.this.StatPanelNumerical.JPanelStat);
            JButton numericalOutputExport = new JButton("Export Analysis Result");
            numericalOutputExport.addActionListener(new analysisExportListener(this.DBRecordNumerical, "Numerical", RMGUInterface.this.StatPanelNumerical));
            numericalOutput.add((Component)numericalOutputExport, "Last");
            numericalOutput.pack();
            if (!RoeMetz.doValidation) {
                numericalOutput.setVisible(true);
            }
            SimpleDateFormat dateForm = new SimpleDateFormat("yy-MM-dd-HH-mm-ss");
            Date currDate = new Date();
            String filenameTime = dateForm.format(currDate);
        }
    }

    public class DoSimBtnListener
    implements ActionListener {
        int finishedTasks = 0;
        final int numCores = 1;
        int numCoresToUse;
        DBRecord[][] results = new DBRecord[1][2];

        @Override
        public void actionPerformed(ActionEvent e) {
            this.doSimulationAnalysis();
        }

        public void doSimulationAnalysis() {
            try {
                RMGUInterface.this.SizePanelRoeMetz.NreaderJTextField = NreaderJTextField;
                RMGUInterface.this.SizePanelRoeMetz.NnormalJTextField = NnormalJTextField;
                RMGUInterface.this.SizePanelRoeMetz.NdiseaseJTextField = NdiseaseJTextField;
                String String_seed = JTextField_seed.getText();
                if (String_seed.length() > 9) {
                    return;
                }
                double[] u = RMGUInterface.this.getMeans();
                double[] var_t = RMGUInterface.this.getVariances();
                long Nexp = Integer.valueOf(JTextField_Nexp.getText()).intValue();
                this.numCoresToUse = Nexp < 1L ? (int)Nexp : 1;
                long NexpPerCore = Nexp / (long)this.numCoresToUse;
                if (!RoeMetz.doValidation && (RMGUInterface.this.simSaveDirectory == null || RMGUInterface.this.simSaveDirectory.equals(""))) {
                    JOptionPane.showMessageDialog(RoeMetz1.getFrame(), "Save directory not specified.\nExperiment output files will not be written.", "Warning", 2);
                }
                SimpleDateFormat dateForm = new SimpleDateFormat("yy-MM-dd-HH-mm-ss");
                Date currDate = new Date();
                final String filenameTime = dateForm.format(currDate);
                int[] nArray = new int[32];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                nArray[4] = 4;
                nArray[5] = 5;
                nArray[6] = 6;
                nArray[7] = 7;
                nArray[8] = 8;
                nArray[9] = 9;
                nArray[10] = 10;
                nArray[11] = 11;
                nArray[12] = 12;
                nArray[13] = 13;
                nArray[14] = 14;
                nArray[15] = 15;
                nArray[16] = 16;
                nArray[17] = 17;
                nArray[18] = 18;
                nArray[19] = 19;
                nArray[20] = 20;
                nArray[21] = 21;
                nArray[22] = 22;
                nArray[23] = 23;
                nArray[24] = 24;
                nArray[25] = 25;
                nArray[26] = 26;
                nArray[27] = 27;
                nArray[28] = 28;
                nArray[29] = 29;
                nArray[30] = 30;
                nArray[31] = 31;
                int[] seedIntArr32 = nArray;
                String seedString = JTextField_seed.getText();
                seedIntArr32[0] = Integer.parseInt(seedString);
                WELL1024.setPackageSeed(seedIntArr32);
                AtomicInteger NexpCompleted_atomic = new AtomicInteger(0);
                this.createProgressBar((int)Nexp, NexpCompleted_atomic.get());
                final SimExperiments_thread[] allTasks = new SimExperiments_thread[this.numCoresToUse];
                System.out.println("******** TEST serial RNG BEG ********");
                int i = 0;
                while (i < this.numCoresToUse) {
                    final int taskNum = i;
                    WELL1024 RandomStreamI = new WELL1024();
                    int ns = 1;
                    while (ns < RandomStreamID) {
                        RandomStreamI = new WELL1024();
                        ++ns;
                    }
                    long NexpStart = NexpPerCore * (long)i;
                    long NexpEnd = NexpStart + NexpPerCore;
                    if (i == this.numCoresToUse - 1) {
                        NexpEnd = Nexp;
                    }
                    allTasks[i] = new SimExperiments_thread(u, var_t, Nexp, NexpStart, NexpEnd, NexpCompleted_atomic, filenameTime, i, RandomStreamI, RMGUInterface.this.SizePanelRoeMetz);
                    allTasks[i].addPropertyChangeListener(new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent evt) {
                            if (evt.getPropertyName().equals("done")) {
                                try {
                                    DoSimBtnListener.this.results[taskNum] = (DBRecord[])allTasks[taskNum].get();
                                    ++DoSimBtnListener.this.finishedTasks;
                                    if (DoSimBtnListener.this.finishedTasks == DoSimBtnListener.this.numCoresToUse) {
                                        DoSimBtnListener.this.finishedTasks = 0;
                                        DoSimBtnListener.this.processResults(RMGUInterface.this.simSaveDirectory, filenameTime);
                                        if (RoeMetz.doValidation) {
                                            analysisExportListener analysisExportListener1 = new analysisExportListener(((DoSimBtnListener)DoSimBtnListener.this).RMGUInterface.this.avgDBRecordStat, "Simulation", ((DoSimBtnListener)DoSimBtnListener.this).RMGUInterface.this.StatPanel1);
                                            analysisExportListener1.exportResult();
                                            System.exit(0);
                                        }
                                    }
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                                catch (ExecutionException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    });
                    ++i;
                }
                System.out.println("******** TEST serial RNG END ********");
                i = 0;
                while (i < this.numCoresToUse) {
                    allTasks[i].execute();
                    ++i;
                }
            }
            catch (NumberFormatException e1) {
                System.out.println(e1.toString());
                JOptionPane.showMessageDialog(RoeMetz1.getFrame(), "Incorrect / Incomplete Input", "Error", 0);
            }
        }

        private void createProgressBar(int Nexp, int initProgress) {
            simProgress = new JProgressBar(0, Nexp);
            simProgress.setValue(initProgress);
            RMGUInterface.this.progDialog = new JDialog((Frame)RoeMetz1.getFrame(), "Simulation Progress");
            JPanel pane = new JPanel(new FlowLayout());
            pane.add(simProgress);
            RMGUInterface.this.progDialog.setContentPane(pane);
            RMGUInterface.this.progDialog.pack();
            if (!RoeMetz.doValidation) {
                RMGUInterface.this.progDialog.setVisible(true);
            }
        }

        public void processResults(String simSaveDirectory, String filenameTime) {
            RMGUInterface.this.progDialog.setVisible(false);
            DBRecord DBRecordStat = new DBRecord();
            RMGUInterface.this.avgDBRecordStat = new DBRecord();
            DBRecord squareDBRecordStat = new DBRecord();
            DBRecord avgSquareDBRecordStat = new DBRecord();
            DBRecordStat = this.results[0][0];
            RMGUInterface.this.avgDBRecordStat = this.results[0][1];
            squareDBRecordStat = this.results[0][2];
            avgSquareDBRecordStat = this.results[0][3];
            int i = 1;
            while (i < this.numCoresToUse) {
                DBRecordStat = this.results[i][1];
                DBRecord.add(DBRecordStat, RMGUInterface.this.avgDBRecordStat);
                DBRecordStat = this.results[i][0];
                squareDBRecordStat = this.results[i][3];
                DBRecord.add(squareDBRecordStat, avgSquareDBRecordStat);
                squareDBRecordStat = this.results[i][2];
                ++i;
            }
            if (RMGUInterface.this.avgDBRecordStat.flagTotalVarIsNegative > 0L && !RoeMetz.doValidation) {
                JFrame frame = new JFrame();
                JOptionPane.showMessageDialog(frame, "There were " + RMGUInterface.this.avgDBRecordStat.flagTotalVarIsNegative + " iterations where the totalVar estimate was negative.\n" + "These iterations were replaced new iterations.\n" + "Negative estimates of totalVar are generally expected to be very rare.\n" + "The likelihood increases as N0, N1, and NR get small.\n" + "Negative estimates of totalVar are not possible when you use MLE.", "Warning", 0);
            }
            double Nexp = Integer.valueOf(JTextField_Nexp.getText()).intValue();
            double UseTrial = Nexp - (double)RMGUInterface.this.avgDBRecordStat.flagTotalVarIsNegative;
            DBRecord.scale(RMGUInterface.this.avgDBRecordStat, 1.0 / UseTrial);
            DBRecord.scale(avgSquareDBRecordStat, 1.0 / UseTrial);
            DBRecord.copy(avgSquareDBRecordStat, squareDBRecordStat);
            DBRecord.scale(squareDBRecordStat, UseTrial / (UseTrial - 1.0));
            DBRecord.copy(RMGUInterface.this.avgDBRecordStat, DBRecordStat);
            DBRecord.square(DBRecordStat);
            DBRecord.scale(DBRecordStat, -UseTrial / (UseTrial - 1.0));
            DBRecord.add(DBRecordStat, squareDBRecordStat);
            RMGUInterface.this.varDBRecordStat = squareDBRecordStat;
            squareDBRecordStat = null;
            DBRecordStat = this.results[0][0];
            RMGUInterface.this.avgDBRecordStat.Decompositions();
            RMGUInterface.this.StatPanel1 = new StatPanel(RoeMetz1.getFrame(), RMGUInterface.this.avgDBRecordStat);
            RMGUInterface.this.StatPanel1.setStatPanel();
            RMGUInterface.this.StatPanel1.setTable1();
            RMGUInterface.this.StatPanel1.setMCresults(RMGUInterface.this.avgDBRecordStat, RMGUInterface.this.varDBRecordStat);
            JDialog simOutput = new JDialog((Frame)RoeMetz1.getFrame(), "Simulation Results: MC means");
            simOutput.add(RMGUInterface.this.StatPanel1.JPanelStat);
            JButton simulationExport = new JButton("Export Analysis Result");
            simulationExport.addActionListener(new analysisExportListener(RMGUInterface.this.avgDBRecordStat, "Simulation", RMGUInterface.this.StatPanel1));
            simOutput.add((Component)simulationExport, "Last");
            simOutput.pack();
            if (!RoeMetz.doValidation) {
                simOutput.setVisible(true);
            }
        }

        private void showSimOutput(DBRecord DBRecordStat) {
            JDialog simOutput = new JDialog((Frame)RoeMetz1.getFrame(), "Simulation Results");
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            JPanel tablePanel = new JPanel();
            tablePanel.setLayout(new BoxLayout(tablePanel, 0));
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
            JLabel AUCs = new JLabel("AUC1: " + RMGUInterface.this.threeDecOpt.format(DBRecordStat.AUCsReaderAvg[0]) + "   " + "AUC2: " + RMGUInterface.this.threeDecOpt.format(DBRecordStat.AUCsReaderAvg[1]) + "   " + "AUC1-AUC2: " + RMGUInterface.this.threeDecOpt.format(DBRecordStat.AUCsReaderAvg[0] - DBRecordStat.AUCsReaderAvg[1]) + "   ");
            String str1 = "Modality 1";
            JRadioButton mod1SimButton = new JRadioButton(str1);
            mod1SimButton.setActionCommand(str1);
            mod1SimButton.setSelected(true);
            String str2 = "Modality 2";
            JRadioButton mod2SimButton = new JRadioButton(str2);
            mod2SimButton.setActionCommand(str2);
            String strD = "Difference";
            JRadioButton modDSimButton = new JRadioButton(strD);
            modDSimButton.setActionCommand(strD);
            ButtonGroup group = new ButtonGroup();
            group.add(mod1SimButton);
            group.add(mod2SimButton);
            group.add(modDSimButton);
            buttonPanel.add(AUCs);
            buttonPanel.add(mod1SimButton);
            buttonPanel.add(mod2SimButton);
            buttonPanel.add(modDSimButton);
            panel.add(tablePanel);
            panel.add(buttonPanel);
            simOutput.add(panel);
            simOutput.pack();
            simOutput.setVisible(true);
        }

        class ModSimListener
        implements ActionListener {
            JTabbedPane tabTables;
            private double[][] allBDG;
            private double[][] allBCK;
            private double[][] allDBM;
            private double[][] allOR;
            private double[][] allMS;
            private double[][] BDGcoeff;
            private double[][] BCKcoeff;
            private double[][] DBMcoeff;
            private double[][] MScoeff;
            private double[][] ORcoeff;

            public ModSimListener(JTabbedPane tabTables, double[][][] allDecomps, double[][][] allCoeffs) {
                this.tabTables = tabTables;
                this.allBDG = allDecomps[0];
                this.allBCK = allDecomps[1];
                this.allDBM = allDecomps[2];
                this.allOR = allDecomps[3];
                this.allMS = allDecomps[4];
                this.BDGcoeff = allCoeffs[0];
                this.BCKcoeff = allCoeffs[1];
                this.DBMcoeff = allCoeffs[2];
                this.MScoeff = allCoeffs[3];
                this.ORcoeff = allCoeffs[4];
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String str = e.getActionCommand();
                if (str == "Modality 1") {
                    this.updatePanes(0);
                }
                if (str == "Modality 2") {
                    this.updatePanes(1);
                }
                if (str == "Difference") {
                    this.updatePanes(3);
                }
            }

            private void updatePanes(int mod) {
                RMGUInterface.this.updateBDGpane((JComponent)this.tabTables.getComponent(0), mod, this.allBDG, this.BDGcoeff);
                RMGUInterface.this.updateBCKpane((JComponent)this.tabTables.getComponent(1), mod, this.allBCK, this.BCKcoeff);
                RMGUInterface.this.updateDBMpane((JComponent)this.tabTables.getComponent(2), mod, this.allDBM, this.DBMcoeff);
                RMGUInterface.this.updateORpane((JComponent)this.tabTables.getComponent(3), mod, this.allOR, this.ORcoeff);
                RMGUInterface.this.updateMSpane((JComponent)this.tabTables.getComponent(4), mod, this.allMS, this.MScoeff);
            }
        }
    }

    class PopFromFileListener
    implements ActionListener {
        PopFromFileListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser fc = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter("iRoeMetz CofV Input (.irm)", "irm");
            fc.setFileFilter(filter);
            int fcReturn = fc.showOpenDialog((Component)e.getSource());
            File f = fc.getSelectedFile();
            RMGUInterface.this.parseCofVfile(f);
            RMGUInterface.this.inputDirectory = fc.getCurrentDirectory();
            String savedFileName = f.getPath();
            RMGUInterface.this.inputFileName = f.getPath();
            RMGUInterface.this.inputFileName = RMGUInterface.this.inputFileName.substring(0, RMGUInterface.this.inputFileName.lastIndexOf(".irm"));
        }
    }

    class SaveFieldsListener
    implements ActionListener {
        SaveFieldsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser fc = new JFileChooser();
                FileNameExtensionFilter filter = new FileNameExtensionFilter("iRoeMetz CofV Input (.irm)", "irm");
                fc.setFileFilter(filter);
                int fcReturn = fc.showOpenDialog((Component)e.getSource());
                if (fcReturn == 0) {
                    File f = fc.getSelectedFile();
                    String fPath = f.getPath();
                    if (!fPath.toLowerCase().endsWith(".irm")) {
                        f = new File(String.valueOf(fPath) + ".irm");
                    }
                    if (!f.exists()) {
                        f.createNewFile();
                    }
                    FileWriter fw = new FileWriter(f.getAbsoluteFile());
                    BufferedWriter bw = new BufferedWriter(fw);
                    bw.write("AR0: " + v_AR0.getText() + "\r\n");
                    bw.write("AC0: " + v_AC0.getText() + "\r\n");
                    bw.write("ARC0: " + v_ARC0.getText() + "\r\n");
                    bw.write("AR1: " + v_AR1.getText() + "\r\n");
                    bw.write("AC1: " + v_AC1.getText() + "\r\n");
                    bw.write("ARC1: " + v_ARC1.getText() + "\r\n");
                    bw.write("BR0: " + v_BR0.getText() + "\r\n");
                    bw.write("BC0: " + v_BC0.getText() + "\r\n");
                    bw.write("BRC0: " + v_BRC0.getText() + "\r\n");
                    bw.write("BR1: " + v_BR1.getText() + "\r\n");
                    bw.write("BC1: " + v_BC1.getText() + "\r\n");
                    bw.write("BRC1: " + v_BRC1.getText() + "\r\n");
                    bw.write("R0: " + v_R0.getText() + "\r\n");
                    bw.write("C0: " + v_C0.getText() + "\r\n");
                    bw.write("RC0: " + v_RC0.getText() + "\r\n");
                    bw.write("R1: " + v_R1.getText() + "\r\n");
                    bw.write("C1: " + v_C1.getText() + "\r\n");
                    bw.write("RC1: " + v_RC1.getText() + "\r\n");
                    bw.write("uA: " + mu0.getText() + "\r\n");
                    bw.write("uB: " + mu1.getText() + "\r\n");
                    bw.write("n0: " + NnormalJTextField.getText() + "\r\n");
                    bw.write("n1: " + NdiseaseJTextField.getText() + "\r\n");
                    bw.write("nr: " + NreaderJTextField.getText() + "\r\n");
                    bw.write("Study Design \r\n");
                    bw.write("# of Split-Plot Groups: " + RMGUInterface.this.SizePanelRoeMetz.numSplitPlots + "\r\n");
                    if (RMGUInterface.this.SizePanelRoeMetz.pairedReadersFlag == 1) {
                        bw.write("Paired Readers: Yes \r\n");
                    } else {
                        bw.write("Paired Readers: No \r\n");
                    }
                    if (RMGUInterface.this.SizePanelRoeMetz.pairedNormalsFlag == 1) {
                        bw.write("Paired Normal: Yes \r\n");
                    } else {
                        bw.write("Paired Normal: No \r\n");
                    }
                    if (RMGUInterface.this.SizePanelRoeMetz.pairedDiseasedFlag == 1) {
                        bw.write("Paired Disease: Yes \r\n");
                    } else {
                        bw.write("Paired Diesase: No \r\n");
                    }
                    bw.write("Simulation parameter \r\n");
                    bw.write("Seed for RNG: " + JTextField_seed.getText() + "\r\n");
                    bw.write("Number of Experiments: " + JTextField_Nexp.getText() + "\r\n");
                    if (RMGUInterface.this.useMLE == 1) {
                        bw.write("MLE analysis: Yes\r\n");
                    } else {
                        bw.write("MLE analysis: No\r\n");
                    }
                    bw.close();
                }
            }
            catch (HeadlessException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    class SaveSimulationListener
    implements ActionListener {
        SaveSimulationListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JFileChooser fc = new JFileChooser();
            fc.setFileSelectionMode(1);
            int fcReturn = fc.showSaveDialog((JComponent)arg0.getSource());
            if (fcReturn == 0) {
                RMGUInterface.this.simSaveDirectory = fc.getSelectedFile().toString();
                System.out.println(RMGUInterface.this.simSaveDirectory);
            } else {
                System.out.println("No save directory selected");
                RMGUInterface.this.simSaveDirectory = null;
            }
        }
    }

    public class SeedInputListener
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            String regex;
            String String_desc;
            String String_seed = JTextField_seed.getText();
            if (String_seed.length() > 9) {
                String_seed = String_seed.substring(String_seed.length() - 9, String_seed.length());
                JTextField_seed.setText(String_seed);
                String_desc = "Seed must be 9 digit integer or smaller. \nInput seed will be truncated.";
                System.out.println(String_desc);
                JOptionPane.showMessageDialog(RoeMetz1.getFrame(), String_desc, "Error", 0);
            }
            if (!String_seed.matches(regex = "[0-9]+")) {
                String_seed = Long.toString(System.currentTimeMillis());
                if (String_seed.length() > 9) {
                    String_seed = String_seed.substring(String_seed.length() - 9, String_seed.length());
                }
                JTextField_seed.setText(String_seed);
                String_desc = "Seed must be digits only. \nRandom seed being used.";
                System.out.println(String_desc);
                JOptionPane.showMessageDialog(RoeMetz1.getFrame(), String_desc, "Error", 0);
            }
        }
    }

    private class SimExperiments_thread
    extends SwingWorker<DBRecord[], Integer> {
        double[] u;
        double[] var_t;
        SizePanel sizePanel1;
        long Nexp;
        long NexpStart;
        long NexpEnd;
        long NexpThisCore;
        AtomicInteger NexpCompleted_atomic;
        String filenameTime;
        int whichTask;
        private RandomStream RandomStreamI;

        public SimExperiments_thread(double[] u, double[] var_t, long Nexp, long NexpStart, long NexpEnd, AtomicInteger NexpCompleted_atomic, String filenameTime, int whichTask, RandomStream RandomStreamI, SizePanel sizePanelTemp) {
            this.sizePanel1 = sizePanelTemp;
            this.u = u;
            this.var_t = var_t;
            this.Nexp = Nexp;
            this.NexpStart = NexpStart;
            this.NexpEnd = NexpEnd;
            this.NexpThisCore = NexpEnd - NexpStart;
            this.NexpCompleted_atomic = NexpCompleted_atomic;
            this.filenameTime = filenameTime;
            this.whichTask = whichTask;
            this.RandomStreamI = RandomStreamI;
            System.out.print("ThreadName:" + Thread.currentThread().getName() + ":");
            int j = 0;
            while (j < 5) {
                int nextInt = RandomStreamI.nextInt(1, 100);
                System.out.print(String.valueOf(nextInt) + ",");
                ++j;
            }
            System.out.println();
        }

        @Override
        public DBRecord[] doInBackground() throws IOException {
            DBRecord DBRecordStat = new DBRecord();
            DBRecord squareDBRecordStat = new DBRecord();
            DBRecord sumDBRecordStat = new DBRecord();
            DBRecord sumSquareDBRecordStat = new DBRecord();
            DBRecordStat.verbose = false;
            sumDBRecordStat.verbose = false;
            squareDBRecordStat.verbose = false;
            sumSquareDBRecordStat.verbose = false;
            DBRecordStat.flagMLE = RMGUInterface.this.useMLE;
            sumDBRecordStat.flagMLE = RMGUInterface.this.useMLE;
            squareDBRecordStat.flagMLE = RMGUInterface.this.useMLE;
            sumSquareDBRecordStat.flagMLE = RMGUInterface.this.useMLE;
            long flagTotalVarIsNegative = 0L;
            RMGUInterface.this.trialResultArray = new double[(int)this.NexpEnd][21];
            RMGUInterface.this.SizingResultArray = new double[8][(int)this.NexpEnd][13];
            RMGUInterface.this.SizingResultMean = new double[8][14];
            SimRoeMetz currSimRoeMetz = new SimRoeMetz(this.u, this.var_t, this.RandomStreamI, this.sizePanel1);
            currSimRoeMetz.doSim(squareDBRecordStat);
            currSimRoeMetz.doSim(sumDBRecordStat);
            currSimRoeMetz.doSim(sumSquareDBRecordStat);
            currSimRoeMetz.doSim(DBRecordStat);
            DBRecord.copy(DBRecordStat, sumDBRecordStat);
            DBRecord.copy(DBRecordStat, squareDBRecordStat);
            DBRecord.square(squareDBRecordStat);
            DBRecord.copy(squareDBRecordStat, sumSquareDBRecordStat);
            if (RMGUInterface.this.simSaveDirectory != null && !RMGUInterface.this.simSaveDirectory.equals("")) {
                RMGUInterface.this.writeInputFile(sumDBRecordStat, this.filenameTime, this.NexpStart);
            }
            long i = this.NexpStart + 1L;
            while (i < this.NexpEnd) {
                this.publish(this.NexpCompleted_atomic.incrementAndGet());
                this.setProgress((int)(100L * (i - this.NexpStart) / this.NexpThisCore));
                try {
                    currSimRoeMetz.doSim(DBRecordStat);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (DBRecordStat.totalVar < 0.0) {
                    ++flagTotalVarIsNegative;
                } else {
                    DBRecord.add(DBRecordStat, sumDBRecordStat);
                    DBRecord.copy(DBRecordStat, squareDBRecordStat);
                    DBRecord.square(squareDBRecordStat);
                    DBRecord.add(squareDBRecordStat, sumSquareDBRecordStat);
                    if (RMGUInterface.this.simSaveDirectory != null && !RMGUInterface.this.simSaveDirectory.equals("")) {
                        RMGUInterface.this.writeInputFile(DBRecordStat, this.filenameTime, i);
                    }
                    if (DBRecordStat.verbose) {
                        System.out.print("ThreadName:" + Thread.currentThread().getName() + ":");
                        System.out.print(String.valueOf(i + 1L) + " of " + this.Nexp + " completed\n");
                    }
                }
                ++i;
            }
            sumDBRecordStat.flagTotalVarIsNegative = flagTotalVarIsNegative;
            DBRecord[] currDBRecord = new DBRecord[]{DBRecordStat, sumDBRecordStat, squareDBRecordStat, sumSquareDBRecordStat};
            return currDBRecord;
        }

        @Override
        protected void process(List<Integer> chunks) {
            for (int num : chunks) {
                simProgress.setValue(num);
            }
        }

        @Override
        protected void done() {
            this.firePropertyChange("done", 0, 1);
        }
    }

    class UseMLEListener
    implements ItemListener {
        UseMLEListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (RMGUInterface.this.useMLEbox.isSelected()) {
                RMGUInterface.this.useMLE = 1;
            } else {
                RMGUInterface.this.useMLE = 0;
            }
        }
    }

    public class analysisExportListener
    implements ActionListener {
        private DBRecord DB1;
        private String analysisMethod;
        private StatPanel StatPanelIn;

        @Override
        public void actionPerformed(ActionEvent e) {
            this.exportResult();
        }

        public void exportResult() {
            try {
                String savedFileName;
                int fcReturn;
                File fGUI = null;
                File fVal = null;
                File outputPackage = null;
                if (!RoeMetz.doValidation) {
                    JFileChooser fc = new JFileChooser();
                    SimpleDateFormat dateForm = new SimpleDateFormat("yyyyMMddHHmmss");
                    Date currDate = new Date();
                    String fileTime = dateForm.format(currDate);
                    String exportFolderName = String.valueOf(RMGUInterface.this.inputFileName) + this.analysisMethod + "Result" + fileTime;
                    if (RMGUInterface.this.outputDirectory != null) {
                        fc.setSelectedFile(new File(RMGUInterface.this.outputDirectory + "//" + exportFolderName));
                    } else if (RMGUInterface.this.inputDirectory != null) {
                        fc.setSelectedFile(new File(RMGUInterface.this.inputDirectory + "//" + exportFolderName));
                    } else {
                        fc.setSelectedFile(new File(exportFolderName));
                    }
                    fcReturn = fc.showSaveDialog(null);
                    outputPackage = fc.getSelectedFile();
                    if (!outputPackage.exists() && !outputPackage.isDirectory()) {
                        outputPackage.mkdir();
                    }
                    fGUI = new File(outputPackage + "//" + this.analysisMethod + "Summary.omrmc");
                    fVal = new File(outputPackage + "//" + this.analysisMethod + "Summary.csv");
                    RMGUInterface.this.outputDirectory = fc.getCurrentDirectory();
                    savedFileName = fc.getSelectedFile().getName();
                } else {
                    fcReturn = 0;
                    File outputDir = new File(String.valueOf(validateFunction.inputFile.getParent()) + "//" + "output");
                    if (!outputDir.exists() && !outputDir.isDirectory()) {
                        outputDir.mkdir();
                    }
                    String FileName = validateFunction.inputFile.getName();
                    FileName = FileName.substring(0, FileName.lastIndexOf("."));
                    String exportFileName = String.valueOf(FileName) + this.analysisMethod + "Summary" + ".csv";
                    fVal = new File(outputDir + "//" + exportFileName);
                    savedFileName = exportFileName;
                }
                if (fcReturn == 0) {
                    String reportGUI = "";
                    String reportValidation = "";
                    if (this.analysisMethod.equals("Simulation")) {
                        if (!RoeMetz.doValidation) {
                            reportGUI = String.valueOf(reportGUI) + "iRoeMetz simulation summary statistics from " + RoeMetz.versionName + "\r\n";
                            reportGUI = String.valueOf(reportGUI) + "Summary statistics written to file named:" + "\r\n";
                            reportGUI = String.valueOf(reportGUI) + savedFileName + "\r\n" + "\r\n";
                            reportGUI = exportToFile.exoprtiRoeMetzSet(reportGUI, RMGUInterface.this.SizePanelRoeMetz);
                            reportGUI = String.valueOf(reportGUI) + "Seed for RNG: " + JTextField_seed.getText() + "\r\n";
                            reportGUI = String.valueOf(reportGUI) + "Number of Experiments: " + JTextField_Nexp.getText() + "\r\n" + "\r\n";
                            reportGUI = String.valueOf(reportGUI) + "\r\n************************************************************\r\n";
                            reportGUI = exportToFile.exportSummary(reportGUI, this.DB1);
                            reportGUI = exportToFile.exportStatPanel(reportGUI, this.DB1, this.StatPanelIn);
                            reportGUI = exportToFile.exportMCvariance(reportGUI, RMGUInterface.this.varDBRecordStat);
                            reportGUI = exportToFile.exportTable1(reportGUI, this.DB1);
                            reportGUI = exportToFile.exportTable2(reportGUI, this.DB1);
                        }
                        reportValidation = "MCstat,AUCA,AUCB,AUCAminusAUCB,varA,varB,varAUCAminusAUCB,pValueNormal,botCInormal,topCInormal,rejectNormal,dfBDG,pValueBDG,botCIBDG,topCIBDG,rejectBDG,dfHillis,pValueHillis,botCIHillis,topCIHillis,rejectHillis\r\n";
                        reportValidation = exportToFile.exportMCmeanValidation(reportValidation, this.DB1);
                        reportValidation = exportToFile.exportMCvarianceValidation(reportValidation, RMGUInterface.this.varDBRecordStat);
                    } else {
                        if (!RoeMetz.doValidation) {
                            reportGUI = String.valueOf(reportGUI) + "iRoeMetz Numerical summary statistics from " + RoeMetz.versionName + "\r\n";
                            reportGUI = String.valueOf(reportGUI) + "Summary statistics written to file named:" + "\r\n";
                            reportGUI = String.valueOf(reportGUI) + savedFileName + "\r\n" + "\r\n";
                            reportGUI = exportToFile.exoprtiRoeMetzSet(reportGUI, RMGUInterface.this.SizePanelRoeMetz);
                            reportGUI = String.valueOf(reportGUI) + "\r\n************************************************************\r\n";
                            reportGUI = exportToFile.exportSummary(reportGUI, this.DB1);
                            reportGUI = exportToFile.exportStatPanel(reportGUI, this.DB1, this.StatPanelIn);
                            reportGUI = exportToFile.exportTable1(reportGUI, this.DB1);
                            reportGUI = exportToFile.exportTable2(reportGUI, this.DB1);
                        }
                        reportValidation = "AnalysisStat,AUCA,AUCB,AUCAminusAUCB,varA,varB,varAUCAminusAUCB,pValueNormal,botCInormal,topCInormal,rejectNormal,dfBDG,pValueBDG,botCIBDG,topCIBDG,rejectBDG,dfHillis,pValueHillis,botCIHillis,topCIHillis,rejectHillis\r\n";
                        reportValidation = exportToFile.exportNumValidation(reportValidation, this.DB1);
                    }
                    FileWriter fwVal = new FileWriter(fVal.getAbsoluteFile());
                    BufferedWriter bwVal = new BufferedWriter(fwVal);
                    bwVal.write(reportValidation);
                    bwVal.close();
                    if (!RoeMetz.doValidation) {
                        FileWriter fwGUI = new FileWriter(fGUI.getAbsoluteFile());
                        BufferedWriter bwGUI = new BufferedWriter(fwGUI);
                        bwGUI.write(reportGUI);
                        bwGUI.close();
                        JOptionPane.showMessageDialog(RoeMetz1.getFrame(), String.valueOf(this.analysisMethod) + " has been succeed export to " + RMGUInterface.this.outputDirectory + " !\n" + "Filename = " + savedFileName, "Exported", 1);
                    }
                }
            }
            catch (HeadlessException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }

        public analysisExportListener(DBRecord DBtemp, String tempanalysisMethod, StatPanel tempStatPanel) {
            this.DB1 = DBtemp;
            this.analysisMethod = tempanalysisMethod;
            this.StatPanelIn = tempStatPanel;
        }
    }
}

