## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  echo = TRUE,
  warning = FALSE,
  collapse = TRUE,
  comment = "#>"
)

## ----echo = FALSE, fig.cap = "Figure 1: A simple PBPK model", out.width = "50%"----
knitr::include_graphics("pbpk_basic_model_schematic.png")

## ----table1, echo=FALSE, message=FALSE, warnings=FALSE, results='asis'--------
tabl <- "
| Parameter         | Units             | Rat Value | Human Value |
|-------------------|:-----------------:|:---------:|:-----------:|
| $M$               | kg                | 0.25      | 80          |
| $Q_\\textrm{CC}$  | L/h/kg${}^{0.75}$ | 15        | 15          |
| $Q_\\textrm{LC}$  | --                | 0.21      | 0.26        |
| $Q_\\textrm{FC}$  | --                | 0.06      | 0.05        |
| $V_\\textrm{LC}$  | L/kg              | 0.04      | 0.02        |
| $V_\\textrm{FC}$  | L/kg              | 0.07      | 0.21        |
| $V_\\textrm{ABC}$ | L/kg              | 0.02      | 0.02        |
| $V_\\textrm{VBC}$ | L/kg              | 0.05      | 0.05        |
"
cat(tabl) # Output the table in a format good for HTML/PDF/docx conversion.

## ----eval = FALSE-------------------------------------------------------------
# library(MCSimMod)

## ----eval = FALSE-------------------------------------------------------------
# # Get the full name of the package directory that contains the example MCSim
# # model specification file.
# mod_path <- file.path(system.file(package = "MCSimMod"), "extdata")
# 
# # Create a model object using the example MCSim model specification file
# # "pbpk_simple.model" included in the MCSimMod package.
# pbpk_mod_name <- file.path(mod_path, "pbpk_simple")
# pbpk_mod <- createModel(pbpk_mod_name)

## ----eval = FALSE-------------------------------------------------------------
# # Load the model.
# pbpk_mod$loadModel()

## ----eval = FALSE-------------------------------------------------------------
# pbpk_mod$parms
# #>          M       Q_CC       Q_LC       Q_FC       V_LC       V_FC      V_ABC
# #>  0.2500000 15.0000000  0.2100000  0.0600000  0.0400000  0.0700000  0.0200000
# #>      V_VBC        P_L        P_F        P_R     V_maxC        K_m      k_abs
# #>  0.0500000  3.5000000 86.5000000  2.3000000 10.0000000  6.0000000  1.2500000
# #>     D_oral       D_IV        Q_C        Q_L        Q_F       Q_RC        Q_R
# #>  0.0000000  0.0000000  5.3033009  1.1136932  0.3181981  0.7300000  3.8714096
# #>        V_L        V_F       V_AB       V_VB       V_RC        V_R      V_max
# #>  0.0100000  0.0175000  0.0050000  0.0125000  0.8200000  0.2050000  3.5355339
# #>     R_oral       R_IV
# #>  0.0000000  0.0000000

## ----eval = FALSE-------------------------------------------------------------
# pbpk_mod$updateParms(c(D_oral = 1))

## ----eval = FALSE-------------------------------------------------------------
# pbpk_mod$parms
# #>           M        Q_CC        Q_LC        Q_FC        V_LC        V_FC
# #>  0.25000000 15.00000000  0.21000000  0.06000000  0.04000000  0.07000000
# #>       V_ABC       V_VBC         P_L         P_F         P_R      V_maxC
# #>  0.02000000  0.05000000  3.50000000 86.50000000  2.30000000 10.00000000
# #>         K_m       k_abs      D_oral        D_IV         Q_C         Q_L
# #>  6.00000000  1.25000000  1.00000000  0.00000000  5.30330086  1.11369318
# #>         Q_F        Q_RC         Q_R         V_L         V_F        V_AB
# #>  0.31819805  0.73000000  3.87140963  0.01000000  0.01750000  0.00500000
# #>        V_VB        V_RC         V_R       V_max      R_oral        R_IV
# #>  0.01250000  0.82000000  0.20500000  3.53553391  0.01041667  0.00000000

## ----eval = FALSE-------------------------------------------------------------
# pbpk_mod$Y0
# #>    A_G    A_L    A_F   A_AB   A_VB    A_R A_dose    A_m    AUC
# #>      0      0      0      0      0      0      0      0      0

## ----eval = FALSE-------------------------------------------------------------
# times <- seq(from = 0, to = 100, by = 0.1)

## ----eval = FALSE-------------------------------------------------------------
# out_oral <- pbpk_mod$runModel(times)

## ----eval = FALSE-------------------------------------------------------------
# plot(out_oral[, "time"], out_oral[, "A_tot"],
#   type = "l", lty = 1, lwd = 2,
#   xlab = "Time (h)", ylab = "Amount (mg)"
# )

## ----echo = FALSE, out.width = "100%"-----------------------------------------
knitr::include_graphics("amount_lost_vs_time.png")

## ----eval = FALSE-------------------------------------------------------------
# cat(
#   "Total blood flow to compartments:",
#   pbpk_mod$parms[["Q_L"]] + pbpk_mod$parms[["Q_F"]] + pbpk_mod$parms[["Q_R"]],
#   "L/h\n"
# )
# #> Total blood flow to compartments: 5.303301 L/h
# cat("Total cardiac output:", pbpk_mod$parms[["Q_C"]], "L/h\n")
# #> Total cardiac output: 5.303301 L/h

## ----eval = FALSE-------------------------------------------------------------
# plot(out_oral[, "time"], out_oral[, "C_VB"],
#   type = "l", lty = 1, lwd = 2,
#   xlab = "Time (h)", ylab = "Concentration (mg/L)"
# )

## ----echo = FALSE, out.width = "100%"-----------------------------------------
knitr::include_graphics("conc_vb_vs_time.png")

## ----eval = FALSE-------------------------------------------------------------
# plot(out_oral[, "time"], out_oral[, "C_L"],
#   type = "l", lty = 1, lwd = 2,
#   log = "y", ylim = c(0.0001, 10),
#   xlab = "Time (h)", ylab = "Concentration (mg/L)"
# )
# lines(out_oral[, "time"], out_oral[, "C_F"],
#   lty = 2, lwd = 2
# )
# lines(out_oral[, "time"], out_oral[, "C_R"],
#   lty = 3, lwd = 2
# )
# legend("bottomright",
#   legend = c("Liver", "Fat", "Rest of Body"),
#   lty = c(1, 2, 3), lwd = 2
# )

## ----echo = FALSE, out.width = "100%"-----------------------------------------
knitr::include_graphics("conc_comp_vs_time.png")

