/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble.impl;

import cern.colt.Timer;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix2D;
import cern.colt.matrix.tdcomplex.impl.DenseDComplexMatrix3D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleFactory3D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix3D;

public class BenchmarkDoubleFFT {
    private static final int[] sizes2D = new int[]{2000, 2048, 4000, 4096, 8000, 8192};
    private static final int[] sizes3D = new int[]{100, 128, 200, 256, 500, 512};
    private static int niters = 100;

    public static void benchmarkFft2() {
        Timer timer = new Timer();
        double[] dArray = new double[sizes2D.length];
        for (int i = 0; i < sizes2D.length; ++i) {
            int n;
            DenseDoubleMatrix2D denseDoubleMatrix2D = (DenseDoubleMatrix2D)DoubleFactory2D.dense.make(sizes2D[i], sizes2D[i]);
            DenseDComplexMatrix2D denseDComplexMatrix2D = denseDoubleMatrix2D.getFft2();
            denseDComplexMatrix2D = denseDoubleMatrix2D.getFft2();
            timer.reset().start();
            for (n = 0; n < niters; ++n) {
                denseDComplexMatrix2D = denseDoubleMatrix2D.getFft2();
            }
            timer.stop();
            dArray[i] = timer.millis() / (double)niters;
            n = sizes2D[i] * sizes2D[i];
            double d = 2.5 * (double)n * BenchmarkDoubleFFT.log2(n) / (double)(timer.nanos() / (long)niters);
            System.out.println("Average execution time for double precision getFft2() of size " + sizes2D[i] + " x " + sizes2D[i] + " : " + dArray[i] + " ms");
            System.out.println("Performance of double precision getFft2() of size " + sizes2D[i] + " x " + sizes2D[i] + " : " + String.format("%.4f", d) + " gflops");
        }
    }

    public static double log2(double d) {
        return Math.log10(d) / Math.log10(2.0);
    }

    public static void benchmarkFft3() {
        Timer timer = new Timer();
        double[] dArray = new double[sizes3D.length];
        for (int i = 0; i < sizes3D.length; ++i) {
            int n;
            DenseDoubleMatrix3D denseDoubleMatrix3D = (DenseDoubleMatrix3D)DoubleFactory3D.dense.make(sizes3D[i], sizes3D[i], sizes3D[i]);
            DenseDComplexMatrix3D denseDComplexMatrix3D = denseDoubleMatrix3D.getFft3();
            denseDComplexMatrix3D = denseDoubleMatrix3D.getFft3();
            timer.reset().start();
            for (n = 0; n < niters; ++n) {
                denseDComplexMatrix3D = denseDoubleMatrix3D.getFft3();
            }
            timer.stop();
            dArray[i] = timer.millis() / (double)niters;
            n = sizes3D[i] * sizes3D[i] * sizes3D[i];
            double d = 2.5 * (double)n * BenchmarkDoubleFFT.log2(n) / (double)(timer.nanos() / (long)niters);
            System.out.println("Average execution time for double precision getFft3() of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + " : " + dArray[i] + " ms");
            System.out.println("Performance of double precision getFft3() of size " + sizes3D[i] + " x " + sizes3D[i] + " x " + sizes3D[i] + " : " + String.format("%.4f", d) + " gflops");
        }
    }

    public static void main(String[] stringArray) {
        BenchmarkDoubleFFT.benchmarkFft2();
        BenchmarkDoubleFFT.benchmarkFft3();
    }
}

