/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.evolution.datatype.DataType;
import java.text.NumberFormat;

public class SubstitutionModelUtils {
    public static String toString(double[] dArray, DataType dataType, boolean bl, int n) {
        int n2 = dataType.getStateCount();
        int n3 = n2 * n2;
        if (bl) {
            n3 = n2 * n2 / 2 - n2;
        }
        assert (dArray.length == n3);
        double[][] dArray2 = new double[n2][n2];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5;
            int n6 = n5 = bl ? i + 1 : 0;
            while (n5 < n2) {
                dArray2[i][n5] = dArray[n4];
                if (bl) {
                    dArray2[n5][i] = dArray[n4];
                }
                ++n4;
                ++n5;
            }
        }
        return SubstitutionModelUtils.toString(dArray2, dataType, n);
    }

    public static String frequenciesToString(double[] dArray, DataType dataType, int n) {
        int n2 = dArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SubstitutionModelUtils.header(dataType, n, 7));
        stringBuilder.append("\n");
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(3);
        stringBuilder.append(SubstitutionModelUtils.spaces(n));
        stringBuilder.append("  {");
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(SubstitutionModelUtils.padded(numberFormat.format(dArray[i]), 7));
        }
        stringBuilder.append("}\n");
        return stringBuilder.toString();
    }

    public static String toString(double[][] dArray, DataType dataType, int n) {
        int n2 = dArray.length;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SubstitutionModelUtils.header(dataType, n, 7));
        stringBuilder.append("\n");
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(3);
        for (int i = 0; i < n2; ++i) {
            stringBuilder.append(SubstitutionModelUtils.spaces(n));
            stringBuilder.append(dataType.getChar(i)).append(" ");
            if (i == 0) {
                stringBuilder.append("/");
            } else if (i == n2 - 1) {
                stringBuilder.append("\\");
            } else {
                stringBuilder.append("|");
            }
            for (int j = 0; j < n2; ++j) {
                stringBuilder.append(SubstitutionModelUtils.padded(numberFormat.format(dArray[i][j]), 7));
            }
            if (i == 0) {
                stringBuilder.append("\\\n");
                continue;
            }
            if (i == n2 - 1) {
                stringBuilder.append("/\n");
                continue;
            }
            stringBuilder.append("|\n");
        }
        return stringBuilder.toString();
    }

    private static String spaces(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    private static String padded(String string, int n) {
        int n2;
        int n3 = n - string.length();
        for (n2 = 0; n2 < n3 / 2; ++n2) {
            string = " " + string;
        }
        n3 = n - string.length();
        for (n2 = 0; n2 < n3; ++n2) {
            string = string + " ";
        }
        return string;
    }

    private static String header(DataType dataType, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(SubstitutionModelUtils.spaces(n)).append("   ");
        for (int i = 0; i < dataType.getStateCount(); ++i) {
            stringBuilder.append(SubstitutionModelUtils.padded(dataType.getChar(i) + "", n2));
        }
        return stringBuilder.toString();
    }
}

