/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.inference.model.Parameter;

public interface TreeChangedEvent {
    public int getIndex();

    public NodeRef getNode();

    public Parameter getParameter();

    public boolean isNodeChanged();

    public boolean isTreeChanged();

    public boolean isNodeOrderChanged();

    public boolean isNodeParameterChanged();

    public boolean isHeightChanged();

    public boolean isOnlyHeightChanged();

    public static TreeChangedEvent create() {
        return new TreeChangedEvent(){

            @Override
            public int getIndex() {
                return -1;
            }

            @Override
            public NodeRef getNode() {
                return null;
            }

            @Override
            public Parameter getParameter() {
                return null;
            }

            @Override
            public boolean isNodeOrderChanged() {
                return true;
            }

            @Override
            public boolean isNodeChanged() {
                return false;
            }

            @Override
            public boolean isTreeChanged() {
                return true;
            }

            @Override
            public boolean isNodeParameterChanged() {
                return false;
            }

            @Override
            public boolean isHeightChanged() {
                return false;
            }

            @Override
            public boolean isOnlyHeightChanged() {
                return false;
            }
        };
    }

    public static TreeChangedEvent create(final boolean bl, final boolean bl2) {
        return new TreeChangedEvent(){

            @Override
            public int getIndex() {
                return -1;
            }

            @Override
            public NodeRef getNode() {
                return null;
            }

            @Override
            public Parameter getParameter() {
                return null;
            }

            @Override
            public boolean isNodeChanged() {
                return false;
            }

            @Override
            public boolean isNodeOrderChanged() {
                return bl;
            }

            @Override
            public boolean isTreeChanged() {
                return true;
            }

            @Override
            public boolean isNodeParameterChanged() {
                return false;
            }

            @Override
            public boolean isHeightChanged() {
                return bl2;
            }

            @Override
            public boolean isOnlyHeightChanged() {
                return false;
            }
        };
    }

    public static TreeChangedEvent create(final NodeRef nodeRef, final boolean bl) {
        return new TreeChangedEvent(){

            @Override
            public int getIndex() {
                return -1;
            }

            @Override
            public NodeRef getNode() {
                return nodeRef;
            }

            @Override
            public Parameter getParameter() {
                return null;
            }

            @Override
            public boolean isNodeChanged() {
                return true;
            }

            @Override
            public boolean isTreeChanged() {
                return true;
            }

            @Override
            public boolean isNodeOrderChanged() {
                return bl;
            }

            @Override
            public boolean isNodeParameterChanged() {
                return false;
            }

            @Override
            public boolean isHeightChanged() {
                return bl;
            }

            @Override
            public boolean isOnlyHeightChanged() {
                return false;
            }
        };
    }

    public static TreeChangedEvent create(final NodeRef nodeRef, final Parameter parameter, final boolean bl) {
        return new TreeChangedEvent(){

            @Override
            public int getIndex() {
                return -1;
            }

            @Override
            public NodeRef getNode() {
                return nodeRef;
            }

            @Override
            public Parameter getParameter() {
                return parameter;
            }

            @Override
            public boolean isNodeChanged() {
                return true;
            }

            @Override
            public boolean isTreeChanged() {
                return true;
            }

            @Override
            public boolean isNodeOrderChanged() {
                return bl;
            }

            @Override
            public boolean isNodeParameterChanged() {
                return true;
            }

            @Override
            public boolean isHeightChanged() {
                return bl;
            }

            @Override
            public boolean isOnlyHeightChanged() {
                return false;
            }
        };
    }

    public static TreeChangedEvent create(final NodeRef nodeRef, final Parameter parameter, final int n, final boolean bl) {
        return new TreeChangedEvent(){

            @Override
            public int getIndex() {
                return n;
            }

            @Override
            public NodeRef getNode() {
                return nodeRef;
            }

            @Override
            public Parameter getParameter() {
                return parameter;
            }

            @Override
            public boolean isNodeChanged() {
                return true;
            }

            @Override
            public boolean isTreeChanged() {
                return true;
            }

            @Override
            public boolean isNodeOrderChanged() {
                return bl;
            }

            @Override
            public boolean isNodeParameterChanged() {
                return true;
            }

            @Override
            public boolean isHeightChanged() {
                return bl;
            }

            @Override
            public boolean isOnlyHeightChanged() {
                return bl;
            }
        };
    }

    public static class NodeOnTree
    implements TreeChangedEvent {
        private final NodeRef node;

        NodeOnTree(NodeRef nodeRef) {
            this.node = nodeRef;
        }

        @Override
        public int getIndex() {
            return -1;
        }

        @Override
        public NodeRef getNode() {
            return this.node;
        }

        @Override
        public Parameter getParameter() {
            return null;
        }

        @Override
        public boolean isNodeChanged() {
            return true;
        }

        @Override
        public boolean isNodeOrderChanged() {
            return true;
        }

        @Override
        public boolean isTreeChanged() {
            return false;
        }

        @Override
        public boolean isNodeParameterChanged() {
            return false;
        }

        @Override
        public boolean isHeightChanged() {
            return false;
        }

        @Override
        public boolean isOnlyHeightChanged() {
            return false;
        }
    }

    public static class WholeTree
    implements TreeChangedEvent {
        @Override
        public int getIndex() {
            return -1;
        }

        @Override
        public NodeRef getNode() {
            return null;
        }

        @Override
        public Parameter getParameter() {
            return null;
        }

        @Override
        public boolean isNodeChanged() {
            return false;
        }

        @Override
        public boolean isNodeOrderChanged() {
            return true;
        }

        @Override
        public boolean isTreeChanged() {
            return true;
        }

        @Override
        public boolean isNodeParameterChanged() {
            return false;
        }

        @Override
        public boolean isHeightChanged() {
            return false;
        }

        @Override
        public boolean isOnlyHeightChanged() {
            return false;
        }
    }
}

