/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel.aminoacid;

import dr.evolution.datatype.AminoAcids;
import dr.evomodel.substmodel.EmpiricalRateMatrix;
import dr.util.Author;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class Blosum62
extends EmpiricalRateMatrix.AbstractAminoAcid {
    public static final Blosum62 INSTANCE = new Blosum62();
    public static Citation CITATION = new Citation(new Author[]{new Author("S", "Henikoff"), new Author("JG", "Henikoff")}, "Amino acid substitution matrices from protein blocks", 1992, "Proc Natl Acad Sci, USA", 89, 10915, 10919, Citation.Status.PUBLISHED);

    private Blosum62() {
        super("blosum62");
        int n = AminoAcids.INSTANCE.getStateCount();
        double[][] dArray = new double[n][n];
        dArray[0][1] = 0.73579038969751;
        dArray[0][2] = 0.48539105546575;
        dArray[0][3] = 0.54316182089867;
        dArray[0][4] = 1.45999531047;
        dArray[0][5] = 1.199705704602;
        dArray[0][6] = 1.1709490427999;
        dArray[0][7] = 1.9558835749595;
        dArray[0][8] = 0.71624144499779;
        dArray[0][9] = 0.60589900368677;
        dArray[0][10] = 0.80001653051838;
        dArray[0][11] = 1.2952012667833;
        dArray[0][12] = 1.2537582666635;
        dArray[0][13] = 0.49296467974759;
        dArray[0][14] = 1.1732759009239;
        dArray[0][15] = 4.3250926870566;
        dArray[0][16] = 1.729178019485;
        dArray[0][17] = 0.46583936772479;
        dArray[0][18] = 0.71820669758623;
        dArray[0][19] = 2.1877745220045;
        dArray[1][2] = 1.2974467051337;
        dArray[1][3] = 0.50096440855513;
        dArray[1][4] = 0.22782657420895;
        dArray[1][5] = 3.0208336100636;
        dArray[1][6] = 1.3605741904203;
        dArray[1][7] = 0.41876330851753;
        dArray[1][8] = 1.456141166336;
        dArray[1][9] = 0.23203644514174;
        dArray[1][10] = 0.62271166969249;
        dArray[1][11] = 5.4111151414889;
        dArray[1][12] = 0.98369298745695;
        dArray[1][13] = 0.37164469320875;
        dArray[1][14] = 0.44813366171831;
        dArray[1][15] = 1.1227831042096;
        dArray[1][16] = 0.91466595456337;
        dArray[1][17] = 0.42638231012175;
        dArray[1][18] = 0.72051744121611;
        dArray[1][19] = 0.43838834377202;
        dArray[2][3] = 3.1801000482161;
        dArray[2][4] = 0.39735894989702;
        dArray[2][5] = 1.839216146992;
        dArray[2][6] = 1.2404885086396;
        dArray[2][7] = 1.3558723444845;
        dArray[2][8] = 2.4145014342081;
        dArray[2][9] = 0.283017326278;
        dArray[2][10] = 0.21188815961519;
        dArray[2][11] = 1.5931370434574;
        dArray[2][12] = 0.64844127878707;
        dArray[2][13] = 0.35486124922252;
        dArray[2][14] = 0.49488704370192;
        dArray[2][15] = 2.904101656456;
        dArray[2][16] = 1.8981736345332;
        dArray[2][17] = 0.19148204624678;
        dArray[2][18] = 0.53822251903674;
        dArray[2][19] = 0.31285879799342;
        dArray[3][4] = 0.24083661480204;
        dArray[3][5] = 1.190945703396;
        dArray[3][6] = 3.7616252083685;
        dArray[3][7] = 0.79847324896839;
        dArray[3][8] = 0.77814266402188;
        dArray[3][9] = 0.41855573246161;
        dArray[3][10] = 0.2181315775936;
        dArray[3][11] = 1.0324479249521;
        dArray[3][12] = 0.22262189795786;
        dArray[3][13] = 0.28173069420651;
        dArray[3][14] = 0.73062827299842;
        dArray[3][15] = 1.5827541420653;
        dArray[3][16] = 0.93418750943056;
        dArray[3][17] = 0.14534504627853;
        dArray[3][18] = 0.26142220896504;
        dArray[3][19] = 0.25812928941763;
        dArray[4][5] = 0.32980150463028;
        dArray[4][6] = 0.1407488918144;
        dArray[4][7] = 0.41820319228376;
        dArray[4][8] = 0.35405810983129;
        dArray[4][9] = 0.77489402279418;
        dArray[4][10] = 0.83184264014158;
        dArray[4][11] = 0.28507880090648;
        dArray[4][12] = 0.76768882347954;
        dArray[4][13] = 0.4413374711866;
        dArray[4][14] = 0.35600849876863;
        dArray[4][15] = 1.1971884150942;
        dArray[4][16] = 1.119831358516;
        dArray[4][17] = 0.52766441887169;
        dArray[4][18] = 0.4702377336961;
        dArray[4][19] = 1.1163524786062;
        dArray[5][6] = 5.5289191779282;
        dArray[5][7] = 0.60984630538281;
        dArray[5][8] = 2.4353411311401;
        dArray[5][9] = 0.23620245120365;
        dArray[5][10] = 0.58073709318144;
        dArray[5][11] = 3.9452776745146;
        dArray[5][12] = 2.4948960771127;
        dArray[5][13] = 0.14435695975031;
        dArray[5][14] = 0.85857057567418;
        dArray[5][15] = 1.9348709245965;
        dArray[5][16] = 1.2774802945956;
        dArray[5][17] = 0.75865380864172;
        dArray[5][18] = 0.95898974285014;
        dArray[5][19] = 0.53078579012486;
        dArray[6][7] = 0.42357999217628;
        dArray[6][8] = 1.6268910569817;
        dArray[6][9] = 0.1868480469317;
        dArray[6][10] = 0.37262517508685;
        dArray[6][11] = 2.8024271516787;
        dArray[6][12] = 0.55541539747043;
        dArray[6][13] = 0.2914090841653;
        dArray[6][14] = 0.92656393484598;
        dArray[6][15] = 1.7698932389373;
        dArray[6][16] = 1.0710972360073;
        dArray[6][17] = 0.4076356489383;
        dArray[6][18] = 0.59671930034577;
        dArray[6][19] = 0.52425384633796;
        dArray[7][8] = 0.53985912495418;
        dArray[7][9] = 0.18929629237636;
        dArray[7][10] = 0.21772115923623;
        dArray[7][11] = 0.75204244030271;
        dArray[7][12] = 0.45943617357855;
        dArray[7][13] = 0.36816646445253;
        dArray[7][14] = 0.50408659952683;
        dArray[7][15] = 1.5093262532236;
        dArray[7][16] = 0.64143601140497;
        dArray[7][17] = 0.50835892463812;
        dArray[7][18] = 0.308055737035;
        dArray[7][19] = 0.25334079019018;
        dArray[8][9] = 0.25271844788492;
        dArray[8][10] = 0.34807220979697;
        dArray[8][11] = 1.022507035889;
        dArray[8][12] = 0.9843115253587;
        dArray[8][13] = 0.71453370392764;
        dArray[8][14] = 0.5270073391506;
        dArray[8][15] = 1.1170297629105;
        dArray[8][16] = 0.58540709022472;
        dArray[8][17] = 0.30124860078016;
        dArray[8][18] = 4.218953969389;
        dArray[8][19] = 0.20155597175031;
        dArray[9][10] = 3.8909637733035;
        dArray[9][11] = 0.40619358664202;
        dArray[9][12] = 3.3647977631042;
        dArray[9][13] = 1.5173593259539;
        dArray[9][14] = 0.38835540920564;
        dArray[9][15] = 0.35754441245967;
        dArray[9][16] = 1.1790911972601;
        dArray[9][17] = 0.34198578754023;
        dArray[9][18] = 0.67461709322842;
        dArray[9][19] = 8.3118394054582;
        dArray[10][11] = 0.44557027426059;
        dArray[10][12] = 6.0305593795716;
        dArray[10][13] = 2.0648397032375;
        dArray[10][14] = 0.37455568747097;
        dArray[10][15] = 0.35296918452729;
        dArray[10][16] = 0.91525985769421;
        dArray[10][17] = 0.69147463459998;
        dArray[10][18] = 0.81124585632307;
        dArray[10][19] = 2.2314056889131;
        dArray[11][12] = 1.0730611843319;
        dArray[11][13] = 0.26692475051102;
        dArray[11][14] = 1.0473834507215;
        dArray[11][15] = 1.7521659178195;
        dArray[11][16] = 1.3038752007987;
        dArray[11][17] = 0.33224304063396;
        dArray[11][18] = 0.71799348690032;
        dArray[11][19] = 0.49813847530407;
        dArray[12][13] = 1.7738551688305;
        dArray[12][14] = 0.45412362510273;
        dArray[12][15] = 0.91872341574605;
        dArray[12][16] = 1.4885480537218;
        dArray[12][17] = 0.88810109815193;
        dArray[12][18] = 0.95168216224591;
        dArray[12][19] = 2.5758507553153;
        dArray[13][14] = 0.23359790962888;
        dArray[13][15] = 0.54002764482413;
        dArray[13][16] = 0.48820611879305;
        dArray[13][17] = 2.0743248934965;
        dArray[13][18] = 6.7472604308008;
        dArray[13][19] = 0.83811961017754;
        dArray[14][15] = 1.1691295777157;
        dArray[14][16] = 1.0054516831488;
        dArray[14][17] = 0.25221483002727;
        dArray[14][18] = 0.36940531935451;
        dArray[14][19] = 0.49690841067567;
        dArray[15][16] = 5.1515562922704;
        dArray[15][17] = 0.38792562209837;
        dArray[15][18] = 0.79675152076106;
        dArray[15][19] = 0.56192545744165;
        dArray[16][17] = 0.51312812689059;
        dArray[16][18] = 0.80101024319939;
        dArray[16][19] = 2.2530740511763;
        dArray[17][18] = 4.054419006558;
        dArray[17][19] = 0.26650873142646;
        dArray[18][19] = 1.0;
        this.setEmpiricalRates(dArray, "ARNDCQEGHILKMFPSTWYV");
        double[] dArray2 = new double[n];
        dArray2[0] = 0.074;
        dArray2[1] = 0.052;
        dArray2[2] = 0.045;
        dArray2[3] = 0.054;
        dArray2[4] = 0.025;
        dArray2[5] = 0.034;
        dArray2[6] = 0.054;
        dArray2[7] = 0.074;
        dArray2[8] = 0.026;
        dArray2[9] = 0.068;
        dArray2[10] = 0.099;
        dArray2[11] = 0.058;
        dArray2[12] = 0.025;
        dArray2[13] = 0.047;
        dArray2[14] = 0.039;
        dArray2[15] = 0.057;
        dArray2[16] = 0.051;
        dArray2[17] = 0.013;
        dArray2[18] = 0.032;
        dArray2[19] = 0.073;
        this.setEmpiricalFrequencies(dArray2, "ARNDCQEGHILKMFPSTWYV");
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "Blosum62 amino acid substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

