/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.continuous;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evomodel.treedatalikelihood.DataLikelihoodDelegate;
import dr.evomodel.treedatalikelihood.TreeDataLikelihood;
import dr.evomodel.treedatalikelihood.continuous.ContinuousDataLikelihoodDelegate;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;

public class GibbsSampleMissingTraitsOperator
extends SimpleMCMCOperator {
    private static final String PARTIAL = "partial";
    private final TreeDataLikelihood treeLikelihood;
    private final TreeTrait treeTrait;
    private final Parameter parameter;
    private final Parameter missing;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{AttributeRule.newDoubleRule("weight"), new ElementRule(TreeDataLikelihood.class), new ElementRule(Parameter.class), new ElementRule("missingIndicator", new XMLSyntaxRule[]{new ElementRule(Parameter.class)}), AttributeRule.newStringRule("traitName", true)};

        @Override
        public String getParserName() {
            return GibbsSampleMissingTraitsOperator.OPERATOR_NAME;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            double d = xMLObject.getDoubleAttribute("weight");
            TreeDataLikelihood treeDataLikelihood = (TreeDataLikelihood)xMLObject.getChild(TreeDataLikelihood.class);
            TreeTrait treeTrait = GibbsSampleMissingTraitsOperator.parseTreeTrait(xMLObject, GibbsSampleMissingTraitsOperator.PARTIAL);
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            Parameter parameter2 = (Parameter)xMLObject.getElementFirstChild("missingIndicator");
            if (parameter.getDimension() != parameter2.getDimension()) {
                throw new XMLParseException("Unequal parameter lengths");
            }
            GibbsSampleMissingTraitsOperator gibbsSampleMissingTraitsOperator = new GibbsSampleMissingTraitsOperator(treeDataLikelihood, treeTrait, parameter, parameter2);
            gibbsSampleMissingTraitsOperator.setWeight(d);
            return gibbsSampleMissingTraitsOperator;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public String getParserDescription() {
            return "This element returns an independence coalescent sampler from a demographic model.";
        }

        @Override
        public Class getReturnType() {
            return GibbsSampleMissingTraitsOperator.class;
        }
    };
    public static final String OPERATOR_NAME = "gibbsSampleMissingTraitsOperator";

    public GibbsSampleMissingTraitsOperator(TreeDataLikelihood treeDataLikelihood, TreeTrait treeTrait, Parameter parameter, Parameter parameter2) {
        this.treeLikelihood = treeDataLikelihood;
        this.treeTrait = treeTrait;
        this.parameter = parameter;
        this.missing = parameter2;
    }

    @Override
    public double doOperation() {
        Tree tree = this.treeLikelihood.getTree();
        for (int i = 0; i < tree.getExternalNodeCount(); ++i) {
            NodeRef nodeRef = tree.getExternalNode(i);
            this.treeTrait.getTrait(tree, nodeRef);
        }
        double[] dArray = (double[])this.treeTrait.getTrait(tree, null);
        assert (dArray.length == this.parameter.getDimension());
        for (int i = 0; i < this.parameter.getDimension(); ++i) {
            boolean bl;
            boolean bl2 = bl = this.missing.getParameterValue(i) == 1.0;
            if (!bl) continue;
            this.parameter.setParameterValue(i, dArray[i]);
        }
        return 0.0;
    }

    @Override
    public String getOperatorName() {
        return "gibbsSampleMissingTraitsOperator(TODO)";
    }

    public static ContinuousDataLikelihoodDelegate parseContinuousDataLikelihoodDelegate(XMLObject xMLObject) throws XMLParseException {
        TreeDataLikelihood treeDataLikelihood = (TreeDataLikelihood)xMLObject.getChild(TreeDataLikelihood.class);
        DataLikelihoodDelegate dataLikelihoodDelegate = treeDataLikelihood.getDataLikelihoodDelegate();
        if (!(dataLikelihoodDelegate instanceof ContinuousDataLikelihoodDelegate)) {
            throw new XMLParseException("Only implemented for multivariate trait diffusion models");
        }
        return (ContinuousDataLikelihoodDelegate)dataLikelihoodDelegate;
    }

    private static TreeTrait parseTreeTrait(XMLObject xMLObject, String string) throws XMLParseException {
        Object object;
        TreeDataLikelihood treeDataLikelihood = (TreeDataLikelihood)xMLObject.getChild(TreeDataLikelihood.class);
        String string2 = null;
        if (xMLObject.hasAttribute("traitName")) {
            string2 = (String)xMLObject.getAttribute("traitName");
        } else {
            object = treeDataLikelihood.getTreeTraits();
            List<String> list = GibbsSampleMissingTraitsOperator.matchedTraitNames(object, string + ".");
            if (list.size() == 1) {
                string2 = list.get(0);
            }
        }
        object = treeDataLikelihood.getTreeTrait(string2);
        if (object == null) {
            throw new XMLParseException("Unknown partially observed tree trait");
        }
        return object;
    }

    private static List<String> matchedTraitNames(TreeTrait[] treeTraitArray, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (TreeTrait treeTrait : treeTraitArray) {
            if (!treeTrait.getTraitName().startsWith(string)) continue;
            arrayList.add(treeTrait.getTraitName());
        }
        return arrayList;
    }
}

