/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.util;

public class QR {
    int numRows;
    int numCols;
    double[][] Q;
    double[][] R;

    public QR(double[][] m) {
        this.Q = m;
        this.numRows = this.Q.length;
        if (this.numRows == 0) {
            this.R = null;
            return;
        }
        this.numCols = this.Q[0].length;
        this.R = new double[this.numCols][this.numCols];
        for (int col = 0; col < this.numCols; ++col) {
            int row;
            double innerProduct = 0.0;
            for (row = 0; row < this.numRows; ++row) {
                innerProduct += this.Q[row][col] * this.Q[row][col];
            }
            this.R[col][col] = Math.sqrt(innerProduct);
            double normalizer = 1.0 / this.R[col][col];
            for (row = 0; row < this.numRows; ++row) {
                double[] dArray = this.Q[row];
                int n = col;
                dArray[n] = dArray[n] * normalizer;
            }
            for (int otherCol = col + 1; otherCol < this.numCols; ++otherCol) {
                int row2;
                innerProduct = 0.0;
                for (row2 = 0; row2 < this.numRows; ++row2) {
                    innerProduct += this.Q[row2][col] * this.Q[row2][otherCol];
                }
                this.R[col][otherCol] = innerProduct;
                for (row2 = 0; row2 < this.numRows; ++row2) {
                    double[] dArray = this.Q[row2];
                    int n = otherCol;
                    dArray[n] = dArray[n] - this.Q[row2][col] * innerProduct;
                }
            }
        }
    }

    public double[][] getQ() {
        return this.Q;
    }

    public double[][] getR() {
        return this.R;
    }
}

