/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.fst.confidence;

import cc.mallet.fst.MaxLatticeDefault;
import cc.mallet.fst.SumLatticeDefault;
import cc.mallet.fst.Transducer;
import cc.mallet.fst.confidence.TransducerSequenceConfidenceEstimator;
import cc.mallet.types.Instance;
import cc.mallet.types.Sequence;
import cc.mallet.types.SequencePairAlignment;
import cc.mallet.util.MalletLogger;
import java.util.List;
import java.util.logging.Logger;

public class ViterbiRatioConfidenceEstimator
extends TransducerSequenceConfidenceEstimator {
    private static Logger logger = MalletLogger.getLogger(ViterbiRatioConfidenceEstimator.class.getName());

    public ViterbiRatioConfidenceEstimator(Transducer model) {
        super(model);
    }

    @Override
    public double estimateConfidenceFor(Instance instance, Object[] startTags, Object[] inTags) {
        SumLatticeDefault lattice = new SumLatticeDefault(this.model, (Sequence)instance.getData());
        MaxLatticeDefault vlat = new MaxLatticeDefault(this.model, (Sequence)instance.getData(), null, 2);
        List<SequencePairAlignment<Object, Object>> alignments = vlat.bestOutputAlignments(2);
        double cost1 = alignments.get(0).getWeight();
        double cost2 = alignments.get(1).getWeight();
        double latticeCost = lattice.getTotalWeight();
        return Math.exp(-cost1 + latticeCost) / Math.exp(-cost2 + latticeCost);
    }
}

