/*
 * Decompiled with CFR 0.152.
 */
package cc.mallet.cluster.neighbor_evaluator;

import cc.mallet.classify.Classifier;
import cc.mallet.cluster.neighbor_evaluator.Neighbor;
import cc.mallet.cluster.neighbor_evaluator.NeighborEvaluator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ClassifyingNeighborEvaluator
implements NeighborEvaluator,
Serializable {
    Classifier classifier;
    String scoringLabel;
    private static final long serialVersionUID = 1L;
    private static final int CURRENT_SERIAL_VERSION = 1;

    public ClassifyingNeighborEvaluator(Classifier classifier, String scoringLabel) {
        this.classifier = classifier;
        this.scoringLabel = scoringLabel;
    }

    public Classifier getClassifier() {
        return this.classifier;
    }

    @Override
    public double evaluate(Neighbor neighbor) {
        return this.classifier.classify(neighbor).getLabelVector().value(this.scoringLabel);
    }

    @Override
    public double[] evaluate(Neighbor[] neighbors) {
        double[] scores = new double[neighbors.length];
        for (int i = 0; i < neighbors.length; ++i) {
            scores[i] = this.evaluate(neighbors[i]);
        }
        return scores;
    }

    @Override
    public void reset() {
    }

    public String toString() {
        return "class=" + this.getClass().getName() + " classifier=" + this.classifier.getClass().getName() + " scoringLabel=" + this.scoringLabel;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(1);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int version = in.readInt();
    }
}

