/*
 * Decompiled with CFR 0.152.
 */
package org.act.rscat.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public interface ContentTable {
    public static RowOriented rowOriented(List<String> columnNames, List<List<String>> rows) {
        return new RowOriented(columnNames, rows);
    }

    public static RowOriented rowOriented() {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        return new RowOriented(new ArrayList<String>(), rows);
    }

    public static ColumnOriented columnOriented(List<String> columnNames, List<List<String>> columns) {
        return new ColumnOriented(columnNames, columns);
    }

    public static ColumnOriented columnOriented() {
        ArrayList columns = new ArrayList();
        return new ColumnOriented(new ArrayList(), columns);
    }

    public RowOriented orientByRows();

    public ColumnOriented orientByColumns();

    public List<String> columnNames();

    public int columnIndex(String var1);

    public int rowCount();

    public List<List<String>> rows();

    public List<List<String>> columns();

    public Orientation orientedBy();

    public static <T> List<List<T>> transpose(List<List<T>> values) {
        int innerLength = values.size();
        int outerLength = values.isEmpty() ? 0 : values.get(0).size();
        ArrayList<List<T>> reoriented = new ArrayList<List<T>>(outerLength);
        for (int i = 0; i < outerLength; ++i) {
            ArrayList<T> list = new ArrayList<T>(innerLength);
            for (int j = 0; j < innerLength; ++j) {
                list.add(values.get(j).get(i));
            }
            reoriented.add(list);
        }
        return reoriented;
    }

    public static class ColumnOriented
    implements ContentTable {
        private final List<String> columnNames;
        private final List<List<String>> columns;

        private ColumnOriented(List<String> columnNames, List<List<String>> columns) {
            this.columnNames = Collections.unmodifiableList(columnNames);
            this.columns = columns.stream().map(Collections::unmodifiableList).collect(Collectors.toList());
        }

        @Override
        public RowOriented orientByRows() {
            List<List<String>> rows = ContentTable.transpose(this.columns);
            return ContentTable.rowOriented(this.columnNames, rows);
        }

        @Override
        public ColumnOriented orientByColumns() {
            return this;
        }

        @Override
        public List<String> columnNames() {
            return this.columnNames;
        }

        @Override
        public int columnIndex(String columnName) {
            return this.columnNames.indexOf(columnName);
        }

        @Override
        public int rowCount() {
            return this.columns.isEmpty() ? 0 : this.columns.get(0).size();
        }

        @Override
        public List<List<String>> rows() {
            return this.orientByRows().rows();
        }

        @Override
        public List<List<String>> columns() {
            return this.columns;
        }

        @Override
        public Orientation orientedBy() {
            return Orientation.BY_COLUMN;
        }

        public List<String> columnValues(int index) {
            return this.columns.get(index);
        }

        public List<String> columnValues(String columnName) {
            int column = this.columnNames.indexOf(columnName);
            if (column == -1) {
                throw new IllegalArgumentException("No column available with name " + columnName);
            }
            return this.columnValues(column);
        }
    }

    public static class RowOriented
    implements ContentTable {
        private final List<String> columnNames;
        private final List<List<String>> rows;

        public RowOriented(List<String> columnNames, List<List<String>> rows) {
            this.columnNames = Collections.unmodifiableList(columnNames);
            this.rows = rows.stream().map(Collections::unmodifiableList).collect(Collectors.toList());
        }

        public List<String> getColumnNames() {
            return this.columnNames;
        }

        @Override
        public RowOriented orientByRows() {
            return this;
        }

        @Override
        public ColumnOriented orientByColumns() {
            List<List<String>> columns = ContentTable.transpose(this.rows);
            return ContentTable.columnOriented(this.columnNames, columns);
        }

        @Override
        public List<String> columnNames() {
            return this.columnNames;
        }

        @Override
        public int columnIndex(String columnName) {
            return this.columnNames.indexOf(columnName);
        }

        @Override
        public int rowCount() {
            return this.rows.size();
        }

        public void sort(String sortingColumn) {
            int index = this.columnNames.indexOf(sortingColumn);
            Collections.sort(this.rows, (row1, row2) -> ((String)row1.get(index)).compareTo((String)row2.get(index)));
        }

        @Override
        public List<List<String>> rows() {
            return this.rows;
        }

        @Override
        public List<List<String>> columns() {
            return this.orientByColumns().columns();
        }

        @Override
        public Orientation orientedBy() {
            return Orientation.BY_ROW;
        }

        public List<String> rowValues(int index) {
            return this.rows.get(index);
        }
    }

    public static enum Orientation {
        BY_ROW,
        BY_COLUMN;

    }
}

