/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import jdplus.toolkit.base.api.data.HasEmptyCause;
import jdplus.toolkit.base.api.data.Seq;
import jdplus.toolkit.base.api.timeseries.Ts;
import jdplus.toolkit.base.api.timeseries.TsDataTable;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsFactory;
import jdplus.toolkit.base.api.timeseries.TsInformationType;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.api.util.Collections2;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TsCollection
implements Seq<Ts>,
HasEmptyCause {
    @NonNull
    private final TsMoniker moniker;
    @NonNull
    private final TsInformationType type;
    @NonNull
    private final String name;
    private final Map<String, String> meta;
    private final List<Ts> items;
    private final @Nullable String emptyCause;
    @NonNull
    private final AtomicReference<Object> domain = new AtomicReference();
    public static final TsCollection EMPTY = TsCollection.builder().build();

    public static Builder builder() {
        return new Builder().moniker(TsMoniker.NULL).type(TsInformationType.UserDefined).name("");
    }

    @NonNull
    public static TsCollection of(@NonNull Iterable<Ts> items) {
        if (items == null) {
            throw new NullPointerException("items is marked non-null but is null");
        }
        Builder result = TsCollection.builder();
        items.forEach(result::item);
        return result.build();
    }

    @NonNull
    public static TsCollection of(@NonNull Ts item) {
        Objects.requireNonNull(item);
        return TsCollection.builder().item(item).build();
    }

    @NonNull
    public static TsCollection ofName(@NonNull String name) {
        Objects.requireNonNull(name);
        return TsCollection.builder().name(name).build();
    }

    @NonNull
    public static Collector<Ts, ?, TsCollection> toTsCollection() {
        return Collectors.collectingAndThen(Collectors.toList(), TsCollection::of);
    }

    @Override
    public int length() {
        return this.items.size();
    }

    @Override
    public Ts get(int index) throws IndexOutOfBoundsException {
        return this.items.get(index);
    }

    @Override
    public @Nullable String getEmptyCause() {
        return this.emptyCause;
    }

    @NonNull
    public TsCollection load(@NonNull TsInformationType info, @NonNull TsFactory factory) {
        Objects.requireNonNull(info);
        Objects.requireNonNull(factory);
        if (!this.moniker.isProvided()) {
            return this.stream().map(ts -> ts.load(info, factory)).collect(TsCollection.toTsCollection());
        }
        if (this.type.encompass(info)) {
            return this;
        }
        return factory.makeTsCollection(this.moniker, info);
    }

    @NonNull
    public TsCollection replaceAll(@NonNull Iterable<Ts> col) {
        if (col == null) {
            throw new NullPointerException("col is marked non-null but is null");
        }
        Map tsByMoniker = Collections2.streamOf(col).collect(Collectors.toMap(Ts::getMoniker, Function.identity()));
        Builder result = TsCollection.builder().moniker(this.getMoniker());
        boolean modified = false;
        for (Ts original : this) {
            Ts replaced = (Ts)tsByMoniker.get(original.getMoniker());
            if (replaced != null) {
                modified = true;
                result.item(replaced);
                continue;
            }
            result.item(original);
        }
        return modified ? result.build() : this;
    }

    private static TsDomain initDomain(List<Ts> items) {
        return TsDataTable.computeDomain(items.stream().map(ts -> ts.getData().getDomain()).filter(domain -> !domain.isEmpty()).iterator());
    }

    @Generated
    TsCollection(@NonNull TsMoniker moniker, @NonNull TsInformationType type, @NonNull String name, Map<String, String> meta, List<Ts> items, @Nullable String emptyCause) {
        if (moniker == null) {
            throw new NullPointerException("moniker is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.moniker = moniker;
        this.type = type;
        this.name = name;
        this.meta = meta;
        this.items = items;
        this.emptyCause = emptyCause;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        Builder builder = new Builder().moniker(this.moniker).type(this.type).name(this.name).emptyCause(this.emptyCause);
        if (this.meta != null) {
            builder.meta(this.meta);
        }
        if (this.items != null) {
            builder.items(this.items);
        }
        return builder;
    }

    @NonNull
    @Generated
    public TsMoniker getMoniker() {
        return this.moniker;
    }

    @NonNull
    @Generated
    public TsInformationType getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, String> getMeta() {
        return this.meta;
    }

    @Generated
    public List<Ts> getItems() {
        return this.items;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "TsCollection(moniker=" + String.valueOf(this.getMoniker()) + ", type=" + String.valueOf((Object)this.getType()) + ", name=" + this.getName() + ", meta=" + String.valueOf(this.getMeta()) + ", items=" + String.valueOf(this.getItems()) + ", emptyCause=" + this.getEmptyCause() + ", domain=" + String.valueOf(this.getDomain()) + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsCollection)) {
            return false;
        }
        TsCollection other = (TsCollection)o;
        TsMoniker this$moniker = this.getMoniker();
        TsMoniker other$moniker = other.getMoniker();
        if (this$moniker == null ? other$moniker != null : !((Object)this$moniker).equals(other$moniker)) {
            return false;
        }
        TsInformationType this$type = this.getType();
        TsInformationType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Map<String, String> this$meta = this.getMeta();
        Map<String, String> other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
            return false;
        }
        List<Ts> this$items = this.getItems();
        List<Ts> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        String this$emptyCause = this.getEmptyCause();
        String other$emptyCause = other.getEmptyCause();
        return !(this$emptyCause == null ? other$emptyCause != null : !this$emptyCause.equals(other$emptyCause));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TsMoniker $moniker = this.getMoniker();
        result = result * 59 + ($moniker == null ? 43 : ((Object)$moniker).hashCode());
        TsInformationType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Map<String, String> $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        List<Ts> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        String $emptyCause = this.getEmptyCause();
        result = result * 59 + ($emptyCause == null ? 43 : $emptyCause.hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull TsCollection withName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.name == name ? this : new TsCollection(this.moniker, this.type, name, this.meta, this.items, this.emptyCause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @Generated
    public TsDomain getDomain() {
        Object $value = this.domain.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.domain;
            synchronized (atomicReference) {
                $value = this.domain.get();
                if ($value == null) {
                    TsDomain actualValue = TsCollection.initDomain(this.items);
                    $value = actualValue == null ? this.domain : actualValue;
                    this.domain.set($value);
                }
            }
        }
        return (TsDomain)($value == this.domain ? null : $value);
    }

    @Generated
    public static class Builder {
        @Generated
        private TsMoniker moniker;
        @Generated
        private TsInformationType type;
        @Generated
        private String name;
        @Generated
        private ArrayList<String> meta$key;
        @Generated
        private ArrayList<String> meta$value;
        @Generated
        private ArrayList<Ts> items;
        @Generated
        private String emptyCause;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder moniker(@NonNull TsMoniker moniker) {
            if (moniker == null) {
                throw new NullPointerException("moniker is marked non-null but is null");
            }
            this.moniker = moniker;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder type(@NonNull TsInformationType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder meta(String metaKey, String metaValue) {
            if (this.meta$key == null) {
                this.meta$key = new ArrayList();
                this.meta$value = new ArrayList();
            }
            this.meta$key.add(metaKey);
            this.meta$value.add(metaValue);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder meta(@org.jspecify.annotations.NonNull Map<? extends String, ? extends String> meta) {
            if (meta == null) {
                throw new NullPointerException("meta cannot be null");
            }
            if (this.meta$key == null) {
                this.meta$key = new ArrayList();
                this.meta$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : meta.entrySet()) {
                this.meta$key.add($lombokEntry.getKey());
                this.meta$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearMeta() {
            if (this.meta$key != null) {
                this.meta$key.clear();
                this.meta$value.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder item(Ts item) {
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.add(item);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder items(@org.jspecify.annotations.NonNull Collection<? extends Ts> items) {
            if (items == null) {
                throw new NullPointerException("items cannot be null");
            }
            if (this.items == null) {
                this.items = new ArrayList();
            }
            this.items.addAll(items);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearItems() {
            if (this.items != null) {
                this.items.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder emptyCause(@Nullable String emptyCause) {
            this.emptyCause = emptyCause;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull TsCollection build() {
            Map<String, String> meta;
            switch (this.meta$key == null ? 0 : this.meta$key.size()) {
                case 0: {
                    meta = Collections.emptyMap();
                    break;
                }
                case 1: {
                    meta = Collections.singletonMap(this.meta$key.get(0), this.meta$value.get(0));
                    break;
                }
                default: {
                    meta = new LinkedHashMap(this.meta$key.size() < 0x40000000 ? 1 + this.meta$key.size() + (this.meta$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.meta$key.size(); ++$i) {
                        meta.put(this.meta$key.get($i), this.meta$value.get($i));
                    }
                    meta = Collections.unmodifiableMap(meta);
                }
            }
            return new TsCollection(this.moniker, this.type, this.name, meta, switch (this.items == null ? 0 : this.items.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.items.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Ts>(this.items));
            }, this.emptyCause);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "TsCollection.Builder(moniker=" + String.valueOf(this.moniker) + ", type=" + String.valueOf((Object)this.type) + ", name=" + this.name + ", meta$key=" + String.valueOf(this.meta$key) + ", meta$value=" + String.valueOf(this.meta$value) + ", items=" + String.valueOf(this.items) + ", emptyCause=" + this.emptyCause + ")";
        }
    }
}

