### Name: vgram.matrix
### Title: Computes a variogram from an image
### Aliases: vgram.matrix
### Keywords: spatial

### ** Examples

# variogram for Lennon image.
data(lennon)
out<-vgram.matrix( lennon) 

plot( out$d, out$vgram, xlab="separation distance", ylab="variogram") 
# image plot of vgram values by direction.  

# look at different directions 
out<-vgram.matrix( lennon, R=10, collapse=FALSE) #this takes a bit of time 

set.panel(2,1)
plot( out$d, out$vgram) 
plot(out$d, out$vgram.robust) 

#image plot of variogram values for different directions. 
set.panel(1,1)
plot.vgram.matrix( out)
# John Lennon appears remarkably isotropic!




