md.plot               package:siggenes               R Documentation

_M_D _P_l_o_t

_D_e_s_c_r_i_p_t_i_o_n:

     Generates an MD plot for a specified value of Delta.

     Contrary to a SAM plot in which the observed values of the test
     statistic D are plotted against the expected ones, the difference
     M  between the observed and the expected values are plotted
     against the observed values in an MD plot.

_U_s_a_g_e:

       md.plot(object, delta, pos.stats = 1, sig.col = 3, xlim = NULL, ylim = NULL, 
             main = NULL, xlab = NULL, ylab = NULL, xsym = NULL, ysym = NULL, 
             forceDelta = FALSE, includeZero = TRUE, lab = c(10, 10, 7), pch = NULL, 
             sig.cex = 1, ...)

_A_r_g_u_m_e_n_t_s:

  object: an object of class SAM.

   delta: a numeric value specifying the value of Delta for which the
          SAM plot should be generated.

pos.stats: an integer between 0 and 2. If 'pos.stats = 1', general
          information as the number of significant genes and the
          estimated FDR for the specified value of 'delta' will be
          plotted in the upper left corner of the plot. If 'pos.stats =
          2', these information will be plotted in the lower right
          corner. If 'pos.stats = 0', no information will be plotted.

 sig.col: a specification of the color of the significant genes. If
          'sig.col' has length 1, all the points corresponding to
          significant genes are marked in the color specified by
          'sig.col'. If 'length(sig.col) == 2', the down-regulated
          genes, i.e. the genes with negative expression score d, are
          marked in the color specified by 'sig.col'[1], and the
          up-regulated genes, i.e. the genes with positive d, are
          marked in the color specified by 'sig.col'[2].  For a
          description of how colors are specified, see 'par'.

    xlim: a numeric vector of length 2 specifying the x limits (minimum
          and maximum) of the plot.

    ylim: a numeric vector of length 2 specifying the y limits of the
          plot.

    main: a character string naming the main title of the plot.

    xlab: a character string naming the label of the x axis.

    ylab: a character string naming the label of the y axis.

    xsym: should the range of the plotted x-axis be symmetric about the
          origin? Ignored if 'xlim' is specified. If 'NULL', 'xsym'
          will be set to 'TRUE', if some of the observed values of the
          test statistic are negative. Otherwise, 'xsym' will be set to
          'FALSE'.

    ysym: should the range of the plotted y-axis be symmetric about the
          origin? Ignored if 'ylim' is specified.If 'NULL', 'ysym' will
          be set to 'TRUE', if some of the observed values of the test
          statistic are negative. Otherwise, 'ysym' will be set to
          'FALSE'.

forceDelta: should the two horizontal lines at 'delta' and -'delta' be
          within the plot region, no matter whether they are out of the
          range of the observed d values? Ignored if 'ylim' is
          specified.

includeZero: should D = 0 and M = 0 be included in the plot, although
          all observed values of D (or M) are larger than zero?

     lab: a numeric vector of length 3 specifying the approximate
          number of tickmarks on the x axis and on the y axis and the
          label size.

     pch: either an integer specifying a symbol or a single character
          to be used as the default in plotting points. For a
          description of how 'pch' can be specified, see 'par'.

 sig.cex: a numerical value giving the amount by which the symbols of
          the significant genes should be scaled relative to the
          default.

     ...: further graphical parameters. See 'plot.default' and  'par'.

_V_a_l_u_e:

     A MD plot.

_A_u_t_h_o_r(_s):

     Holger Schwender, holger.schw@gmx.de

_S_e_e _A_l_s_o:

     'sam, \code{sam.plot2}'

_E_x_a_m_p_l_e_s:

     ## Not run: 
       # Load the package multtest and the data of Golub et al. (1999)
       # contained in multtest.
       library(multtest)
       data(golub)
       
       # Perform a SAM analysis for the two class unpaired case assuming
       # unequal variances.
       sam.out <- sam(golub, golub.cl, B=100, rand=123)
       
       # Generate a SAM plot for Delta = 2
       plot(sam.out, 2)
       
       # As an alternative, the MD plot can be generated.
       md.plot(sam.out, 2)
       
     ## End(Not run)

