### Name: trend.stat
### Title: SAM Analysis of Linear Trend
### Aliases: trend.stat trend.stat.data.frame trend.stat.list
###   trend.stat.default
### Keywords: htest

### ** Examples
## Not run: 
##D   # Generate a random 1000 x 40 matrix consisting of the values
##D   # 1, 2, and 3, and representing 1000 variables and 40 observations.
##D   
##D   mat <- matrix(sample(3, 40000, TRUE), 1000)
##D   
##D   # Assume that the first 20 observations are cases, and the
##D   # remaining 20 are controls, and that the values 1, 2, 3 in mat
##D   # can be interpreted as scores for the different levels
##D   # of the variables represented by the rows of mat.
##D   
##D   cl <- rep(1:2, e=20)
##D   
##D   # Then an SAM analysis of linear trend can be done by
##D   
##D   out <- sam(mat, cl, method=trend.stat)
##D   out
##D   
##D   # The same results can also be obtained by employing
##D   # contingency tables, i.e. by specifying data as a list.
##D   # For this, we need to generate the tables summarizing
##D   # groupwise how many observations show which level at
##D   # which variable. These tables can be obtained by
##D   
##D   library(scrime)
##D   cases <- rowTables(mat[, cl==1])
##D   controls <- rowTables(mat[, cl==2])
##D   ltabs <- list(cases, controls)
##D   
##D   # And the same SAM analysis as above can then be 
##D   # performed by 
##D   
##D   out2 <- sam(ltabs, method=trend.stat, approx=TRUE)
##D   out2
## End(Not run)


