### Name: delta.plot
### Title: Delta Plots
### Aliases: delta.plot
### Keywords: hplot

### ** Examples
## Not run: 
##D   # Load the package multtest and the data of Golub et al. (1999)
##D   # contained in multtest.
##D   library(multtest)
##D   data(golub)
##D 
##D   # Perform a SAM analysis.
##D   sam.out<-sam(golub, golub.cl, B=100, rand=123)
##D   
##D   # Generate the Delta plots for the default set of Deltas computed by sam.
##D   delta.plot(sam.out)
##D   
##D   # Another way of generating the same plot.
##D   plot(sam.out)
##D 
##D   # Generate the Delta plots for Delta = 0.2, 0.4, ..., 2.
##D   plot(sam.out, seq(0.2, 2, 0.2))
## End(Not run)


