### Name: qpNrr
### Title: Non-rejection rate estimation
### Aliases: qpNrr qpNrr,ExpressionSet-method qpNrr,data.frame-method
###   qpNrr,matrix-method
### Keywords: models multivariate

### ** Examples

nVar <- 50 # number of variables
maxCon <- 5  # maximum connectivity per variable
nObs <- 30 # number of observations to simulate

I <- qpRndGraph(n.vtx=nVar, n.bd=maxCon)
K <- qpI2K(I)

X <- qpSampleMvnorm(K, nObs)

nrr.estimates <- qpNrr(X, q=5, verbose=FALSE)

summary(nrr.estimates[upper.tri(nrr.estimates) & I])

summary(nrr.estimates[upper.tri(nrr.estimates) & !I])




