### Name: qpIPF
### Title: Iterative proportional fitting algorithm
### Aliases: qpIPF
### Keywords: models multivariate

### ** Examples

nVar <- 50 # number of variables
maxCon <- 5  # maximum connectivity per variable
nObs <- 10 # number of observations to simulate

I <- qpRndGraph(n.vtx=nVar, n.bd=maxCon)
K <- qpI2K(I)
Sigma <- qpDscale(solve(K)) # true covariance matrix

X <- qpSampleMvnorm(K, nObs)

# scaled sample covariance matrix
S <- qpDscale(cov(X))

# more efficient scaled sample covariance matrix
clqs <- qpGetCliques(I, verbose=FALSE)
S2 <- qpIPF(S, clqs)
S2 <- qpDscale(S2)

# mean squared error of S
mean((abs(Sigma-S)^2)[upper.tri(Sigma)])

# mean squared error of S2
mean((abs(Sigma-S2)^2)[upper.tri(Sigma)])




