### Name: qpEdgeNrr
### Title: Non-rejection rate estimation for a pair of variables
### Aliases: qpEdgeNrr qpEdgeNrr,ExpressionSet-method
###   qpEdgeNrr,data.frame-method qpEdgeNrr,matrix-method
### Keywords: models multivariate

### ** Examples

# in this graph 3 is conditional independent of 4 given 1 AND 2

I <- matrix(c(FALSE,  TRUE,  TRUE,  TRUE,
              TRUE,  FALSE,  TRUE,  TRUE,
              TRUE,   TRUE, FALSE, FALSE,
              TRUE,   TRUE, FALSE, FALSE), nrow=4, ncol=4, byrow=TRUE)
K <- qpI2K(I)

X <- qpSampleMvnorm(K, N=100)

qpEdgeNrr(X, i=3, j=4, q=1, long.dim.are.variables=FALSE)

qpEdgeNrr(X, i=3, j=4, q=2, long.dim.are.variables=FALSE)



