### Name: qpAvgNrr
### Title: Average non-rejection rate estimation
### Aliases: qpAvgNrr qpAvgNrr,ExpressionSet-method
###   qpAvgNrr,data.frame-method qpAvgNrr,matrix-method
### Keywords: models multivariate

### ** Examples

nVar <- 50 # number of variables
maxCon <- 5  # maximum connectivity per variable
nObs <- 30 # number of observations to simulate

I <- qpRndGraph(n.vtx=nVar, n.bd=maxCon)
K <- qpI2K(I)

X <- qpSampleMvnorm(K, nObs)

avgnrr.estimates <- qpAvgNrr(X, verbose=FALSE)

summary(avgnrr.estimates[upper.tri(avgnrr.estimates) & I])

summary(avgnrr.estimates[upper.tri(avgnrr.estimates) & !I])




