### Encoding: latin1

### Name: robustPca
### Title: PCA implementation based on robustSvd
### Aliases: robustPca
### Keywords: multivariate

### ** Examples

## Load a complete sample metabolite data set and mean center the data
data(metaboliteDataComplete)
mdc <- scale(metaboliteDataComplete, center=TRUE, scale=FALSE)
## Now create 5% of outliers.
cond   <- runif(length(mdc)) < 0.05;
mdcOut <- mdc
mdcOut[cond] <- 10

## Now we do a conventional PCA and robustPca on the original and the data
## with outliers.
## We use center=FALSE here because the large artificial outliers would
## affect the means and not allow to objectively compare the results.
resSvd    <- pca(mdc, method = "svd", nPcs = 10, center = FALSE)
resSvdOut <- pca(mdcOut, method = "svd", nPcs = 10, center = FALSE)
resRobPca <- pca(mdcOut, method = "robustPca", nPcs = 10, center = FALSE)

## Now we plot the results for the original data against those with outliers
## We can see that robustPca is hardly effected by the outliers.
plot(resSvd@loadings[,1], resSvdOut@loadings[,1])
plot(resSvd@loadings[,1], resRobPca@loadings[,1])




