###################################################
### chunk number 1: setup
###################################################
options(width=60)
options(continue=" ")
options(prompt="R> ")


###################################################
### chunk number 2: getRawData
###################################################
library("oligo")
library("hapmap100kxba")
pathCelFiles <- system.file("celFiles", package="hapmap100kxba")
fullFilenames <- list.celfiles(path=pathCelFiles, full.names=TRUE)
outputDir <- file.path(getwd(), "crlmmTest")


###################################################
### chunk number 3: crlmm
###################################################
crlmm(fullFilenames, outputDir, verbose=FALSE)


###################################################
### chunk number 4: theCalls
###################################################
crlmmOut <- getCrlmmSummaries(outputDir)
calls(crlmmOut)[1:5,1:2]
callsConfidence(crlmmOut)[1:5,1:2]


###################################################
### chunk number 5: theCalls
###################################################
crlmmCalls <- readSummaries("calls", outputDir)
crlmmConf <- readSummaries("conf", outputDir)
crlmmCalls[1:5, 1:2]
crlmmConf[1:5, 1:2]


###################################################
### chunk number 6: alleleA
###################################################
alleleAsense <- readSummaries("alleleA-sense", outputDir)[1:5,]
alleleBsense <- readSummaries("alleleB-sense", outputDir)[1:5,]
log.ratios.sense <- alleleAsense-alleleBsense
log.ratios.sense[, 1:2]


###################################################
### chunk number 7: clean
###################################################
unlink(outputDir, recursive=TRUE)


###################################################
### chunk number 8: 
###################################################
conn <- db(pd.mapping50k.xba240)
dbListTables(conn)
dbListFields(conn, "featureSet")
sql <- "SELECT man_fsetid, chrom, physical_pos FROM featureSet WHERE man_fsetid LIKE 'SNP%' LIMIT 5"
dbGetQuery(conn, sql)


###################################################
### chunk number 9: 
###################################################
sessionInfo()


