vis.res                package:minet                R Documentation

_V_i_s_u_a_l_i_z_e _R_e_s_u_l_t_s

_D_e_s_c_r_i_p_t_i_o_n:

     A group of functions to plot precision-recall and ROC curves and
     to compute f-scores from the  data.frame returned by the
     'validate' function.

_U_s_a_g_e:

       pr(table)
       rates(table)
       fscores(table, beta=1)
       show.pr(table,device=-1,...)
       show.roc(table,device=-1,...)

_A_r_g_u_m_e_n_t_s:

   table: This is the ('steps' x 5) data.frame returned by the
          'validate' function where  'steps' is the number of
          thresholds used in the validation process and where columns
          contain  TP,FP,TN,FN values (confusion matrix) as well as the
          threshold value used  - see 'validate'.

    beta: Numeric used as the weight of the recall in the f-score
          formula - see details. The default value of this argument is
          1, meaning precision as important as recall.

  device: The device to be used. This parameter allows the user to plot
          precision-recall and  receiver operating characteristic
          curves for various inference algorithms on the same plotting
          window - see examples.

     ...: arguments passed to 'plot' 

_D_e_t_a_i_l_s:


        A confusion matrix contains FP,TP,FN,FP values.

        *  "true positive rate" tpr = TP/(TN+TP)

        *  "false positive rate" fpr = FP/(FN+FP)      

        *  "precision" p = TP/(FP+TP)

        *  "recall" r = TP/(TP+FN)

        *  "f-beta-score" Fbeta = (1+beta) * p*r/(r + beta*p)

_V_a_l_u_e:

     The function 'show.roc' ('show.pr') plots the ROC-curve (PR-curve)
     and returns the device associated with the plotting window.

     The function 'pr' returns a ('steps' x 2) data.frame where steps
     is the number of thresholds used  in the validation process. The
     first column contains precisions and the second recalls - see
     details.

     The function 'rates' also returns a ('steps' x 2) data.frame where
     the first column contains true  positive rates and the second
     column false positive rates - see details.  

     The function 'fscores' returns 'steps' fscores according to the
     'steps' confusion matrices  contained in the 'table' argument -
     see details.

_R_e_f_e_r_e_n_c_e_s:

     Patrick E. Meyer, Kevin Kontos, Frederic Lafitte, and Gianluca
     Bontempi.  Information-theoretic inference of large
     transcriptional regulatory networks. EURASIP Journal on
     Bioinformatics and Systems Biology, 2007.

_S_e_e _A_l_s_o:

     'validate',  'plot'

_E_x_a_m_p_l_e_s:

     data(syn.data)
     data(syn.net)
     # Inference
     mr <- minet( syn.data, method="mrnet", estimator="mi.empirical" )
     ar <- minet( syn.data, method="aracne", estimator="mi.empirical" )
     clr<- minet( syn.data, method="clr", estimator="mi.empirical" )
     # Validation
     mr.tbl <- validate(mr,syn.net)
     ar.tbl <- validate(ar,syn.net)
     clr.tbl<- validate(clr,syn.net)
     # Plot PR-Curves
     max(fscores(mr.tbl))
     dev <- show.pr(mr.tbl, col="green", type="b")
     dev <- show.pr(ar.tbl, device=dev, col="blue", type="b")
     show.pr(clr.tbl, device=dev, col="red",type="b")

