### Name: somM
### Title: Function to do SOM cluster analysis
### Aliases: somM
### Keywords: hplot

### ** Examples

## Loading the dataset
data(gastro)

## Doing a SOM cluster with 2 groups using all genes, for maigesRaw class
somM(gastro.raw, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
     sLabelID="Sample", gLabelID="Name", xdim=2, ydim=1, topol="rect")

## Doing a SOM cluster with 3 groups using all genes, for maigesNorm class
somM(gastro.norm, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
     sLabelID="Sample", gLabelID="Name", xdim=3, ydim=1, topol="rect")

## Another example with 4 groups
somM(gastro.norm, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
     sLabelID="Sample", gLabelID="Name", xdim=2, ydim=2, topol="rect")

## If you want to use euclidean distance to group genes (or spots), with
## 3 groups
somM(gastro.summ, rmGenes=c("BLANK","DAP","LYS","PHE", "Q_GENE","THR","TRP"),
     sLabelID="Sample", gLabelID="Name", group="R",
     distance="euclidean", xdim=3, ydim=1, topol="rect")



