###################################################
### chunk number 1: library
###################################################
library(lapmix)


###################################################
### chunk number 2: sim
###################################################
set.seed(1011)
G <- 3000
Y <- NULL
sigma_sq <- 1/rgamma(G, shape=2.8, scale=0.04)
mu <- rexp(G, rate=1/(sigma_sq*1.2))-rexp(G, rate=1/(sigma_sq*1.2))
is.diff <- sample(c(0,1), replace=TRUE, prob=c(0.9,0.1), size=G)
mu <- mu*is.diff
for(g in 1:G)
	Y <- rbind(Y, rnorm(4,mu[g], sd=sqrt(sigma_sq[g])))


###################################################
### chunk number 3: fit
###################################################
res <- lapmix.Fit(Y)


###################################################
### chunk number 4: estimates
###################################################
res$estimates


###################################################
### chunk number 5: table
###################################################
m <- 12
laptopTable(res, m)


###################################################
### chunk number 6: 
###################################################
lap.volcanoplot(res)


###################################################
### chunk number 7: fitasym
###################################################
res2 <- lapmix.Fit(Y, asym=TRUE)
res2$estimates


