### Name: iterateBMAglm.wrapper
### Title: Iterative Bayesian Model Averaging
### Aliases: iterateBMAglm.wrapper
### Keywords: multivariate classif

### ** Examples

library (Biobase)
library (BMA)
library (iterativeBMA)
data(trainData)
data(trainClass)

## Use the BSS/WSS ratio to rank all genes in the training data
sorted.vec <- BssWssFast (t(exprs(trainData)), trainClass, numClass = 2)
## get the top ranked 50 genes
sorted.train.dat <- t(exprs(trainData[sorted.vec$ix[1:50], ]))
 
## run iterative bic.glm
ret.bic.glm <- iterateBMAglm.wrapper (sorted.train.dat, y=trainClass)

## The above commands are equivalent to the following 
ret.bic.glm <- iterateBMAglm.train (train.expr.set=trainData, trainClass, p=50)




