### Name: createFlowReport
### Title: Produce a denormalized data frame of summary statistics and
###   other information on a set of FlowJo gated FCS files
### Aliases: createFlowReport createFlowReport,fcsSummaryList-method
### Keywords: methods list

### ** Examples


library(flowFlowJo);
demoLocation <- system.file("extdata", "DemoWorkspace.wsp", package="flowFlowJo"); 
actualFCSLoc <- system.file("extdata/fcsFiles", package="flowFlowJo"); 
testList     <- readFlowJoList(demoLocation, altFileLocation=actualFCSLoc);

# This next statement may take a few moments to run as it is parsing through a FlowJo workspace
# and two dozen FCS files...
summaryStatsObj <- collectSummaryFlowInfo(testList);

# And here are some of the summary statistics for this workspace
flowReport      <- createFlowReport(summaryStatsObj);
head(flowReport);




