### Name: compress
### Title: Compress an alignment object
### Aliases: compress decompress compress,clusterAlignment-method
###   decompress,clusterAlignment-method compress,peaksAlignment-method
###   decompress,peaksAlignment-method compress,progressiveAlignment-method
###   decompress,progressiveAlignment-method
### Keywords: manip

### ** Examples

require(gcspikelite)

# paths and files
gcmsPath<-paste(.find.package("gcspikelite"),"data",sep="/")
cdfFiles<-dir(gcmsPath,"CDF",full=TRUE)
eluFiles<-dir(gcmsPath,"ELU",full=TRUE)

# read data, peak detection results
pd<-peaksDataset(cdfFiles[1:2],mz=seq(50,550),rtrange=c(7.5,8.5))
pd<-addAMDISPeaks(pd,eluFiles[1:2])

# pairwise alignment (it is compressed by default)
ca<-clusterAlignment(pd, usePeaks = TRUE, df = 20)
object.size(ca)

# decompress 
ca<-decompress(ca)
object.size(ca)



