### Name: tau2.0.objective
### Title: Objective function for tau2
### Aliases: tau2.0.objective
### Keywords: algebra

### ** Examples

y<-matrix(rnbinom(20,size=1,mu=10),nrow=5)
x<-DGEList(data=y,group=rep(1:2,each=2),lib.size=rep(1000:1001,each=2))
scores <- condLogLikDerDelta(y, delta=0.5, der = 1, doSum = TRUE) 
qA <- quantileAdjust(x, alpha = 10, null.hypothesis = TRUE)
exp.inf <- approx.expected.info(x, d=0.5, qA)
sigma2.0.est <- optimize(tau2.0.objective, c(0, 500), info.g = exp.inf, score.g = scores)$min



