### Name: setRectRegion
### Title: set a rectangular or circular region in an affybatch to a
###   specified set of values
### Aliases: setRectRegion setCircRegion getRectRegion getCircRegion
### Keywords: models

### ** Examples

library(affydata)
data(Dilution)
opar = par(no.readonly=TRUE)
par(mfrow=c(2,2))
hist(Dilution, main="original")
image(Dilution[,1], main="original")
#
# we will contaminate in two ways: thin line at fixed low intensity, and 
# circular blob at moderate random intensity
#
ab = setRectRegion(Dilution, 1, xinds=25:30, yinds=1:620,
  vals=10)
ab = setCircRegion(ab, 1, valgen=function(n){
   rnorm(n, 350,50)})
hist(ab, main="chip 1 contaminated by normal")
image(ab[,1], main="chip 1 contaminated")
ex = getCircRegion(Dilution, 1)
length(ex)
ab = setCircRegion(Dilution, 1, vals=pmin(2*ex,65535))
image(ab[,1], main="chip 1 contaminated by doubling")
par(opar)



