### Name: tsSample-class
### Title: Class for representing samples
### Aliases: tsSample-class [,tsSample-method $,tsSample-method
###   CDFfiles,tsSample-method CDFfiles CDFfiles<-,tsSample-method
###   CDFfiles<- RIfiles,tsSample-method RIfiles RIfiles<-,tsSample-method
###   RIfiles<- CDFpath,tsSample-method CDFpath CDFpath<-,tsSample-method
###   CDFpath<- RIpath,tsSample-method RIpath RIpath<-,tsSample-method
###   RIpath<- length,tsSample-method sampleData,tsSample-method sampleData
###   sampleDays,tsSample-method sampleDays sampleDays<-,tsSample-method
###   sampleDays<- sampleNames,tsSample-method sampleNames
###   sampleNames<-,tsSample-method sampleNames<- show,tsSample-method
### Keywords: classes

### ** Examples

showClass("tsSample")

# get a list of CDF files from a directory
require(TargetSearchData)
CDFpath <- system.file("gc-ms-data", package = "TargetSearchData")
cdffiles <- dir(CDFpath, "cdf")

# define the RI files and the RI path
RIfiles <- sub("cdf$", "txt", paste("RI_", cdffiles, sep = ""))
RIpath  <- "."

# get the measurement days (the four first numbers of the cdf files, in this
# example)
days <- substring(cdffiles, 1, 4)

# sample names 
smp_names <- sub("\.cdf", "", cdffiles)

# add some sample info
smp_data <- data.frame(CDF_FILE =cdffiles, GROUP = gl(5,3))

# create the sample object
sampleDescription <- new("tsSample", Names = smp_names, CDFfiles = cdffiles, CDFpath = CDFpath,
    RIpath = RIpath, days = days, RIfiles = RIfiles, data = smp_data)

# changing the sample names
sampleNames(sampleDescription) <- paste("Sample", 1:length(sampleDescription), sep = "_")

# changing the file paths (relative to the working path)
CDFpath(sampleDescription) <- "my_cdfs/"
RIpath(sampleDescription)  <- "my_RIs/"




