### Name: tsRim-class
### Title: Class for representing retention index markers
### Aliases: tsRim-class rimLimits,tsRim-method rimLimits
###   rimLimits<-,tsRim-method rimLimits<- rimMass,tsRim-method rimMass
###   rimMass<-,tsRim-method rimMass<- rimStandard,tsRim-method rimStandard
###   rimStandard<-,tsRim-method rimStandard<-
### Keywords: classes

### ** Examples

showClass("tsRim")

# create a rimLimit object:
#  - set the lower (first column) and upper (second column) time limites to
#    search for standards.
Lim <- rbind(c(200, 300), c(400,450), c(600,650))
#  - set the retention indices of the standard
Std <- c(250000, 420000, 630000)
#  - set the mass marker
mass <- 87
#  - create the object
rimLimits <- new("tsRim", limits = Lim, standard = Std, mass = mass)

# sometimes you need to change the limits of a particular standard
rimLimits(rimLimits)[2,] <- c(410, 450)

# to change the mass value
rimMass(rimLimits) <- 85



